/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.vfs.YAMLVFSEntry;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.path;
import org.llvm.support.yaml.YamlGlobals;

public class JSONWriter
implements Destructors.ClassWithDestructor {
    private raw_ostream OS;
    private SmallVector<StringRef> DirStack;

    private int getDirIndent() {
        return 4 * this.DirStack.size();
    }

    private int getFileIndent() {
        return 4 * (this.DirStack.size() + 1);
    }

    private boolean containedIn(StringRef Parent, StringRef Path) {
        path.const_iterator IParent = path.begin((StringRef)Parent);
        path.const_iterator EParent = path.end((StringRef)Parent);
        path.const_iterator IChild = path.begin((StringRef)Path);
        path.const_iterator EChild = path.end((StringRef)Path);
        while (IParent.$noteq((Object)EParent) && IChild.$noteq((Object)EChild)) {
            if (llvm.$noteq_StringRef((StringRef)IParent.$star(), (StringRef)IChild.$star())) {
                return false;
            }
            IParent.$preInc();
            IChild.$preInc();
        }
        return IParent.$eq((Object)EParent);
    }

    private StringRef containedPart(StringRef Parent, StringRef Path) {
        assert (!Parent.empty());
        assert (this.containedIn(new StringRef(Parent), new StringRef(Path)));
        return Path.slice(Parent.size() + 1, StringRef.npos);
    }

    private void startDirectory(StringRef Path) {
        StringRef Name = this.DirStack.empty() ? new StringRef(Path) : this.containedPart(new StringRef((StringRef)this.DirStack.back()), new StringRef(Path));
        this.DirStack.push_back((Object)Path);
        int Indent = this.getDirIndent();
        this.OS.indent(Indent).$out("{\n");
        this.OS.indent(Indent + 2).$out("'type': 'directory',\n");
        this.OS.indent(Indent + 2).$out("'name': \"").$out(YamlGlobals.escape((StringRef)new StringRef(Name))).$out("\",\n");
        this.OS.indent(Indent + 2).$out("'contents': [\n");
    }

    private void endDirectory() {
        int Indent = this.getDirIndent();
        this.OS.indent(Indent + 2).$out("]\n");
        this.OS.indent(Indent).$out(NativePointer.$RCURLY);
        this.DirStack.pop_back();
    }

    private void writeEntry(StringRef VPath, StringRef RPath) {
        int Indent = this.getFileIndent();
        this.OS.indent(Indent).$out("{\n");
        this.OS.indent(Indent + 2).$out("'type': 'file',\n");
        this.OS.indent(Indent + 2).$out("'name': \"").$out(YamlGlobals.escape((StringRef)new StringRef(VPath))).$out("\",\n");
        this.OS.indent(Indent + 2).$out("'external-contents': \"").$out(YamlGlobals.escape((StringRef)new StringRef(RPath))).$out(NativePointer.$QUOTE_LF);
        this.OS.indent(Indent).$out(NativePointer.$RCURLY);
    }

    public JSONWriter(raw_ostream OS) {
        this.OS = OS;
        this.DirStack = new SmallVector(16, (Object)new StringRef());
    }

    public void write(ArrayRef<YAMLVFSEntry> Entries, ADTAliases.OptionalBool UseExternalNames, ADTAliases.OptionalBool IsCaseSensitive, ADTAliases.OptionalBool IsOverlayRelative, StringRef OverlayDir) {
        this.OS.$out("{\n  'version': 0,\n");
        if (IsCaseSensitive.hasValue()) {
            this.OS.$out("  'case-sensitive': '").$out(IsCaseSensitive.getValue() ? NativePointer.$true : NativePointer.$false).$out("',\n");
        }
        if (UseExternalNames.hasValue()) {
            this.OS.$out("  'use-external-names': '").$out(UseExternalNames.getValue() ? NativePointer.$true : NativePointer.$false).$out("',\n");
        }
        boolean UseOverlayRelative = false;
        if (IsOverlayRelative.hasValue()) {
            UseOverlayRelative = IsOverlayRelative.getValue();
            this.OS.$out("  'overlay-relative': '").$out(UseOverlayRelative ? NativePointer.$true : NativePointer.$false).$out("',\n");
        }
        this.OS.$out("  'roots': [\n");
        if (!Entries.empty()) {
            YAMLVFSEntry Entry2 = (YAMLVFSEntry)Entries.front();
            this.startDirectory(path.parent_path((StringRef)new StringRef(Entry2.VPath)));
            StringRef RPath = new StringRef(Entry2.RPath);
            if (UseOverlayRelative) {
                int OverlayDirLen = OverlayDir.size();
                assert (llvm.$eq_StringRef((StringRef)RPath.substr(0, OverlayDirLen), (StringRef)OverlayDir)) : "Overlay dir must be contained in RPath";
                RPath.$assignMove(RPath.slice(OverlayDirLen, RPath.size()));
            }
            this.writeEntry(path.filename((StringRef)new StringRef(Entry2.VPath)), new StringRef(RPath));
            for (YAMLVFSEntry _Entry : Entries.slice(1)) {
                StringRef Dir = path.parent_path((StringRef)new StringRef(_Entry.VPath));
                if (llvm.$eq_StringRef((StringRef)Dir, (StringRef)((StringRef)this.DirStack.back()))) {
                    this.OS.$out(",\n");
                } else {
                    while (!this.DirStack.empty() && !this.containedIn(new StringRef((StringRef)this.DirStack.back()), new StringRef(Dir))) {
                        this.OS.$out(NativePointer.$LF);
                        this.endDirectory();
                    }
                    this.OS.$out(",\n");
                    this.startDirectory(new StringRef(Dir));
                }
                StringRef _RPath = new StringRef(_Entry.RPath);
                if (UseOverlayRelative) {
                    int OverlayDirLen = OverlayDir.size();
                    assert (llvm.$eq_StringRef((StringRef)_RPath.substr(0, OverlayDirLen), (StringRef)OverlayDir)) : "Overlay dir must be contained in RPath";
                    _RPath.$assignMove(_RPath.slice(OverlayDirLen, _RPath.size()));
                }
                this.writeEntry(path.filename((StringRef)new StringRef(_Entry.VPath)), new StringRef(_RPath));
            }
            while (!this.DirStack.empty()) {
                this.OS.$out(NativePointer.$LF);
                this.endDirectory();
            }
            this.OS.$out(NativePointer.$LF);
        }
        this.OS.$out("  ]\n").$out("}\n");
    }

    public void $destroy() {
        this.DirStack.$destroy();
    }

    public String toString() {
        return "OS=" + this.OS + ", DirStack=" + this.DirStack;
    }
}

