/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.markup;

import org.clang.basic.CharSourceRange;
import org.clang.basic.FileID;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.markup.MarkupGlobals$EmitPlistHeader$$;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMapIteratorTypeUInt;
import org.llvm.adt.aliases.DenseMapTypeUInt;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.support.raw_ostream;

public final class MarkupGlobals {
    public static void AddFID(DenseMapTypeUInt<FileID> FIDs, SmallVectorImpl<FileID> V, SourceManager SM, SourceLocation L) {
        FileID FID = SM.getFileID(SM.getExpansionLoc(L));
        DenseMapIteratorTypeUInt I = FIDs.find((Object)FID);
        if (I.$noteq(FIDs.end())) {
            return;
        }
        FIDs.$set((Object)FID, V.size());
        V.push_back((Object)FID);
    }

    public static int GetFID(DenseMapTypeUInt<FileID> FIDs, SourceManager SM, SourceLocation L) {
        FileID FID = SM.getFileID(SM.getExpansionLoc(L));
        DenseMapIteratorTypeUInt I = FIDs.find((Object)FID);
        assert (I.$noteq(FIDs.end()));
        return I.$star().second;
    }

    public static raw_ostream Indent(raw_ostream o, int indent) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)indent)) {
            o.$out_char((byte)32);
            ++i;
        }
        return o;
    }

    public static raw_ostream EmitPlistHeader(raw_ostream o) {
        char.ptr PlistHeader = MarkupGlobals$EmitPlistHeader$$.PlistHeader;
        return o.$out(PlistHeader);
    }

    public static raw_ostream EmitInteger(raw_ostream o, long value) {
        o.$out("<integer>");
        o.$out_llong(value);
        o.$out("</integer>");
        return o;
    }

    public static raw_ostream EmitString(raw_ostream o, StringRef s) {
        o.$out("<string>");
        char.ptr I = Native.$tryClone((char.ptr)s.begin());
        char.ptr E = Native.$tryClone((char.ptr)s.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            byte c = I.$star();
            switch (c) {
                default: {
                    o.$out_char(c);
                    break;
                }
                case 38: {
                    o.$out("&amp;");
                    break;
                }
                case 60: {
                    o.$out("&lt;");
                    break;
                }
                case 62: {
                    o.$out("&gt;");
                    break;
                }
                case 39: {
                    o.$out("&apos;");
                    break;
                }
                case 34: {
                    o.$out("&quot;");
                }
            }
            I.$preInc();
        }
        o.$out("</string>");
        return o;
    }

    public static void EmitLocation(raw_ostream o, SourceManager SM, SourceLocation L, DenseMapTypeUInt<FileID> FM, int indent) {
        if (L.isInvalid()) {
            return;
        }
        FullSourceLoc Loc = new FullSourceLoc(SM.getExpansionLoc(L), SM);
        MarkupGlobals.Indent(o, indent).$out("<dict>\n");
        MarkupGlobals.Indent(o, indent).$out(" <key>line</key>");
        MarkupGlobals.EmitInteger(o, Unsigned.$uint2long((int)Loc.getExpansionLineNumber())).$out_char((byte)10);
        MarkupGlobals.Indent(o, indent).$out(" <key>col</key>");
        MarkupGlobals.EmitInteger(o, Unsigned.$uint2long((int)Loc.getExpansionColumnNumber())).$out_char((byte)10);
        MarkupGlobals.Indent(o, indent).$out(" <key>file</key>");
        MarkupGlobals.EmitInteger(o, Unsigned.$uint2long((int)MarkupGlobals.GetFID(FM, SM, new SourceLocation(Loc)))).$out_char((byte)10);
        MarkupGlobals.Indent(o, indent).$out("</dict>\n");
    }

    public static void EmitRange(raw_ostream o, SourceManager SM, CharSourceRange R, DenseMapTypeUInt<FileID> FM, int indent) {
        if (R.isInvalid()) {
            return;
        }
        assert (R.isCharRange()) : "cannot handle a token range";
        MarkupGlobals.Indent(o, indent).$out("<array>\n");
        MarkupGlobals.EmitLocation(o, SM, R.getBegin(), FM, indent + 1);
        MarkupGlobals.EmitLocation(o, SM, R.getEnd(), FM, indent + 1);
        MarkupGlobals.Indent(o, indent).$out("</array>\n");
    }
}

