/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.impl.NbBuildLogger;
import org.apache.tools.ant.module.run.StandardLogger;
import org.apache.tools.ant.module.spi.AntSession;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Redirector;
import org.openide.util.RequestProcessor;
import org.openide.windows.FoldHandle;
import org.openide.windows.IOFolding;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ForkedJavaOverride
extends Java {
    private static final RequestProcessor PROCESSOR = new RequestProcessor(ForkedJavaOverride.class.getName(), Integer.MAX_VALUE);
    public static final int LOGGER_MAX_LINE_LENGTH = Integer.getInteger("logger.max.line.length", 3000);
    private static final String JIDENT = "[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*";
    private static final Pattern STACK_TRACE = Pattern.compile("((?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.])*)([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*)[.](?:[\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*|<init>|<clinit>)[(](?:([\\p{javaJavaIdentifierStart}][\\p{javaJavaIdentifierPart}]*[.]java):([0-9]+)|Unknown Source)[)]");

    public ForkedJavaOverride() {
        this.redirector = new NbRedirector((Task)this);
        super.setFork(true);
    }

    public void setFork(boolean fork) {
    }

    private void useStandardRedirector() {
        if (this.redirector instanceof NbRedirector) {
            this.redirector = new Redirector((Task)this);
        }
        this.getProject().setProperty("USING_STANDARD_REDIRECTOR", "true");
    }

    public void setInput(File input) {
        this.useStandardRedirector();
        super.setInput(input);
    }

    public void setInputString(String inputString) {
        this.useStandardRedirector();
        super.setInputString(inputString);
    }

    public void setOutput(File out) {
        this.useStandardRedirector();
        super.setOutput(out);
    }

    public void setOutputproperty(String outputProp) {
        this.useStandardRedirector();
        super.setOutputproperty(outputProp);
    }

    public void setError(File error) {
        this.useStandardRedirector();
        super.setError(error);
    }

    public void setErrorProperty(String errorProperty) {
        this.useStandardRedirector();
        super.setErrorProperty(errorProperty);
    }

    public static class FoldingHelper {
        private final Pattern STACK_TRACE = Pattern.compile("^\\s+at.*:");
        private final Pattern EXCEPTION = Pattern.compile("^(\\.?\\w)*(Exception|Error).*");
        private FoldHandle foldHandle = null;
        boolean inStackTrace = false;

        private void checkFolds(String s, boolean error, AntSession session) {
            boolean cheap;
            boolean bl = cheap = s.length() < LOGGER_MAX_LINE_LENGTH;
            if (cheap && error && this.EXCEPTION.matcher(s).find()) {
                this.clearHandle();
                this.inStackTrace = true;
            } else if (cheap && error && this.inStackTrace && this.STACK_TRACE.matcher(s).find()) {
                if (this.foldHandle == null) {
                    this.foldHandle = IOFolding.startFold((InputOutput)session.getIO(), (boolean)true);
                }
            } else {
                this.inStackTrace = false;
                this.clearHandle();
            }
        }

        void clearHandle() {
            if (this.foldHandle != null) {
                if (!this.foldHandle.isFinished()) {
                    this.foldHandle.silentFinish();
                }
                this.foldHandle = null;
            }
        }
    }

    private class Copier
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;
        private final Integer logLevel;
        private final String encoding;
        private final RequestProcessor.Task flusher;
        private final ByteArrayOutputStream currentLine;
        private OutputWriter ow = null;
        private boolean err;
        private AntSession session = null;
        private final FoldingHelper foldingHelper;

        public Copier(InputStream in, OutputStream out, Integer logLevel, String encoding, FoldingHelper foldingHelper) {
            this.in = in;
            this.out = out;
            this.logLevel = logLevel;
            this.encoding = encoding;
            this.foldingHelper = foldingHelper;
            if (logLevel != null) {
                this.flusher = PROCESSOR.create(new Runnable(){

                    @Override
                    public void run() {
                        Copier.this.maybeFlush();
                    }
                });
                this.currentLine = new ByteArrayOutputStream();
            } else {
                this.flusher = null;
                this.currentLine = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (this.ow == null && this.logLevel != null) {
                Vector v = ForkedJavaOverride.this.getProject().getBuildListeners();
                for (Object o : v) {
                    if (!(o instanceof NbBuildLogger)) continue;
                    NbBuildLogger l = (NbBuildLogger)o;
                    this.err = this.logLevel != 2;
                    this.ow = this.err ? l.err : l.out;
                    this.session = l.thisSession;
                    break;
                }
            }
            try {
                try {
                    int c;
                    while ((c = this.in.read()) != -1) {
                        if (this.logLevel == null) {
                            this.out.write(c);
                            this.out.flush();
                            continue;
                        }
                        Copier copier = this;
                        synchronized (copier) {
                            if (c == 10) {
                                String str = this.currentLine.toString(this.encoding);
                                int len = str.length();
                                if (len > 0 && str.charAt(len - 1) == '\r') {
                                    str = str.substring(0, len - 1);
                                }
                                this.foldingHelper.checkFolds(str, this.err, this.session);
                                if (str.length() < LOGGER_MAX_LINE_LENGTH) {
                                    if (!STACK_TRACE.matcher(str).find()) {
                                        StandardLogger.findHyperlink((String)str, (AntSession)this.session, null).println(this.session, this.err);
                                    }
                                } else {
                                    StandardLogger.findHyperlink((String)str, (AntSession)this.session, null).println(this.session, this.err);
                                }
                                ForkedJavaOverride.this.log(str, this.logLevel);
                                this.currentLine.reset();
                            } else {
                                this.currentLine.write(c);
                                if (this.currentLine.size() > 8192) {
                                    this.flusher.run();
                                } else {
                                    this.flusher.schedule(250);
                                }
                            }
                        }
                    }
                    return;
                }
                finally {
                    if (this.logLevel != null) {
                        this.maybeFlush();
                        if (this.err) {
                            this.foldingHelper.clearHandle();
                        }
                    }
                }
            }
            catch (IOException c) {
                return;
            }
            catch (ThreadDeath d) {
                return;
            }
        }

        private synchronized void maybeFlush() {
            if (this.ow == null) {
                return;
            }
            try {
                if (this.currentLine.size() > 0) {
                    String str = this.currentLine.toString(this.encoding);
                    this.ow.write(str);
                    ForkedJavaOverride.this.log(str, this.logLevel);
                }
            }
            catch (IOException iOException) {
            }
            catch (ThreadDeath threadDeath) {
                // empty catch block
            }
            this.currentLine.reset();
        }
    }

    private class NbRedirector
    extends Redirector {
        private String outEncoding;
        private String errEncoding;
        private boolean delegateOutputStream;
        private boolean delegateErrorStream;

        public NbRedirector(Task task) {
            super(task);
            this.outEncoding = System.getProperty("file.encoding");
            this.errEncoding = System.getProperty("file.encoding");
            this.delegateOutputStream = true;
            this.delegateErrorStream = true;
        }

        public ExecuteStreamHandler createHandler() throws BuildException {
            this.createStreams();
            return new NbOutputStreamHandler();
        }

        public synchronized void setOutputEncoding(String outputEncoding) {
            this.outEncoding = outputEncoding;
            super.setOutputEncoding(outputEncoding);
        }

        public synchronized void setErrorEncoding(String errorEncoding) {
            this.errEncoding = errorEncoding;
            super.setErrorEncoding(errorEncoding);
        }

        public void setOutput(File out) {
            if (out != null) {
                this.delegateOutputStream = false;
            }
            super.setOutput(out);
        }

        public synchronized void setOutput(File[] out) {
            if (out != null && out.length > 0) {
                this.delegateOutputStream = false;
            }
            super.setOutput(out);
        }

        public void setError(File error) {
            if (error != null) {
                this.delegateErrorStream = false;
            }
            super.setError(error);
        }

        public synchronized void setError(File[] error) {
            if (error != null && error.length > 0) {
                this.delegateOutputStream = false;
            }
            super.setError(error);
        }

        private class NbOutputStreamHandler
        implements ExecuteStreamHandler {
            private Thread outTask;
            private Thread errTask;
            private Thread inTask;
            private Copier outCopier;
            private Copier errCopier;
            private FoldingHelper foldingHelper = new FoldingHelper();

            NbOutputStreamHandler() {
            }

            public void start() throws IOException {
            }

            public void stop() {
                if (this.errTask != null) {
                    try {
                        this.errTask.join(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.outTask != null) {
                    try {
                        this.outTask.join(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.inTask != null) {
                    this.inTask.interrupt();
                    try {
                        this.inTask.join(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.outCopier != null) {
                    this.outCopier.maybeFlush();
                }
                if (this.errCopier != null) {
                    this.errCopier.maybeFlush();
                }
            }

            public void setProcessOutputStream(InputStream inputStream) throws IOException {
                OutputStream os = NbRedirector.this.getOutputStream();
                Integer logLevel = null;
                if (os == null || NbRedirector.this.delegateOutputStream) {
                    os = AntBridge.delegateOutputStream((boolean)false);
                    logLevel = 2;
                }
                this.outCopier = new Copier(inputStream, os, logLevel, NbRedirector.this.outEncoding, this.foldingHelper);
                this.outTask = new Thread(Thread.currentThread().getThreadGroup(), this.outCopier, "Out Thread for " + ForkedJavaOverride.this.getProject().getName());
                this.outTask.setDaemon(true);
                this.outTask.start();
            }

            public void setProcessErrorStream(InputStream inputStream) throws IOException {
                OutputStream os = NbRedirector.this.getErrorStream();
                Integer logLevel = null;
                if (os == null || NbRedirector.this.delegateErrorStream) {
                    os = AntBridge.delegateOutputStream((boolean)true);
                    logLevel = 1;
                }
                this.errCopier = new Copier(inputStream, os, logLevel, NbRedirector.this.errEncoding, this.foldingHelper);
                this.errTask = new Thread(Thread.currentThread().getThreadGroup(), this.errCopier, "Err Thread for " + ForkedJavaOverride.this.getProject().getName());
                this.errTask.setDaemon(true);
                this.errTask.start();
            }

            public void setProcessInputStream(OutputStream outputStream) throws IOException {
                InputStream is = NbRedirector.this.getInputStream();
                if (is == null) {
                    is = AntBridge.delegateInputStream();
                }
                this.inTask = new Thread(Thread.currentThread().getThreadGroup(), new Copier(is, outputStream, null, null, this.foldingHelper), "In Thread for " + ForkedJavaOverride.this.getProject().getName());
                this.inTask.setDaemon(true);
                this.inTask.start();
            }
        }
    }
}

