/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony2.annotations.validators.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.api.annotation.util.AnnotationUtils;
import org.netbeans.modules.php.spi.annotation.AnnotationLineParser;
import org.netbeans.modules.php.spi.annotation.AnnotationParsedLine;

public class TypeAnnotationLineParser
implements AnnotationLineParser {
    private static final String ANNOTATION_NAME = "Type";
    private static final Set<String> PARAM_REGEX = new HashSet<String>();

    public AnnotationParsedLine parse(String line) {
        AnnotationParsedLine.ParsedLine result = null;
        String[] tokens = line.split("\\(");
        if (tokens.length > 0 && AnnotationUtils.isTypeAnnotation((String)tokens[0], (String)ANNOTATION_NAME)) {
            String annotation = tokens[0].trim();
            String description = line.substring(annotation.length()).trim();
            HashMap<OffsetRange, String> types = new HashMap<OffsetRange, String>();
            types.put(new OffsetRange(0, annotation.length()), annotation);
            types.putAll(TypeAnnotationLineParser.extractTypes(line));
            result = new AnnotationParsedLine.ParsedLine(ANNOTATION_NAME, types, description, true);
        }
        return result;
    }

    private static Map<OffsetRange, String> extractTypes(String line) {
        Map result = AnnotationUtils.extractTypesFromParameters((String)line, PARAM_REGEX);
        for (Map.Entry entry : result.entrySet()) {
            if (!TypeAnnotationLineParser.isPhpDatatype((String)entry.getValue())) continue;
            result.remove(entry.getKey());
        }
        return result;
    }

    private static boolean isPhpDatatype(String type) {
        boolean result = false;
        if ("array".equalsIgnoreCase(type) || "bool".equalsIgnoreCase(type) || "callable".equalsIgnoreCase(type) || "float".equalsIgnoreCase(type) || "double".equalsIgnoreCase(type) || "int".equalsIgnoreCase(type) || "integer".equalsIgnoreCase(type) || "long".equalsIgnoreCase(type) || "null".equalsIgnoreCase(type) || "numeric".equalsIgnoreCase(type) || "object".equalsIgnoreCase(type) || "real".equalsIgnoreCase(type) || "resource".equalsIgnoreCase(type) || "scalar".equalsIgnoreCase(type) || "string".equalsIgnoreCase(type)) {
            result = true;
        }
        return result;
    }

    static {
        PARAM_REGEX.add("type");
    }
}

