/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.cncppunit.editor.filecreation;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.cncppunit.LibraryChecker;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

class TestLibChecker
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(TestLibChecker.class.getSimpleName(), 3);
    private static final Map<TestLibChecker, RequestProcessor.Task> CHECKERS = new HashMap<TestLibChecker, RequestProcessor.Task>();
    private final String lib;
    private final AbstractCompiler compiler;
    private ChangeListener listener;

    private TestLibChecker(String lib, AbstractCompiler compiler, ChangeListener listener) {
        this.lib = lib;
        this.compiler = compiler;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(TestLibChecker.class, (String)"MSG_Checking_Library", (Object)this.lib, (Object)this.compiler.getExecutionEnvironment()));
        progressHandle.start();
        boolean result = false;
        try {
            result = LibraryChecker.isLibraryAvailable(this.lib, this.compiler);
        }
        catch (IOException iOException) {
            progressHandle.finish();
            Map<TestLibChecker, RequestProcessor.Task> map = CHECKERS;
            synchronized (map) {
                CHECKERS.remove(this);
                if (this.listener != null) {
                    this.listener.stateChanged(new LibCheckerChangeEvent(this, result));
                }
            }
        }
        catch (CancellationException cancellationException) {
            progressHandle.finish();
            Map<TestLibChecker, RequestProcessor.Task> map = CHECKERS;
            synchronized (map) {
                CHECKERS.remove(this);
                if (this.listener != null) {
                    this.listener.stateChanged(new LibCheckerChangeEvent(this, result));
                }
            }
        }
        finally {
            progressHandle.finish();
            Map<TestLibChecker, RequestProcessor.Task> map = CHECKERS;
            synchronized (map) {
                CHECKERS.remove(this);
                if (this.listener != null) {
                    this.listener.stateChanged(new LibCheckerChangeEvent(this, result));
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestLibChecker)) {
            return false;
        }
        TestLibChecker that = (TestLibChecker)obj;
        return this.lib.equals(that.lib) && this.compiler == that.compiler;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + this.lib.hashCode();
        hash = 67 * hash + this.compiler.hashCode();
        return hash;
    }

    private static MakeConfiguration getDefaultConfiguration(Project project) {
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return (MakeConfiguration)cdp.getConfigurationDescriptor().getConfs().getActive();
    }

    private static CompilerSet getCompilerSet(Project project) {
        MakeConfiguration makeConfiguration = TestLibChecker.getDefaultConfiguration(project);
        return makeConfiguration == null ? null : makeConfiguration.getCompilerSet().getCompilerSet();
    }

    static AbstractCompiler getCCompiler(Project project) {
        CompilerSet compilerSet = TestLibChecker.getCompilerSet(project);
        return compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
    }

    static AbstractCompiler getCppCompiler(Project project) {
        CompilerSet compilerSet = TestLibChecker.getCompilerSet(project);
        return compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
    }

    static ExecutionEnvironment getExecutionEnvironment(Project project) {
        MakeConfiguration makeConfiguration = TestLibChecker.getDefaultConfiguration(project);
        return makeConfiguration == null ? null : makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RequestProcessor.Task asyncCheck(String lib, AbstractCompiler compiler, ChangeListener listener) {
        Parameters.notWhitespace((CharSequence)"lib", (CharSequence)lib);
        Parameters.notNull((CharSequence)"compiler", (Object)compiler);
        Map<TestLibChecker, RequestProcessor.Task> map = CHECKERS;
        synchronized (map) {
            TestLibChecker checker = TestLibChecker.findChecker(lib, compiler);
            if (checker == null) {
                checker = new TestLibChecker(lib, compiler, listener);
                RequestProcessor.Task task = RP.post((Runnable)checker);
                CHECKERS.put(checker, task);
                return task;
            }
            checker.listener = listener;
            return CHECKERS.get(checker);
        }
    }

    private static TestLibChecker findChecker(String lib, AbstractCompiler compiler) {
        for (TestLibChecker checker : CHECKERS.keySet()) {
            if (!checker.lib.equals(lib) || checker.compiler != compiler) continue;
            return checker;
        }
        return null;
    }

    public static final class LibCheckerChangeEvent
    extends ChangeEvent {
        private static final long serialVersionUID = -7102294055630832274L;
        private final boolean result;

        public LibCheckerChangeEvent(Object source, boolean result) {
            super(source);
            this.result = result;
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

