/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.ui.browser.BrowserAction;
import org.netbeans.modules.subversion.remote.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.remote.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.remote.ui.wizards.importstep.ImportPreviewStep;
import org.netbeans.modules.subversion.remote.ui.wizards.importstep.ImportStep;
import org.netbeans.modules.subversion.remote.ui.wizards.repositorystep.RepositoryStep;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public final class ImportWizard
implements ChangeListener {
    private WizardDescriptor.Panel[] panels;
    private RepositoryStep repositoryStep;
    private ImportStep importStep;
    private ImportPreviewStep importPreviewStep;
    private AbstractStep.WizardMessage errorMessage;
    private WizardDescriptor wizardDescriptor;
    private PanelsIterator wizardIterator;
    private final Context context;
    private final FileSystem fileSystem;

    public ImportWizard(Context context) {
        this.context = context;
        this.fileSystem = context.getFileSystem();
    }

    public boolean show() {
        boolean finnished;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(ImportWizard.class, (String)"CTL_Import"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ImportWizard.class, (String)"CTL_Import"));
        dialog.setVisible(true);
        dialog.toFront();
        Object value = this.wizardDescriptor.getValue();
        boolean bl = finnished = value == WizardDescriptor.FINISH_OPTION;
        if (!finnished) {
            if (value == WizardDescriptor.CLOSED_OPTION || value == WizardDescriptor.CANCEL_OPTION) {
                this.repositoryStep.stop();
                this.importStep.stop();
                this.importPreviewStep.stop();
            }
        } else if (value == WizardDescriptor.FINISH_OPTION) {
            if (this.wizardIterator.current() == this.importStep) {
                this.setupImportPreviewStep(true);
            } else if (this.wizardIterator.current() == this.importPreviewStep) {
                this.importPreviewStep.storeTableSorter();
                this.importPreviewStep.startCommitTask(this.repositoryStep.getRepositoryFile().getRepositoryUrl());
            }
        }
        return finnished;
    }

    private void setupImportPreviewStep(boolean startCommitTask) {
        SVNUrl repository = this.repositoryStep.getRepositoryFile().getRepositoryUrl();
        String repositoryUrl = SvnUtils.decodeToString(repository);
        String repositoryFolderUrl = SvnUtils.decodeToString(this.importStep.getRepositoryFolderUrl());
        String localPath = this.context.getRootFiles()[0].getPath();
        this.importPreviewStep.setup(repositoryFolderUrl.substring(repositoryUrl.length()), localPath, repository, this.importStep.getImportMessage(), startCommitTask);
    }

    private void setErrorMessage(AbstractStep.WizardMessage msg) {
        this.errorMessage = msg;
        if (this.wizardDescriptor != null) {
            if (this.errorMessage != null) {
                if (this.errorMessage.isInfo()) {
                    this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)this.errorMessage.getMessage());
                } else {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.errorMessage.getMessage());
                }
            } else {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.wizardIterator == null) {
            return;
        }
        AbstractStep step = (AbstractStep)this.wizardIterator.current();
        if (step == null) {
            return;
        }
        this.setErrorMessage(step.getErrorMessage());
    }

    public SVNUrl getRepositoryUrl() {
        return this.repositoryStep.getRepositoryFile().getRepositoryUrl();
    }

    public SVNUrl getRepositoryFolderUrl() {
        return this.importStep.getRepositoryFolderUrl();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor> {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            ImportWizard.this.repositoryStep = new RepositoryStep(ImportWizard.this.fileSystem, 0, "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.import");
            ImportWizard.this.repositoryStep.addChangeListener(ImportWizard.this);
            VCSFileProxy file = ImportWizard.this.context.getRootFiles()[0];
            ImportWizard.this.importStep = new ImportStep(new BrowserAction[]{new CreateFolderAction(file.getName())}, file);
            ImportWizard.this.importStep.addChangeListener(ImportWizard.this);
            ImportWizard.this.importPreviewStep = new ImportPreviewStep(ImportWizard.this.context);
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{ImportWizard.this.repositoryStep, ImportWizard.this.importStep, ImportWizard.this.importPreviewStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public void previousPanel() {
            if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.importStep.invalid(null);
            }
            super.previousPanel();
        }

        public void nextPanel() {
            if (this.current() == ImportWizard.this.repositoryStep) {
                VCSFileProxy file = ImportWizard.this.context.getRootFiles()[0];
                ImportWizard.this.importStep.setup(ImportWizard.this.repositoryStep.getRepositoryFile().appendPath(file.getName()));
            } else if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.setupImportPreviewStep(false);
            }
            super.nextPanel();
            if (this.current() == ImportWizard.this.importStep) {
                ImportWizard.this.importStep.validateUserInput();
            }
        }
    }
}

