/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.util;

import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.remotefs.versioning.api.ProjectUtilities;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;

public class CheckoutCompleted {
    private final VCSFileProxy workingFolder;
    private final String[] checkedOutFolders;

    public CheckoutCompleted(VCSFileProxy workingFolder, String[] checkedOutFolders) {
        this.checkedOutFolders = checkedOutFolders;
        this.workingFolder = workingFolder;
    }

    public void scanForProjects(SvnProgressSupport support, Type type) {
        HashMap checkedOutProjects = new HashMap();
        checkedOutProjects.put(null, new HashSet());
        VCSFileProxy normalizedWorkingFolder = this.workingFolder.normalizeFile();
        SvnUtils.refreshParents(normalizedWorkingFolder);
        FileObject fo = normalizedWorkingFolder.toFileObject();
        if (fo != null) {
            for (int i = 0; i < this.checkedOutFolders.length; ++i) {
                if (support != null && support.isCanceled()) {
                    return;
                }
                String module = this.checkedOutFolders[i];
                if (".".equals(module)) {
                    org.netbeans.modules.versioning.util.ProjectUtilities.scanForProjects((FileObject)fo, checkedOutProjects);
                    break;
                }
                FileObject subfolder = fo.getFileObject(module);
                if (subfolder == null) continue;
                org.netbeans.modules.versioning.util.ProjectUtilities.scanForProjects((FileObject)subfolder, checkedOutProjects);
            }
        }
        switch (type) {
            case EXPORT: {
                ProjectUtilities.openExportedProjects(checkedOutProjects, (VCSFileProxy)this.workingFolder);
                break;
            }
            case CHECKOUT: {
                ProjectUtilities.openCheckedOutProjects(checkedOutProjects, (VCSFileProxy)this.workingFolder);
            }
        }
    }

    public static enum Type {
        EXPORT,
        CHECKOUT;

    }
}

