/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.util;

import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.openide.awt.HtmlBrowser;

public class NotifyHtmlPanel
extends JPanel {
    private JScrollPane jScrollPane1;
    private JTextPane msgPanel;

    public NotifyHtmlPanel() {
        this.initComponents();
        Document doc = this.msgPanel.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument htmlDoc = (HTMLDocument)doc;
            Font font = UIManager.getFont("Label.font");
            String bodyRule = "body { font-family: " + font.getFamily() + "; " + "color: " + SvnUtils.getColorString(this.msgPanel.getForeground()) + "; " + "font-size: " + font.getSize() + "pt; }";
            htmlDoc.getStyleSheet().addRule(bodyRule);
        }
        this.msgPanel.setOpaque(false);
        this.msgPanel.setBackground(new Color(0, 0, 0, 0));
    }

    public void setText(String text) {
        this.msgPanel.setText(text);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.msgPanel = new JTextPane();
        this.msgPanel.setBackground(new Color(0, 0, 0, 0));
        this.msgPanel.setContentType("text/html");
        this.msgPanel.setEditable(false);
        this.msgPanel.setOpaque(false);
        this.msgPanel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                NotifyHtmlPanel.this.msgPanelHyperlinkUpdate(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.msgPanel);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 490, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 272, Short.MAX_VALUE));
    }

    private void msgPanelHyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL url = evt.getURL();
        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
        if (displayer != null) {
            displayer.showURL(url);
        } else {
            Subversion.LOG.info("No URLDisplayer found.");
        }
    }
}

