/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Adler32;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RelocatablePathMapperImpl
implements RelocatablePathMapper {
    public static final Logger LOG = Logger.getLogger(RelocatablePathMapperImpl.class.getName());
    private static final boolean TEST = false;
    private final List<MapperEntry> mapper = new ArrayList<MapperEntry>();
    private final ProjectProxy project;
    private final Map<String, Boolean> fileCache = new ConcurrentHashMap<String, Boolean>();
    private boolean isAtomatic = true;
    private static final String AUTO_SIGNATURE = "# Automatic path mapper. CRC = ";
    private static final String PATH_TO_MAPPER = "nbproject/private/CodeAssistancePathMapper.properties";
    private final boolean FORBID_AUTO_PATH_MAPPER = Boolean.getBoolean("makeproject.pathMapper.forbid_auto");

    public RelocatablePathMapperImpl(ProjectProxy project) {
        this.project = project;
        if (project != null) {
            Project makeProject = project.getProject();
            ArrayList<String> list = null;
            FileObject fo = null;
            if (makeProject != null) {
                fo = makeProject.getProjectDirectory().getFileObject(PATH_TO_MAPPER);
            }
            if (fo != null && fo.isValid()) {
                BufferedReader in = null;
                long parseLong = 0L;
                this.isAtomatic = true;
                try {
                    String line;
                    list = new ArrayList<String>();
                    in = new BufferedReader(new InputStreamReader(fo.getInputStream()));
                    while ((line = in.readLine()) != null) {
                        if (line.startsWith("#")) {
                            if (!line.startsWith(AUTO_SIGNATURE)) continue;
                            String s = line.substring(AUTO_SIGNATURE.length()).trim();
                            try {
                                parseLong = Long.parseLong(s);
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue;
                        }
                        int i = (line = line.trim()).indexOf(61);
                        if (i <= 0) continue;
                        list.add(line.substring(0, i));
                        list.add(line.substring(i + 1));
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "Cannot read mapper file {0}", fo);
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (parseLong != 0L) {
                    Adler32 checksum = new Adler32();
                    for (String s : list) {
                        for (char c : s.toCharArray()) {
                            checksum.update(c);
                        }
                    }
                    if (parseLong != checksum.getValue()) {
                        this.isAtomatic = false;
                    }
                }
            }
            if (this.isAtomatic) {
                list = null;
            }
            if (list != null) {
                for (int i = 0; i < list.size(); i += 2) {
                    if (i + 1 >= list.size()) continue;
                    this.mapper.add(new MapperEntry((String)list.get(i), (String)list.get(i + 1)));
                    LOG.log(Level.FINE, "Init path map {0} -> {1}", new Object[]{list.get(i), list.get(i + 1)});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.project != null && this.project.getProject() != null && this.isAtomatic) {
            Project nbProject = this.project.getProject();
            FileObject projectDirectory = nbProject.getProjectDirectory();
            OutputStreamWriter os = null;
            try {
                Adler32 checksum = new Adler32();
                for (MapperEntry entry : this.mapper) {
                    for (char c : entry.from.toCharArray()) {
                        checksum.update(c);
                    }
                    for (char c : entry.to.toCharArray()) {
                        checksum.update(c);
                    }
                }
                FileObject fo = FileUtil.createData((FileObject)projectDirectory, (String)PATH_TO_MAPPER);
                os = new OutputStreamWriter(fo.getOutputStream());
                os.write(AUTO_SIGNATURE + checksum.getValue());
                os.write(10);
                for (MapperEntry entry : this.mapper) {
                    os.write(entry.from + "=" + entry.to);
                    os.write(10);
                }
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RelocatablePathMapper.ResolvedPath getPath(String path) {
        path = path.replace('\\', '/');
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            for (MapperEntry entry : this.mapper) {
                if (!path.startsWith(entry.from)) continue;
                if (path.equals(entry.from)) {
                    return new ResolvedPathImpl(entry.to, entry.to);
                }
                if (path.charAt(entry.from.length()) != '/') continue;
                return new ResolvedPathImpl(entry.to, entry.to + path.substring(entry.from.length()));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MapperEntry> dump() {
        ArrayList<MapperEntry> res;
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            res = new ArrayList<MapperEntry>(this.mapper);
        }
        return res;
    }

    private boolean isExists(RelocatablePathMapper.FS fs, String path) {
        Boolean res = this.fileCache.get(path);
        if (res != null) {
            return res;
        }
        if (!this.isExistsFolder(fs, path)) {
            return false;
        }
        res = fs.exists(path);
        this.fileCache.put(path, res);
        return res;
    }

    private boolean isExistsFolder(RelocatablePathMapper.FS fs, String path) {
        String dir = CndPathUtilities.getDirName((String)path);
        if (dir != null) {
            Boolean res = this.fileCache.get(dir);
            if (res != null) {
                return res;
            }
            int sep = 0;
            for (int i = 0; i < dir.length(); ++i) {
                if (dir.charAt(i) != '/' && dir.charAt(i) != '\\') continue;
                ++sep;
            }
            if (sep <= 1) {
                res = fs.exists(dir);
                this.fileCache.put(dir, res);
                return res;
            }
            if (this.isExistsFolder(fs, dir)) {
                res = fs.exists(dir);
                this.fileCache.put(dir, res);
                return res;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean discover(RelocatablePathMapper.FS fs, String root, String unknown) {
        if (this.FORBID_AUTO_PATH_MAPPER) {
            return false;
        }
        MapperEntry mapperEntry = this.getMapperEntry(fs, root, unknown);
        if (mapperEntry == null) {
            LOG.log(Level.FINER, "Cannot discover path map of root {0} and canidate {1}", new Object[]{root, unknown});
            return false;
        }
        String to = null;
        if (unknown.startsWith(mapperEntry.from)) {
            if (unknown.equals(mapperEntry.from)) {
                to = mapperEntry.to;
            } else if (unknown.charAt(mapperEntry.from.length()) == '/') {
                to = mapperEntry.to + unknown.substring(mapperEntry.from.length());
            }
        }
        if (to != null && this.isExists(fs, unknown) && this.isExists(fs, to)) {
            boolean isEquals = true;
            List<String> list1 = fs.list(unknown);
            List<String> list2 = fs.list(to);
            for (String s : list1) {
                String name = CndPathUtilities.getBaseName((String)s);
                boolean found = false;
                for (String x : list2) {
                    if (!name.equals(CndPathUtilities.getBaseName((String)x))) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                isEquals = false;
                break;
            }
            if (!isEquals) {
                mapperEntry = new MapperEntry(unknown, unknown);
            }
        }
        LOG.log(Level.FINE, "Discover path map of root {0} and canidate {1}", new Object[]{root, unknown});
        LOG.log(Level.FINE, "Found path map {0} -> {1}", new Object[]{mapperEntry.from, mapperEntry.to});
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            if (!this.mapper.contains(mapperEntry)) {
                this.mapper.add(mapperEntry);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String from, String to) {
        MapperEntry mapperEntry = new MapperEntry(from, to);
        List<MapperEntry> list = this.mapper;
        synchronized (list) {
            this.mapper.add(mapperEntry);
        }
        return true;
    }

    private MapperEntry getMapperEntry(RelocatablePathMapper.FS fs, String root, String unknown) {
        root = root.replace('\\', '/');
        boolean driverRoot = false;
        if (root.startsWith("/")) {
            root = root.substring(1);
        } else {
            driverRoot = true;
        }
        boolean driverPath = false;
        unknown = unknown.replace('\\', '/');
        if (unknown.startsWith("/")) {
            unknown = unknown.substring(1);
        } else {
            driverPath = true;
        }
        String[] rootSegments = root.split("/");
        String[] unknownSegments = unknown.split("/");
        int min = 0;
        int k = 0;
        while (k < Math.min(unknownSegments.length, rootSegments.length) && unknownSegments[k].equals(rootSegments[k])) {
            min = k++;
        }
        if (min > 2) {
            return null;
        }
        for (k = 1; k < unknownSegments.length; ++k) {
            for (int i = rootSegments.length - 1; i > 1; --i) {
                String path;
                int j;
                StringBuilder buf = new StringBuilder();
                for (j = 0; j < i; ++j) {
                    buf.append('/');
                    buf.append(rootSegments[j]);
                }
                for (j = k; j < unknownSegments.length; ++j) {
                    buf.append('/');
                    buf.append(unknownSegments[j]);
                }
                String string = path = driverRoot ? buf.substring(1) : buf.toString();
                if (!this.isExists(fs, path)) continue;
                if (k == i) {
                    boolean startEquals = true;
                    for (int l = 0; l < k; ++l) {
                        if (unknownSegments[l].equals(rootSegments[l])) continue;
                        startEquals = false;
                        break;
                    }
                    if (startEquals) continue;
                }
                if (k < 2 && k < unknownSegments.length - 1 && i < rootSegments.length - 1 && unknownSegments[k].equals(rootSegments[i])) {
                    ++k;
                    ++i;
                }
                StringBuilder from = new StringBuilder();
                for (int j2 = 0; j2 < k; ++j2) {
                    from.append('/');
                    from.append(unknownSegments[j2]);
                }
                StringBuilder to = new StringBuilder();
                for (int j3 = 0; j3 < i; ++j3) {
                    to.append('/');
                    to.append(rootSegments[j3]);
                }
                String aFrom = driverPath ? from.substring(1) : from.toString();
                String aTo = driverRoot ? to.substring(1) : to.toString();
                return new MapperEntry(aFrom, aTo);
            }
        }
        return null;
    }

    static final class ResolvedPathImpl
    implements RelocatablePathMapper.ResolvedPath {
        private final String root;
        private final String path;

        ResolvedPathImpl(String root, String path) {
            this.root = root;
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getRoot() {
            return this.root;
        }
    }

    static final class MapperEntry {
        final String from;
        final String to;

        MapperEntry(String from, String to) {
            this.to = to;
            this.from = from;
        }

        public int hashCode() {
            int hash = 3;
            hash = 71 * hash + (this.from != null ? this.from.hashCode() : 0);
            hash = 71 * hash + (this.to != null ? this.to.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapperEntry other = (MapperEntry)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

