/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.llvm.adt.DenseMapInfo;

public class DenseMapInfoPair<T, U>
implements DenseMapInfo<std_pair.pair<T, U>> {
    private final DenseMapInfo<T> FirstInfo;
    private final DenseMapInfo<U> SecondInfo;
    private final std_pair.pair<T, U> emptyKey;
    private final std_pair.pair<T, U> tombstoneKey;

    public DenseMapInfoPair(DenseMapInfo<T> FirstInfo, DenseMapInfo<U> SecondInfo) {
        this.FirstInfo = FirstInfo;
        this.SecondInfo = SecondInfo;
        this.emptyKey = std.make_pair(FirstInfo.getEmptyKey(), SecondInfo.getEmptyKey());
        this.tombstoneKey = std.make_pair(FirstInfo.getTombstoneKey(), SecondInfo.getTombstoneKey());
    }

    @Override
    public std_pair.pair<T, U> getEmptyKey() {
        return this.emptyKey;
    }

    @Override
    public std_pair.pair<T, U> getTombstoneKey() {
        return this.tombstoneKey;
    }

    @Override
    public int getHashValue(Object PairVal) {
        assert (PairVal != this.emptyKey) : "must not be called for emptyKey";
        assert (PairVal != this.tombstoneKey) : "must not be called for tombstoneKey";
        long key = (long)this.FirstInfo.getHashValue(((std_pair.pair)PairVal).first) << 32 | (long)this.SecondInfo.getHashValue(((std_pair.pair)PairVal).second);
        key += key << 32 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 22;
        key += key << 13 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 8;
        key += key << 3;
        key ^= key >>> 15;
        key += key << 27 ^ 0xFFFFFFFFFFFFFFFFL;
        key ^= key >>> 31;
        return (int)key;
    }

    @Override
    public boolean isEqual(Object LHS, Object RHS) {
        assert (LHS != this.emptyKey) : "LHS: must not be called for emptyKey";
        assert (LHS != this.tombstoneKey) : "LHS: must not be called for tombstoneKey";
        return this.FirstInfo.isEqual(((std_pair.pair)LHS).first, ((std_pair.pair)RHS).first) && this.SecondInfo.isEqual(((std_pair.pair)LHS).second, ((std_pair.pair)RHS).second);
    }

    @Override
    public boolean isKeyPointerLike() {
        return false;
    }
}

