/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import java.util.concurrent.atomic.AtomicInteger;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.support.ValgrindGlobals;
import org.llvm.support.impl.StatisticStatics;
import org.llvm.support.sys.SmartScopedLock;
import org.llvm.support.sys.sys;

public class Statistic {
    public char.ptr Name;
    public char.ptr Desc;
    public AtomicInteger Value;
    public boolean Initialized;

    public int getValue() {
        return this.Value.get();
    }

    public char.ptr getName() {
        return this.Name;
    }

    public char.ptr getDesc() {
        return this.Desc;
    }

    public void construct(char.ptr name, char.ptr desc2) {
        this.Name = Native.$tryConstClone((char.ptr)name);
        this.Desc = Native.$tryConstClone((char.ptr)desc2);
        this.Value = new AtomicInteger(0);
        this.Initialized = false;
    }

    public int $uint() {
        return this.Value.get();
    }

    public Statistic $assign(int Val) {
        this.Value.set(Val);
        return this.init();
    }

    public Statistic $preInc() {
        sys.AtomicIncrement(this.Value);
        return this.init();
    }

    public int $postInc(int $Prm0) {
        this.init();
        int OldValue = this.Value.get();
        sys.AtomicIncrement(this.Value);
        return OldValue;
    }

    public Statistic $preDec() {
        sys.AtomicDecrement(this.Value);
        return this.init();
    }

    public int $postDec(int $Prm0) {
        this.init();
        int OldValue = this.Value.get();
        sys.AtomicDecrement(this.Value);
        return OldValue;
    }

    public Statistic $addassign(int V) {
        if (V == 0) {
            return this;
        }
        sys.AtomicAdd(this.Value, V);
        return this.init();
    }

    public Statistic $minusassign(int V) {
        if (V == 0) {
            return this;
        }
        sys.AtomicAdd(this.Value, -V);
        return this.init();
    }

    public Statistic $starassign(int V) {
        sys.AtomicMul(this.Value, V);
        return this.init();
    }

    public Statistic $slashassign(int V) {
        sys.AtomicDiv(this.Value, V);
        return this.init();
    }

    protected Statistic init() {
        boolean tmp = this.Initialized;
        sys.MemoryFence();
        if (!tmp) {
            this.RegisterStatistic();
        }
        ValgrindGlobals.AnnotateHappensAfter("${LLVM_SRC}/llvm/include/llvm/ADT/Statistic.h", 156, this);
        return this;
    }

    protected void RegisterStatistic() {
        SmartScopedLock Writer2 = null;
        try {
            Writer2 = new SmartScopedLock(true, StatisticStatics.StatLock.$star());
            if (!this.Initialized) {
                if (StatisticStatics.Enabled.$bool()) {
                    StatisticStatics.StatInfo.$arrow().addStatistic(this);
                }
                ValgrindGlobals.AnnotateHappensBefore("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 78, this);
                sys.MemoryFence();
                ValgrindGlobals.AnnotateIgnoreWritesBegin("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 81);
                this.Initialized = true;
                ValgrindGlobals.AnnotateIgnoreWritesEnd("${LLVM_SRC}/llvm/lib/Support/Statistic.cpp", 83);
            }
        }
        finally {
            if (Writer2 != null) {
                Writer2.$destroy();
            }
        }
    }

    public String toString() {
        return "Statistic{Name=" + this.Name + ", Desc=" + this.Desc + ", Value=" + this.Value + ", Initialized=" + this.Initialized + '}';
    }
}

