/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeMemory;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringMapEntryBase;
import org.llvm.adt.StringMapImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.StringMapEntry;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.support.StringMapBumpPtrAllocator;
import org.llvm.support.llvm;

public class StringMap<ValueTy>
extends StringMapImpl
implements Destructors.ClassWithDestructor,
Iterable<StringMapEntry<ValueTy>> {
    private NativeMemory.Allocator Allocator;
    private final ValueTy defaultValue;
    private final boolean isDataPointerLike;

    public StringMap(ValueTy defaultValue) {
        super(StringMapEntry.$sizeof_StringMapEntry());
        this.defaultValue = defaultValue;
        boolean bl = this.isDataPointerLike = defaultValue == null;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMap(int InitialSize, ValueTy defaultValue) {
        super(InitialSize, StringMapEntry.$sizeof_StringMapEntry());
        this.defaultValue = defaultValue;
        boolean bl = this.isDataPointerLike = defaultValue == null;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMap(NativeMemory.Allocator A, ValueTy defaultValue) {
        super(StringMapEntry.$sizeof_StringMapEntry());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
        boolean bl = this.isDataPointerLike = defaultValue == null;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
    }

    public StringMap(int InitialSize, NativeMemory.Allocator A, ValueTy defaultValue) {
        super(InitialSize, StringMapEntry.$sizeof_StringMapEntry());
        assert (A != null);
        this.Allocator = A;
        this.defaultValue = defaultValue;
        boolean bl = this.isDataPointerLike = defaultValue == null;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
    }

    public StringMap(StringMap<ValueTy> RHS, ValueTy defaultValue) {
        super(StringMapEntry.$sizeof_StringMapEntry());
        this.defaultValue = defaultValue;
        boolean bl = this.isDataPointerLike = defaultValue == null;
        assert (defaultValue == null || Native.$tryClone(defaultValue) != defaultValue) : "non cloneable class for defaultValue " + defaultValue;
        if (!RHS.empty()) {
            throw new AssertionError((Object)"Copy ctor from non-empty stringmap not implemented yet!");
        }
        this.Allocator = new StringMapBumpPtrAllocator();
    }

    public StringMap(JavaDifferentiators.JD.Move _dparam, StringMap<ValueTy> RHS) {
        super((StringMapImpl)std.move(RHS));
        this.Allocator = RHS.Allocator;
        this.defaultValue = RHS.defaultValue;
        boolean bl = this.isDataPointerLike = this.defaultValue == null;
        assert (this.defaultValue == null || Native.$tryClone(this.defaultValue) != this.defaultValue) : "non cloneable class for defaultValue " + this.defaultValue;
    }

    public StringMap<ValueTy> $assign(StringMap<ValueTy> RHS) {
        super.swap(RHS);
        assert (RHS.isDataPointerLike == this.isDataPointerLike) : RHS.isDataPointerLike + " vs. " + this.isDataPointerLike;
        NativeMemory.Allocator tmp = this.Allocator;
        this.Allocator = RHS.Allocator;
        RHS.Allocator = tmp;
        return this;
    }

    public NativeMemory.Allocator getAllocator() {
        return this.Allocator;
    }

    public StringMapIterator<ValueTy> begin() {
        return new StringMapIterator(this.TheTable, 0, this.NumBuckets == 0);
    }

    public StringMapIterator<ValueTy> end() {
        return new StringMapIterator(this.TheTable, this.NumBuckets, true);
    }

    public StringMapIterator<ValueTy> find(StringRef Key) {
        int Bucket2 = this.FindKey(Key);
        if (Bucket2 == -1) {
            return this.end();
        }
        return new StringMapIterator(this.TheTable, Bucket2, true);
    }

    public StringMapIterator<ValueTy> find(String Key) {
        return this.find(new StringRef(Key));
    }

    public StringMapIterator<ValueTy> find(char.ptr Key) {
        int Bucket2 = this.FindKey(Key, std.strlen((char.ptr)Key));
        if (Bucket2 == -1) {
            return this.end();
        }
        return new StringMapIterator(this.TheTable, Bucket2, true);
    }

    public ValueTy lookup(StringRef Key) {
        return this.lookup(Key.data(), Key.size());
    }

    public ValueTy lookup(char.ptr Key, int KeyLen) {
        int Bucket2 = this.FindKey(Key, KeyLen);
        if (Bucket2 != -1) {
            return (ValueTy)((StringMapEntry)this.TheTable[Bucket2]).getValue();
        }
        return (ValueTy)Native.$tryClone(this.defaultValue);
    }

    public ValueTy $at(String Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public ValueTy $at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public ValueTy $at(char.ptr Key) {
        return this.GetOrCreateValue(Key).getValue();
    }

    public type.ref<ValueTy> ref$at(String Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public type.ref<ValueTy> ref$at(StringRef Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public type.ref<ValueTy> ref$at(char.ptr Key) {
        return this.GetOrCreateValue(Key).getValue$Ref();
    }

    public ValueTy $set(StringRef Key, ValueTy Val) {
        this.GetOrCreateValue((StringRef)Key, null).second = this.isDataPointerLike ? Val : Native.$tryClone(Val);
        return (ValueTy)this.GetOrCreateValue((StringRef)Key, null).second;
    }

    public ValueTy $set(String Key, ValueTy Val) {
        this.GetOrCreateValue((String)Key, null).second = this.isDataPointerLike ? Val : Native.$tryClone(Val);
        return (ValueTy)this.GetOrCreateValue((String)Key, null).second;
    }

    public ValueTy $set(char.ptr Key, ValueTy Val) {
        this.GetOrCreateValue((char.ptr)Key, (int)std.strlen((char.ptr)Key), null).second = this.isDataPointerLike ? Val : Native.$tryClone(Val);
        return (ValueTy)this.GetOrCreateValue((char.ptr)Key, (int)std.strlen((char.ptr)Key), null).second;
    }

    public int count(StringRef Key) {
        return this.FindKey(Key) == -1 ? 0 : 1;
    }

    public std_pair.pairTypeBool<StringMapIterator<ValueTy>> insert(std_pair.pair<StringRef, ValueTy> KV) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = ((StringRef)KV.first).data();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = ((StringRef)KV.first).size(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntry<Object> Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMap.getTombstoneVal()) {
            return std.make_pair_T_bool(new StringMapIterator(this.TheTable, BucketNo, false), (boolean)false);
        }
        if (Bucket2 == StringMap.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket2 = StringMapEntry.Create(keyData, keyLength, FullHashValue, this.Allocator, std.move((Object)KV.second));
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        BucketNo = this.RehashTable(BucketNo);
        return std.make_pair_T_bool(new StringMapIterator(this.TheTable, BucketNo, false), (boolean)true);
    }

    public boolean insert(StringMapEntry<ValueTy> KeyValue) {
        int FullHashValue;
        int keyLength;
        char.ptr keyData = KeyValue.getKeyData();
        int BucketNo = this.LookupBucketFor(keyData, keyLength = KeyValue.getKeyLength(), FullHashValue = llvm.HashString(keyData, keyLength));
        StringMapEntry<ValueTy> Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMap.getTombstoneVal()) {
            return false;
        }
        if (Bucket2 == StringMap.getTombstoneVal()) {
            --this.NumTombstones;
        }
        this.TheTable[BucketNo] = Bucket2 = KeyValue;
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.RehashTable();
        return true;
    }

    public void clear() {
        if (this.empty()) {
            return;
        }
        int E = this.NumBuckets;
        for (int I = 0; I != E; ++I) {
            StringMapEntryBase Bucket2 = this.TheTable[I];
            this.TheTable[I] = null;
        }
        this.NumItems = 0;
        this.NumTombstones = 0;
        this.Allocator.Reset();
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(StringRef Key, ValueTy Val) {
        return this.GetOrCreateValue(Key.data(), Key.size(), Val);
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(String Key, ValueTy Val) {
        return this.GetOrCreateValue(new StringRef(Key), Val);
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(char.ptr Key, int Len, ValueTy Val) {
        int FullHashValue = llvm.HashString(Key, Len);
        int BucketNo = this.LookupBucketFor(Key, Len, FullHashValue);
        StringMapEntry<ValueTy> Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMap.getTombstoneVal()) {
            return Bucket2;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone(Val);
        }
        StringMapEntry<ValueTy> NewItem = StringMapEntry.Create(Key, Len, FullHashValue, this.Allocator, Val);
        if (Bucket2 == StringMap.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket2 = NewItem;
        this.RehashTable();
        return Bucket2;
    }

    private StringMapEntry<ValueTy> GetOrCreateValue(byte[] Key, int KeyStIndex, int Len, ValueTy Val) {
        int FullHashValue = llvm.HashString(Key, KeyStIndex, Len);
        int BucketNo = this.LookupBucketFor(Key, KeyStIndex, Len, FullHashValue);
        StringMapEntry<ValueTy> Bucket2 = this.TheTable[BucketNo];
        if (Bucket2 != null && Bucket2 != StringMap.getTombstoneVal()) {
            return Bucket2;
        }
        if (Val == this.defaultValue) {
            Val = Native.$tryClone(Val);
        }
        StringMapEntry<ValueTy> NewItem = StringMapEntry.Create(Key, KeyStIndex, Len, FullHashValue, this.Allocator, Val);
        if (Bucket2 == StringMap.getTombstoneVal()) {
            --this.NumTombstones;
        }
        ++this.NumItems;
        assert (this.NumItems + this.NumTombstones <= this.NumBuckets);
        this.TheTable[BucketNo] = Bucket2 = NewItem;
        this.RehashTable();
        return Bucket2;
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(StringRef Key) {
        return this.GetOrCreateValue(Key, this.defaultValue);
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(String Key) {
        return this.GetOrCreateValue(new StringRef(Key), this.defaultValue);
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(char.ptr Key) {
        return this.GetOrCreateValue(Key, std.strlen((char.ptr)Key), this.defaultValue);
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(char.ptr Key, int Len) {
        return this.GetOrCreateValue(Key, Len, this.defaultValue);
    }

    public StringMapEntry<ValueTy> GetOrCreateValue(byte[] Key, int KeyStIndex, int Len) {
        return this.GetOrCreateValue(Key, KeyStIndex, Len, this.defaultValue);
    }

    public void remove(StringMapEntry<ValueTy> KeyValue) {
        this.RemoveKey(KeyValue);
    }

    public void erase(StringMapIterator<ValueTy> I) {
        Object V = I.$star();
        this.remove((StringMapEntry<ValueTy>)V);
        ((StringMapEntry)V).Destroy(this.Allocator);
    }

    public boolean erase(StringRef Key) {
        StringMapIterator<ValueTy> I = this.find(Key);
        if (Native.$eq_iter(I, this.end())) {
            return false;
        }
        this.erase(I);
        return true;
    }

    public void $destroy() {
        this.clear();
        std.free((Object)this.TheTable);
        Destructors.$destroy((Object)this.Allocator);
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        StringMapIterator<ValueTy> B = this.begin();
        StringMapIterator<ValueTy> E = this.end();
        while (B.$noteq(E)) {
            out.append("{").append(((StringMapEntry)B.$star()).first()).append("=>").append(((StringMapEntry)B.$star()).getValue()).append("}\n");
            B.$preInc();
        }
        return out.toString();
    }

    @Override
    public Iterator<StringMapEntry<ValueTy>> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }
}

