/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.cl;

import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.cl.ClGlobals;
import org.llvm.cl.FormattingFlags;
import org.llvm.cl.NumOccurrencesFlag;
import org.llvm.cl.OptionCategory;
import org.llvm.cl.OptionHidden;
import org.llvm.cl.ValueExpected;
import org.llvm.cl.impl.CommandLineStatics;
import org.llvm.support.llvm;

public abstract class Option
implements Destructors.ClassWithDestructor {
    private int NumOccurrences = 0;
    private NumOccurrencesFlag Occurrences;
    private ValueExpected Value;
    private OptionHidden HiddenFlag;
    private FormattingFlags Formatting;
    private byte Misc;
    private int Position;
    private int AdditionalVals;
    private Option NextRegistered;
    public char.ptr ArgStr;
    public char.ptr HelpStr;
    public char.ptr ValueStr;
    public OptionCategory Category;

    protected abstract boolean handleOccurrence(int var1, StringRef var2, StringRef var3);

    protected ValueExpected getValueExpectedFlagDefault() {
        return ValueExpected.ValueOptional;
    }

    protected void anchor() {
    }

    public NumOccurrencesFlag getNumOccurrencesFlag() {
        return this.Occurrences;
    }

    public ValueExpected getValueExpectedFlag() {
        return this.Value != null ? this.Value : this.getValueExpectedFlagDefault();
    }

    public OptionHidden getOptionHiddenFlag() {
        return this.HiddenFlag;
    }

    public FormattingFlags getFormattingFlag() {
        return this.Formatting;
    }

    public int getMiscFlags() {
        return this.Misc;
    }

    public int getPosition() {
        return this.Position;
    }

    public int getNumAdditionalVals() {
        return this.AdditionalVals;
    }

    public boolean hasArgStr() {
        return this.ArgStr.$at(0) != 0;
    }

    public void setArgStr(char.ptr S) {
        this.ArgStr = Native.$tryClone((char.ptr)S);
    }

    public void setDescription(char.ptr S) {
        this.HelpStr = Native.$tryClone((char.ptr)S);
    }

    public void setValueStr(char.ptr S) {
        this.ValueStr = Native.$tryClone((char.ptr)S);
    }

    public void setNumOccurrencesFlag(NumOccurrencesFlag Val) {
        this.Occurrences = Val;
    }

    public void setValueExpectedFlag(ValueExpected Val) {
        this.Value = Val;
    }

    public void setHiddenFlag(OptionHidden Val) {
        this.HiddenFlag = Val;
    }

    public void setFormattingFlag(FormattingFlags V) {
        this.Formatting = V;
    }

    public void setMiscFlag(int M) {
        this.Misc = (byte)(this.Misc | M);
    }

    public void setPosition(int pos) {
        this.Position = pos;
    }

    public void setCategory(OptionCategory C) {
        this.Category = C;
    }

    protected Option(NumOccurrencesFlag OccurrencesFlag, OptionHidden Hidden) {
        this.Occurrences = OccurrencesFlag;
        this.Value = null;
        this.HiddenFlag = Hidden;
        this.Formatting = FormattingFlags.NormalFormatting;
        this.Misc = 0;
        this.Position = 0;
        this.AdditionalVals = 0;
        this.NextRegistered = null;
        this.ArgStr = NativePointer.$((String)"");
        this.HelpStr = NativePointer.$((String)"");
        this.ValueStr = NativePointer.$((String)"");
        this.Category = ClGlobals.GeneralCategory;
    }

    protected void setNumAdditionalVals(int n) {
        this.AdditionalVals = n;
    }

    public void addArgument() {
        assert (this.NextRegistered == null) : "argument multiply registered!";
        this.NextRegistered = CommandLineStatics.RegisteredOptionList;
        CommandLineStatics.RegisteredOptionList = this;
        ClGlobals.MarkOptionsChanged();
    }

    public Option getNextRegisteredOption() {
        return this.NextRegistered;
    }

    public abstract int getOptionWidth();

    public abstract void printOptionInfo(int var1);

    public abstract void printOptionValue(int var1, boolean var2);

    public void getExtraOptionNames(SmallVectorImpl<char.ptr> $Prm0) {
    }

    public boolean addOccurrence(int pos, StringRef ArgName, StringRef Value) {
        return this.addOccurrence(pos, ArgName, Value, false);
    }

    public boolean addOccurrence(int pos, StringRef ArgName, StringRef Value, boolean MultiArg) {
        if (!MultiArg) {
            ++this.NumOccurrences;
        }
        switch (this.getNumOccurrencesFlag()) {
            case Optional: {
                if (this.NumOccurrences <= 1) break;
                return this.error(new Twine("may only occur zero or one times!"), ArgName);
            }
            case Required: {
                if (this.NumOccurrences <= 1) break;
                return this.error(new Twine("must occur exactly one time!"), ArgName);
            }
        }
        return this.handleOccurrence(pos, ArgName, Value);
    }

    public boolean error(Twine Message) {
        return this.error(Message, new StringRef());
    }

    public boolean error(Twine Message, StringRef ArgName) {
        if (ArgName.data() == null) {
            ArgName.$assign(new StringRef(this.ArgStr));
        }
        if (ArgName.empty()) {
            llvm.errs().$out(this.HelpStr);
        } else {
            llvm.errs().$out(CommandLineStatics.ProgramName).$out(": for the -").$out(ArgName);
        }
        llvm.$out_raw_ostream_Twine(llvm.errs().$out(" option: "), Message).$out(NativePointer.$LF);
        return true;
    }

    public int getNumOccurrences() {
        return this.NumOccurrences;
    }

    public void $destroy() {
    }
}

