/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.mc;

public class SectionKind {
    private Kind K;

    public boolean isMetadata() {
        return this.K == Kind.Metadata;
    }

    public boolean isText() {
        return this.K == Kind.Text;
    }

    public boolean isReadOnly() {
        return this.K == Kind.ReadOnly || this.isMergeableCString() || this.isMergeableConst();
    }

    public boolean isMergeableCString() {
        return this.K == Kind.Mergeable1ByteCString || this.K == Kind.Mergeable2ByteCString || this.K == Kind.Mergeable4ByteCString;
    }

    public boolean isMergeable1ByteCString() {
        return this.K == Kind.Mergeable1ByteCString;
    }

    public boolean isMergeable2ByteCString() {
        return this.K == Kind.Mergeable2ByteCString;
    }

    public boolean isMergeable4ByteCString() {
        return this.K == Kind.Mergeable4ByteCString;
    }

    public boolean isMergeableConst() {
        return this.K == Kind.MergeableConst || this.K == Kind.MergeableConst4 || this.K == Kind.MergeableConst8 || this.K == Kind.MergeableConst16;
    }

    public boolean isMergeableConst4() {
        return this.K == Kind.MergeableConst4;
    }

    public boolean isMergeableConst8() {
        return this.K == Kind.MergeableConst8;
    }

    public boolean isMergeableConst16() {
        return this.K == Kind.MergeableConst16;
    }

    public boolean isWriteable() {
        return this.isThreadLocal() || this.isGlobalWriteableData();
    }

    public boolean isThreadLocal() {
        return this.K == Kind.ThreadData || this.K == Kind.ThreadBSS;
    }

    public boolean isThreadBSS() {
        return this.K == Kind.ThreadBSS;
    }

    public boolean isThreadData() {
        return this.K == Kind.ThreadData;
    }

    public boolean isGlobalWriteableData() {
        return this.isBSS() || this.isCommon() || this.isDataRel() || this.isReadOnlyWithRel();
    }

    public boolean isBSS() {
        return this.K == Kind.BSS || this.K == Kind.BSSLocal || this.K == Kind.BSSExtern;
    }

    public boolean isBSSLocal() {
        return this.K == Kind.BSSLocal;
    }

    public boolean isBSSExtern() {
        return this.K == Kind.BSSExtern;
    }

    public boolean isCommon() {
        return this.K == Kind.Common;
    }

    public boolean isDataRel() {
        return this.K == Kind.DataRel || this.K == Kind.DataRelLocal || this.K == Kind.DataNoRel;
    }

    public boolean isDataRelLocal() {
        return this.K == Kind.DataRelLocal || this.K == Kind.DataNoRel;
    }

    public boolean isDataNoRel() {
        return this.K == Kind.DataNoRel;
    }

    public boolean isReadOnlyWithRel() {
        return this.K == Kind.ReadOnlyWithRel || this.K == Kind.ReadOnlyWithRelLocal;
    }

    public boolean isReadOnlyWithRelLocal() {
        return this.K == Kind.ReadOnlyWithRelLocal;
    }

    private static SectionKind get(Kind K) {
        SectionKind Res = new SectionKind();
        Res.K = K;
        return Res;
    }

    public static SectionKind getMetadata() {
        return SectionKind.get(Kind.Metadata);
    }

    public static SectionKind getText() {
        return SectionKind.get(Kind.Text);
    }

    public static SectionKind getReadOnly() {
        return SectionKind.get(Kind.ReadOnly);
    }

    public static SectionKind getMergeable1ByteCString() {
        return SectionKind.get(Kind.Mergeable1ByteCString);
    }

    public static SectionKind getMergeable2ByteCString() {
        return SectionKind.get(Kind.Mergeable2ByteCString);
    }

    public static SectionKind getMergeable4ByteCString() {
        return SectionKind.get(Kind.Mergeable4ByteCString);
    }

    public static SectionKind getMergeableConst() {
        return SectionKind.get(Kind.MergeableConst);
    }

    public static SectionKind getMergeableConst4() {
        return SectionKind.get(Kind.MergeableConst4);
    }

    public static SectionKind getMergeableConst8() {
        return SectionKind.get(Kind.MergeableConst8);
    }

    public static SectionKind getMergeableConst16() {
        return SectionKind.get(Kind.MergeableConst16);
    }

    public static SectionKind getThreadBSS() {
        return SectionKind.get(Kind.ThreadBSS);
    }

    public static SectionKind getThreadData() {
        return SectionKind.get(Kind.ThreadData);
    }

    public static SectionKind getBSS() {
        return SectionKind.get(Kind.BSS);
    }

    public static SectionKind getBSSLocal() {
        return SectionKind.get(Kind.BSSLocal);
    }

    public static SectionKind getBSSExtern() {
        return SectionKind.get(Kind.BSSExtern);
    }

    public static SectionKind getCommon() {
        return SectionKind.get(Kind.Common);
    }

    public static SectionKind getDataRel() {
        return SectionKind.get(Kind.DataRel);
    }

    public static SectionKind getDataRelLocal() {
        return SectionKind.get(Kind.DataRelLocal);
    }

    public static SectionKind getDataNoRel() {
        return SectionKind.get(Kind.DataNoRel);
    }

    public static SectionKind getReadOnlyWithRel() {
        return SectionKind.get(Kind.ReadOnlyWithRel);
    }

    public static SectionKind getReadOnlyWithRelLocal() {
        return SectionKind.get(Kind.ReadOnlyWithRelLocal);
    }

    public SectionKind() {
    }

    public SectionKind(SectionKind $Prm0) {
        this.K = $Prm0.K;
    }

    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind Metadata = new Kind(0);
        public static final /* enum */ Kind Text = new Kind(1);
        public static final /* enum */ Kind ReadOnly = new Kind(2);
        public static final /* enum */ Kind Mergeable1ByteCString = new Kind(3);
        public static final /* enum */ Kind Mergeable2ByteCString = new Kind(4);
        public static final /* enum */ Kind Mergeable4ByteCString = new Kind(5);
        public static final /* enum */ Kind MergeableConst = new Kind(6);
        public static final /* enum */ Kind MergeableConst4 = new Kind(7);
        public static final /* enum */ Kind MergeableConst8 = new Kind(8);
        public static final /* enum */ Kind MergeableConst16 = new Kind(9);
        public static final /* enum */ Kind ThreadBSS = new Kind(10);
        public static final /* enum */ Kind ThreadData = new Kind(11);
        public static final /* enum */ Kind BSS = new Kind(12);
        public static final /* enum */ Kind BSSLocal = new Kind(13);
        public static final /* enum */ Kind BSSExtern = new Kind(14);
        public static final /* enum */ Kind Common = new Kind(15);
        public static final /* enum */ Kind DataRel = new Kind(16);
        public static final /* enum */ Kind DataRelLocal = new Kind(17);
        public static final /* enum */ Kind DataNoRel = new Kind(18);
        public static final /* enum */ Kind ReadOnlyWithRel = new Kind(19);
        public static final /* enum */ Kind ReadOnlyWithRelLocal = new Kind(20);
        private final int value;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        public static Kind valueOf(int val) {
            Kind out;
            Kind kind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Kind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Kind[]{Metadata, Text, ReadOnly, Mergeable1ByteCString, Mergeable2ByteCString, Mergeable4ByteCString, MergeableConst, MergeableConst4, MergeableConst8, MergeableConst16, ThreadBSS, ThreadData, BSS, BSSLocal, BSSExtern, Common, DataRel, DataRelLocal, DataNoRel, ReadOnlyWithRel, ReadOnlyWithRelLocal};
        }

        private static final class Values {
            private static final Kind[] VALUES;
            private static final Kind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Kind kind : Kind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Kind[min < 0 ? 1 - min : 0];
                VALUES = new Kind[max >= 0 ? 1 + max : 0];
                for (Kind kind : Kind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Kind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Kind)kind).value] = kind;
                }
            }
        }
    }
}

