/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.support;

import org.clank.java.built_in;
import org.clank.java.io;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_pwrite_stream;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.sys;

public class raw_fd_ostream
extends raw_pwrite_stream
implements Destructors.ClassWithDestructor {
    private int FD;
    private boolean ShouldClose;
    private boolean Error;
    private boolean UseAtomicWrites;
    private long pos;
    private boolean SupportsSeeking;

    @Override
    protected void write_impl(char.ptr Ptr, int PtrIdx, int Size) {
        assert (this.FD >= 0) : "File already closed.";
        this.pos += (long)Size;
        int Ptr$Index = Ptr.$index() + PtrIdx;
        do {
            long ret;
            if ((ret = built_in.__builtin_expect((int)(!this.UseAtomicWrites ? 1 : 0), (int)1) != 0 ? io.write((int)this.FD, (char.ptr)Ptr, (int)Ptr$Index, (int)Size) : io.write((int)this.FD, (char.ptr)Ptr, (int)Ptr$Index, (int)Size)) < 0L) {
                if (std.errno() == 4 || std.errno() == 11 || std.errno() == 11) continue;
                this.error_detected();
                break;
            }
            Ptr$Index = (int)((long)Ptr$Index + ret);
            Size = (int)((long)Size - ret);
        } while (Size > 0);
    }

    @Override
    protected void pwrite_impl(char.ptr Ptr, int Size, long Offset) {
        long Pos = this.tell();
        this.seek(Offset);
        this.write(Ptr, Size);
        this.seek(Pos);
    }

    @Override
    protected void write_impl(byte[] Ptr, int PtrIndex, int Size) {
        assert (this.FD >= 0) : "File already closed.";
        this.pos += (long)Size;
        do {
            long ret;
            if ((ret = built_in.__builtin_expect((int)(!this.UseAtomicWrites ? 1 : 0), (int)1) != 0 ? io.write((int)this.FD, (byte[])Ptr, (int)PtrIndex, (int)Size) : io.write((int)this.FD, (byte[])Ptr, (int)PtrIndex, (int)Size)) < 0L) {
                if (std.errno() == 4 || std.errno() == 11 || std.errno() == 11) continue;
                this.error_detected();
                break;
            }
            PtrIndex = (int)((long)PtrIndex + ret);
            Size = (int)((long)Size - ret);
        } while (Size > 0);
    }

    @Override
    protected long current_pos() {
        return this.pos;
    }

    @Override
    protected int preferred_buffer_size() {
        assert (this.FD >= 0) : "File not yet open!";
        io.stat statbuf = new io.stat();
        if (std.fstat((int)this.FD, (io.stat)statbuf) != 0) {
            return 0;
        }
        if (std.S_ISCHR((long)statbuf.st_mode) && std.isatty((int)this.FD) != 0) {
            return 0;
        }
        return statbuf.st_blksize;
    }

    private void error_detected() {
        this.Error = true;
    }

    public raw_fd_ostream(std.string Filename, std_errors.error_code EC, int Flags) {
        this(new StringRef(Filename), EC, Flags);
    }

    public raw_fd_ostream(StringRef Filename, std_errors.error_code EC, int Flags) {
        this.Error = false;
        this.UseAtomicWrites = false;
        this.pos = 0L;
        EC.$assign(new std_errors.error_code());
        if (llvm.$eq_StringRef(Filename, StringRef.R$MINUS)) {
            this.FD = 1;
            if ((Flags & 4) == 0) {
                sys.ChangeStdoutToBinary();
            }
            this.ShouldClose = true;
            return;
        }
        int.ref _FD = NativePointer.create_int$ref((int)this.FD);
        EC.$assign(fs.openFileForWrite(new Twine(Filename), _FD, Flags));
        this.FD = _FD.$deref();
        if (EC.$bool()) {
            this.ShouldClose = false;
            return;
        }
        this.ShouldClose = true;
    }

    public raw_fd_ostream(int fd, boolean shouldClose) {
        this(fd, shouldClose, false);
    }

    public raw_fd_ostream(int fd, boolean shouldClose, boolean unbuffered) {
        super(unbuffered);
        this.FD = fd;
        this.ShouldClose = shouldClose;
        this.Error = false;
        this.UseAtomicWrites = false;
        long loc = io.lseek((int)this.FD, (long)0L, (int)1);
        this.pos = loc == -1L ? 0L : loc;
    }

    @Override
    public void $destroy() {
        if (this.FD >= 0) {
            this.flush();
            if (this.ShouldClose) {
                while (io.close((int)this.FD) != 0) {
                    if (std.errno() == 4) continue;
                    this.error_detected();
                    break;
                }
            }
        }
        if (this.has_error()) {
            llvm.report_fatal_error(NativePointer.$((String)"IO failure on output stream."), false);
        }
        super.$destroy();
    }

    public void close() {
        assert (this.ShouldClose);
        this.ShouldClose = false;
        this.flush();
        while (io.close((int)this.FD) != 0) {
            if (std.errno() == 4) continue;
            this.error_detected();
            break;
        }
        this.FD = -1;
    }

    public boolean supportsSeeking() {
        return this.SupportsSeeking;
    }

    public long seek(long off) {
        this.flush();
        this.pos = io.lseek((int)this.FD, (long)off, (int)0);
        if (this.pos != off) {
            this.error_detected();
        }
        return this.pos;
    }

    public void SetUseAtomicWrites(boolean Value) {
        this.UseAtomicWrites = Value;
    }

    @Override
    public raw_ostream changeColor(raw_ostream.Colors colors) {
        return this.changeColor(colors, false, false);
    }

    @Override
    public raw_ostream changeColor(raw_ostream.Colors colors, boolean bold) {
        return this.changeColor(colors, bold, false);
    }

    @Override
    public raw_ostream changeColor(raw_ostream.Colors colors, boolean bold, boolean bg) {
        char.ptr colorcode;
        if (Process.ColorNeedsFlush()) {
            this.flush();
        }
        char.ptr ptr2 = colorcode = colors == raw_ostream.Colors.SAVEDCOLOR ? Process.OutputBold(bg) : Process.OutputColor(colors.getValue(), bold, bg);
        if (colorcode != null) {
            int len = std.strlen((char.ptr)colorcode);
            this.write(colorcode, 0, len);
            this.pos -= (long)len;
        }
        return this;
    }

    @Override
    public raw_ostream resetColor() {
        char.ptr colorcode;
        if (Process.ColorNeedsFlush()) {
            this.flush();
        }
        if ((colorcode = Process.ResetColor()) != null) {
            int len = std.strlen((char.ptr)colorcode);
            this.write(colorcode, 0, len);
            this.pos -= (long)len;
        }
        return this;
    }

    @Override
    public raw_ostream reverseColor() {
        char.ptr colorcode;
        if (Process.ColorNeedsFlush()) {
            this.flush();
        }
        if ((colorcode = Process.OutputReverse()) != null) {
            int len = std.strlen((char.ptr)colorcode);
            this.write(colorcode, 0, len);
            this.pos -= (long)len;
        }
        return this;
    }

    @Override
    public boolean is_displayed() {
        return Process.FileDescriptorIsDisplayed(this.FD);
    }

    @Override
    public boolean has_colors() {
        return Process.FileDescriptorHasColors(this.FD);
    }

    public boolean has_error() {
        return this.Error;
    }

    public void clear_error() {
        this.Error = false;
    }

    @Override
    public String toString() {
        return "FD=" + this.FD + " ShouldClose=" + this.ShouldClose + ";" + super.toString();
    }
}

