/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;

public abstract class ASTPath {
    ASTPath() {
    }

    public abstract ASTItem getLeaf();

    public abstract int size();

    public abstract ASTItem getRoot();

    public abstract ListIterator<ASTItem> listIterator();

    public abstract ListIterator<ASTItem> listIterator(int var1);

    public abstract ASTItem get(int var1);

    public abstract ASTPath subPath(int var1);

    public static ASTPath create(List<ASTItem> path) {
        if (path.isEmpty()) {
            return null;
        }
        return new Token2Path(path);
    }

    public static ASTPath create(ASTItem item) {
        if (item == null) {
            throw new NullPointerException();
        }
        return new TokenPath(item);
    }

    private static final class Token2Path
    extends ASTPath {
        private List<ASTItem> path;

        Token2Path(List<ASTItem> path) {
            this.path = path;
            if (path.size() < 1) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public ASTItem getLeaf() {
            return this.path.get(this.path.size() - 1);
        }

        @Override
        public int size() {
            return this.path.size();
        }

        @Override
        public ASTItem getRoot() {
            return this.path.get(0);
        }

        @Override
        public ListIterator<ASTItem> listIterator() {
            return this.path.listIterator();
        }

        @Override
        public ListIterator<ASTItem> listIterator(int index) {
            return this.path.listIterator(index);
        }

        @Override
        public ASTItem get(int index) {
            return this.path.get(index);
        }

        @Override
        public ASTPath subPath(int index) {
            return new Token2Path(this.path.subList(0, index + 1));
        }

        public String toString() {
            ASTItem item;
            StringBuilder sb = new StringBuilder("ASTPath ");
            Iterator<ASTItem> it = this.path.iterator();
            if (it.hasNext()) {
                item = it.next();
                if (item instanceof ASTNode) {
                    sb.append(((ASTNode)item).getNT());
                } else {
                    sb.append(item);
                }
            }
            while (it.hasNext()) {
                item = it.next();
                if (item instanceof ASTNode) {
                    sb.append(", ").append(((ASTNode)item).getNT());
                    continue;
                }
                sb.append(", ").append(item);
            }
            return sb.toString();
        }
    }

    private static final class TokenPath
    extends ASTPath {
        private ASTItem o;

        TokenPath(ASTItem o) {
            this.o = o;
        }

        @Override
        public ASTItem getLeaf() {
            return this.o;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ASTItem getRoot() {
            return this.o;
        }

        @Override
        public ListIterator<ASTItem> listIterator() {
            return Collections.singletonList(this.o).listIterator();
        }

        @Override
        public ListIterator<ASTItem> listIterator(int index) {
            return Collections.singletonList(this.o).listIterator(index);
        }

        @Override
        public ASTItem get(int index) {
            if (index == 0) {
                return this.o;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        @Override
        public ASTPath subPath(int index) {
            if (index == 0) {
                return this;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public String toString() {
            return "ASTPath " + this.o;
        }
    }
}

