/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkType;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmGotoStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.support.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmDefineHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmHyperlinkProvider;
import org.netbeans.modules.cnd.completion.cplusplus.hyperlink.CsmIncludeHyperlinkProvider;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.csm.CompletionUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.Bundle;
import org.netbeans.modules.cnd.completion.impl.xref.DocOffsetableImpl;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesCache;
import org.netbeans.modules.cnd.completion.impl.xref.ThisReferenceImpl;
import org.netbeans.modules.cnd.debug.CndDiagnosticProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class ReferencesSupport {
    private static ReferencesSupport instance = new ReferencesSupport();
    private final CsmProgressListener progressListener;
    private final ReferencesCache cache = new ReferencesCache();
    private static final CsmOffsetable.Position DUMMY_POSITION = new CsmOffsetable.Position(){

        public int getOffset() {
            return -1;
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    };

    private ReferencesSupport() {
        this.progressListener = new CsmProgressAdapter(){

            public void fileParsingFinished(CsmFile file) {
                ReferencesSupport.this.clearFileReferences(file);
            }

            public void projectParsingFinished(CsmProject project) {
                ReferencesSupport.this.clearFileReferences(null);
            }
        };
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    public static ReferencesSupport instance() {
        return instance;
    }

    public static int getDocumentOffset(BaseDocument doc, int lineIndex, int colIndex) {
        return LineDocumentUtils.getLineStartFromIndex((LineDocument)doc, (int)(lineIndex - 1)) + (colIndex - 1);
    }

    public CsmObject findReferencedObject(CsmFile csmFile, BaseDocument doc, int offset) {
        return this.findReferencedObject(csmFile, doc, offset, null, null);
    }

    static CsmObject findOwnerObject(CsmFile csmFile, int offset, TokenItem<TokenId> token, FileReferencesContext fileReferencesContext) {
        CsmContext context = CsmOffsetResolver.findContext(csmFile, offset, fileReferencesContext);
        CsmObject out = context.getLastObject();
        return out;
    }

    static CsmObject findClosestTopLevelObject(CsmFile csmFile, int offset, TokenItem<TokenId> token, FileReferencesContext fileReferencesContext) {
        CsmContext context = CsmOffsetResolver.findContext(csmFile, offset, fileReferencesContext);
        CsmObject out = context.getLastObject();
        if (CsmKindUtilities.isType((CsmObject)out) || CsmKindUtilities.isTemplateParameter((CsmObject)out)) {
            out = context.getLastScope();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmObject findReferencedObject(CsmFile csmFile, BaseDocument doc, int offset, TokenItem<TokenId> jumpToken, FileReferencesContext fileReferencesContext) {
        TokenId id;
        long fileVersionOnStartResolving = CsmFileInfoQuery.getDefault().getFileVersion(csmFile);
        CsmObject csmItem = null;
        Object incl = null;
        if (jumpToken == null) {
            doc.readLock();
            try {
                jumpToken = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
            }
            finally {
                doc.readUnlock();
            }
        }
        if (jumpToken != null && (id = jumpToken.id()) instanceof CppTokenId) {
            switch ((CppTokenId)id) {
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: {
                    csmItem = ReferencesSupport.findInclude(csmFile, offset);
                    break;
                }
                case PREPROCESSOR_SYS_INCLUDE: 
                case PREPROCESSOR_USER_INCLUDE: {
                    csmItem = ReferencesSupport.findInclude(csmFile, offset);
                    if (csmItem == null) break;
                    csmItem = ((CsmInclude)csmItem).getIncludeFile();
                    break;
                }
                case PREPROCESSOR_IDENTIFIER: {
                    csmItem = ReferencesSupport.findDefine((Document)doc, csmFile, (TokenItem<TokenId>)jumpToken, offset);
                }
            }
        }
        if (csmItem == null && jumpToken != null) {
            int key = jumpToken.offset();
            if (key < 0) {
                key = offset;
            }
            if ((csmItem = this.getReferencedObject(csmFile, (TokenItem<TokenId>)jumpToken, fileVersionOnStartResolving)) == null) {
                csmItem = ReferencesSupport.findDeclaration(csmFile, (Document)doc, (TokenItem<TokenId>)jumpToken, key, fileReferencesContext);
                if (csmItem == null) {
                    this.putReferencedObject(csmFile, (TokenItem<TokenId>)jumpToken, ReferencesCache.UNRESOLVED, fileVersionOnStartResolving);
                } else {
                    this.putReferencedObject(csmFile, (TokenItem<TokenId>)jumpToken, csmItem, fileVersionOnStartResolving);
                }
            } else if (csmItem == ReferencesCache.UNRESOLVED) {
                csmItem = null;
            }
        }
        return csmItem;
    }

    public static CsmObject findDefine(Document doc, CsmFile csmFile, TokenItem<TokenId> tokenUnderOffset, int offset) {
        assert (csmFile != null);
        assert (doc != null);
        DefineImpl define = ReferencesSupport.getDefine(doc, csmFile, offset);
        if (define != null) {
            for (DefineParameterImpl param : define.getParams()) {
                if (!param.getText().equals(tokenUnderOffset.text())) continue;
                return param;
            }
        }
        return null;
    }

    public static CsmErrorDirective findErrorDirective(CsmFile csmFile, int offset) {
        assert (csmFile != null);
        return (CsmErrorDirective)CsmOffsetUtilities.findObject(csmFile.getErrors(), null, offset);
    }

    public static CsmInclude findInclude(CsmFile csmFile, int offset) {
        assert (csmFile != null);
        return (CsmInclude)CsmOffsetUtilities.findObject(csmFile.getIncludes(), null, offset);
    }

    public static CsmObject findDeclaration(CsmFile csmFile, Document doc, TokenItem<TokenId> tokenUnderOffset, int offset) {
        return ReferencesSupport.findDeclaration(csmFile, doc, tokenUnderOffset, offset, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CsmObject findDeclaration(CsmFile csmFile, Document doc, TokenItem<TokenId> tokenUnderOffset, int offset, FileReferencesContext fileReferencesContext) {
        String oldName = Thread.currentThread().getName();
        boolean restoreThreadName = false;
        try {
            CsmObject other;
            CsmType type;
            List macroUsages;
            CsmObject csmItem;
            if (csmFile != null && CndUtils.isDebugMode()) {
                try {
                    String position = "[" + offset + "]";
                    if (doc instanceof LineDocument) {
                        LineDocument lineDoc = (LineDocument)doc;
                        position = "[" + (LineDocumentUtils.getLineIndex((LineDocument)lineDoc, (int)offset) + 1) + "," + (offset - LineDocumentUtils.getLineStart((LineDocument)lineDoc, (int)offset) + 1) + "]";
                    }
                    Thread.currentThread().setName(oldName + " (find declaration at " + csmFile.getAbsolutePath() + position + ", token \"" + (tokenUnderOffset != null ? tokenUnderOffset.text() : "<unknown>") + "\")");
                    restoreThreadName = true;
                }
                catch (BadLocationException position) {
                    // empty catch block
                }
            }
            if ((csmItem = ReferencesSupport.findMacro(macroUsages = CsmFileInfoQuery.getDefault().getMacroUsages(csmFile, doc, Interrupter.DUMMY), offset)) != null) {
                CsmObject csmObject = csmItem;
                return csmObject;
            }
            CsmObject objUnderOffset = CsmOffsetResolver.findObject(csmFile, offset, fileReferencesContext);
            if (CsmKindUtilities.isEnumerator((Object)objUnderOffset)) {
                CsmEnumerator enmrtr = (CsmEnumerator)objUnderOffset;
                if (enmrtr.getExplicitValue() == null) {
                    csmItem = enmrtr;
                }
            } else if (CsmKindUtilities.isLabel((CsmObject)objUnderOffset)) {
                csmItem = objUnderOffset;
            } else if (CsmKindUtilities.isGotoStatement((CsmObject)objUnderOffset)) {
                Collection labels;
                CsmGotoStatement csmGoto = (CsmGotoStatement)objUnderOffset;
                CsmScope scope = csmGoto.getScope();
                while (scope != null && CsmKindUtilities.isScopeElement((CsmObject)scope) && !CsmKindUtilities.isFunctionDefinition((CsmObject)scope)) {
                    scope = ((CsmScopeElement)scope).getScope();
                }
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)scope) && !(labels = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)scope, csmGoto.getLabel(), EnumSet.of(CsmLabelResolver.LabelKind.Definiton))).isEmpty()) {
                    csmItem = ((CsmReference)labels.iterator().next()).getReferencedObject();
                }
            } else if (CsmKindUtilities.isVariable((CsmObject)objUnderOffset) || CsmKindUtilities.isTypedef((CsmObject)objUnderOffset) || CsmKindUtilities.isTypeAlias((CsmObject)objUnderOffset)) {
                boolean repeat;
                type = CsmKindUtilities.isVariable((CsmObject)objUnderOffset) ? ((CsmVariable)objUnderOffset).getType() : ((CsmTypedef)objUnderOffset).getType();
                CsmParameter parameter = null;
                do {
                    CsmSpecializationParameter param;
                    CsmParameter deeperParameter;
                    repeat = false;
                    if (CsmOffsetUtilities.isInObject((CsmObject)type, offset)) {
                        parameter = null;
                    }
                    if (CsmKindUtilities.isFunctionPointerType((CsmObject)type) && (deeperParameter = (CsmParameter)CsmOffsetUtilities.findObject(((CsmFunctionPointerType)type).getParameters(), null, offset)) != null) {
                        parameter = deeperParameter;
                        type = deeperParameter.getType();
                        repeat = true;
                    }
                    if (type == null || type.getInstantiationParams().isEmpty() || (param = (CsmSpecializationParameter)CsmOffsetUtilities.findObject(type.getInstantiationParams(), null, offset)) == null || CsmOffsetUtilities.sameOffsets((CsmObject)type, (CsmObject)param) || !CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) continue;
                    type = ((CsmTypeBasedSpecializationParameter)param).getType();
                    repeat = true;
                } while (repeat);
                csmItem = parameter;
                if (csmItem == null && CsmKindUtilities.isVariableDeclaration((CsmObject)objUnderOffset)) {
                    CsmVariable var;
                    CharSequence name;
                    if (tokenUnderOffset == null && doc instanceof AbstractDocument) {
                        ((AbstractDocument)doc).readLock();
                        try {
                            tokenUnderOffset = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
                        }
                        finally {
                            ((AbstractDocument)doc).readUnlock();
                        }
                    }
                    if (tokenUnderOffset != null && (name = (var = (CsmVariable)objUnderOffset).getName()) != null && name.length() > 0 && tokenUnderOffset.text().toString().equals(name.toString()) && !var.isExtern() && var.getInitialValue() == null && var.getType() != null && var.getType().getArrayDepth() == 0) {
                        csmItem = var;
                    }
                }
            } else if (CsmKindUtilities.isType((CsmObject)objUnderOffset)) {
                boolean repeat;
                type = (CsmType)objUnderOffset;
                CsmParameter parameter = null;
                do {
                    CsmSpecializationParameter param;
                    CsmParameter deeperParameter;
                    repeat = false;
                    if (CsmOffsetUtilities.isInObject((CsmObject)type, offset)) {
                        parameter = null;
                    }
                    if (CsmKindUtilities.isFunctionPointerType((CsmObject)type) && (deeperParameter = (CsmParameter)CsmOffsetUtilities.findObject(((CsmFunctionPointerType)type).getParameters(), null, offset)) != null) {
                        parameter = deeperParameter;
                        type = deeperParameter.getType();
                        repeat = true;
                    }
                    if (type.getInstantiationParams().isEmpty() || (param = (CsmSpecializationParameter)CsmOffsetUtilities.findObject(type.getInstantiationParams(), null, offset)) == null || CsmOffsetUtilities.sameOffsets((CsmObject)type, (CsmObject)param) || !CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)param)) continue;
                    type = ((CsmTypeBasedSpecializationParameter)param).getType();
                    repeat = true;
                } while (repeat);
                csmItem = parameter;
            }
            if (csmItem == null) {
                int[] idFunBlk = null;
                try {
                    if (doc instanceof BaseDocument) {
                        idFunBlk = NbEditorUtilities.getIdentifierAndMethodBlock((BaseDocument)((BaseDocument)doc), (int)offset);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (idFunBlk != null && idFunBlk.length != 3) {
                    csmItem = ReferencesSupport.findDeclaration(csmFile, doc, tokenUnderOffset, offset, CompletionResolver.QueryScope.SMART_QUERY, fileReferencesContext);
                }
            }
            if (!(csmItem != null && CsmIncludeResolver.getDefault().isObjectVisible(csmFile, csmItem) || (other = ReferencesSupport.findDeclaration(csmFile, doc, tokenUnderOffset, offset, CompletionResolver.QueryScope.GLOBAL_QUERY, fileReferencesContext)) == null)) {
                csmItem = other;
            }
            CsmObject csmObject = csmItem;
            return csmObject;
        }
        finally {
            if (restoreThreadName) {
                Thread.currentThread().setName(oldName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CsmObject findDeclaration(CsmFile csmFile, Document doc, TokenItem<TokenId> tokenUnderOffset, int offset, CompletionResolver.QueryScope queryScope, FileReferencesContext fileReferencesContext) {
        assert (csmFile != null);
        if (tokenUnderOffset == null && doc instanceof AbstractDocument) {
            ((AbstractDocument)doc).readLock();
            try {
                tokenUnderOffset = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
            }
            finally {
                ((AbstractDocument)doc).readUnlock();
            }
        }
        if (tokenUnderOffset == null) {
            return null;
        }
        CsmObject csmObject = null;
        if (tokenUnderOffset.id() == CppTokenId.OPERATOR) {
            CsmObject foundObject = CsmOffsetResolver.findObject(csmFile, offset, fileReferencesContext);
            csmObject = foundObject;
            if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
                CsmFunction decl = null;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject)) {
                    decl = ((CsmFunctionDefinition)csmObject).getDeclaration();
                } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmObject)) {
                    decl = ((CsmFriendFunction)csmObject).getReferencedFunction();
                }
                if (decl != null) {
                    csmObject = decl;
                }
            } else {
                csmObject = null;
            }
        }
        if (csmObject == null) {
            Collection<CsmObject> objs = CompletionUtilities.findItemsReferencedAtCaretPos(null, doc, CsmCompletionProvider.createCompletionResolver(csmFile, queryScope, fileReferencesContext), offset);
            csmObject = ReferencesSupport.extractBestReferencedObject(objs, csmObject);
        }
        return csmObject;
    }

    private static CsmObject extractBestReferencedObject(Collection<CsmObject> objs, CsmObject csmObject) {
        CsmObject out = null;
        CsmObject fwd = null;
        for (CsmObject cur : objs) {
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)cur) || CsmClassifierResolver.getDefault().isForwardClassifier(cur)) {
                if (fwd != null) continue;
                fwd = cur;
                continue;
            }
            out = cur;
            break;
        }
        if (out == null) {
            out = fwd;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ReferenceImpl createReferenceImpl(CsmFile file, BaseDocument doc, int offset) {
        ReferenceImpl ref = null;
        doc.readLock();
        try {
            TokenItem token = CndTokenUtilities.getTokenCheckPrev((Document)doc, (int)offset);
            if (ReferencesSupport.isSupportedToken((TokenItem<TokenId>)token)) {
                ref = ReferencesSupport.createReferenceImpl(file, doc, offset, (TokenItem<TokenId>)token, null);
            }
        }
        finally {
            doc.readUnlock();
        }
        return ref;
    }

    public static ReferenceImpl createReferenceImpl(CsmFile file, BaseDocument doc, int offset, TokenItem<TokenId> token, CsmReferenceKind kind) {
        assert (token != null);
        assert (file != null) : "null file for document " + doc + " on offset " + offset + " " + token;
        if (token.id() == CppTokenId.THIS) {
            return new ThisReferenceImpl(file, doc, offset, token, kind);
        }
        return new ReferenceImpl(file, doc, offset, token, kind);
    }

    private static boolean isSupportedToken(TokenItem<TokenId> token) {
        return token != null && (CsmIncludeHyperlinkProvider.isSupportedToken(token, HyperlinkType.GO_TO_DECLARATION) || CsmHyperlinkProvider.isSupportedToken(token, HyperlinkType.GO_TO_DECLARATION) || CsmDefineHyperlinkProvider.isSupportedToken(token, HyperlinkType.GO_TO_DECLARATION));
    }

    public static CsmReferenceResolver.Scope fastCheckScope(CsmReference ref) {
        Parameters.notNull((CharSequence)"ref", (Object)ref);
        CsmObject target = ReferencesSupport.getTargetIfPossible(ref);
        if (target == null) {
            int offset = ReferencesSupport.getRefOffset(ref);
            BaseDocument doc = ReferencesSupport.getRefDocument(ref);
            if (doc != null) {
                TokenItem<TokenId> token = ReferencesSupport.getRefTokenIfPossible(ref);
                target = ReferencesSupport.findDeclaration(ref.getContainingFile(), (Document)doc, token, offset, CompletionResolver.QueryScope.LOCAL_QUERY, null);
                ReferencesSupport.setResolvedInfo(ref, target);
            }
        }
        return ReferencesSupport.getTargetScope(target);
    }

    private static CsmReferenceResolver.Scope getTargetScope(CsmObject obj) {
        if (obj == null) {
            return CsmReferenceResolver.Scope.UNKNOWN;
        }
        if (ReferencesSupport.isLocalElement(obj)) {
            return CsmReferenceResolver.Scope.LOCAL;
        }
        if (ReferencesSupport.isFileLocalElement(obj)) {
            return CsmReferenceResolver.Scope.FILE_LOCAL;
        }
        return CsmReferenceResolver.Scope.GLOBAL;
    }

    private static CsmObject getTargetIfPossible(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getTarget();
        }
        return null;
    }

    static TokenItem<TokenId> getRefTokenIfPossible(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getToken();
        }
        return null;
    }

    private static CsmReferenceKind getRefKindIfPossible(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getKindImpl();
        }
        return null;
    }

    private static BaseDocument getRefDocument(CsmReference ref) {
        if (ref instanceof DocOffsetableImpl) {
            return ((DocOffsetableImpl)ref).getDocument();
        }
        CsmFile file = ref.getContainingFile();
        CloneableEditorSupport ces = CsmUtilities.findCloneableEditorSupport((CsmFile)file);
        StyledDocument doc = CsmUtilities.openDocument((CloneableEditorSupport)ces);
        return doc instanceof BaseDocument ? (BaseDocument)doc : null;
    }

    private static int getRefOffset(CsmReference ref) {
        if (ref instanceof ReferenceImpl) {
            return ((ReferenceImpl)ref).getOffset();
        }
        return (ref.getStartOffset() + ref.getEndOffset() + 1) / 2;
    }

    private static void setResolvedInfo(CsmReference ref, CsmObject target) {
        if (target != null && ref instanceof ReferenceImpl) {
            ((ReferenceImpl)ref).setTarget(target);
        }
    }

    private static boolean isLocalElement(CsmObject decl) {
        assert (decl != null);
        CsmObject scopeElem = decl;
        while (CsmKindUtilities.isScopeElement((CsmObject)scopeElem)) {
            CsmScope scope = ((CsmScopeElement)scopeElem).getScope();
            if (CsmKindUtilities.isFunction((CsmObject)scope)) {
                return true;
            }
            if (!CsmKindUtilities.isScopeElement((CsmObject)scope)) break;
            scopeElem = (CsmScopeElement)scope;
        }
        return false;
    }

    private static boolean isFileLocalElement(CsmObject decl) {
        assert (decl != null);
        if (CsmBaseUtilities.isDeclarationFromUnnamedNamespace((CsmObject)decl)) {
            return true;
        }
        if (CsmKindUtilities.isFileLocalVariable((CsmObject)decl)) {
            return true;
        }
        if (CsmKindUtilities.isFunction((CsmObject)decl)) {
            return CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)decl));
        }
        return false;
    }

    static CsmReferenceKind getReferenceUsageKind(CsmReference ref) {
        CsmReferenceKind implKind;
        CsmReferenceKind kind = CsmReferenceKind.DIRECT_USAGE;
        if (ref instanceof ReferenceImpl && (implKind = ReferencesSupport.getRefKindIfPossible(ref)) != null) {
            return implKind;
        }
        return kind;
    }

    private CsmObject getReferencedObject(CsmFile file, TokenItem<TokenId> offset, long callTimeVersion) {
        return this.cache.getReferencedObject(file, offset, callTimeVersion);
    }

    private void putReferencedObject(CsmFile file, TokenItem<TokenId> offset, CsmObject object, long fileVersionOnStartResolving) {
        this.cache.putReferencedObject(file, offset, object, fileVersionOnStartResolving);
    }

    private void clearFileReferences(CsmFile file) {
        this.cache.clearFileReferences(file);
    }

    public static CsmObject findMacro(List<CsmReference> macroUsages, int offset) {
        int index = Collections.binarySearch(macroUsages, new RefOffsetKey(offset), new Comparator<CsmReference>(){

            @Override
            public int compare(CsmReference o1, CsmReference o2) {
                if (o1 instanceof RefOffsetKey ? o2.getStartOffset() <= o1.getStartOffset() && o1.getEndOffset() <= o2.getEndOffset() : o2 instanceof RefOffsetKey && o1.getStartOffset() <= o2.getStartOffset() && o2.getEndOffset() <= o1.getEndOffset()) {
                    return 0;
                }
                return o1.getStartOffset() - o2.getStartOffset();
            }
        });
        if (index >= 0) {
            CsmReference macroRef = macroUsages.get(index);
            CsmObject csmItem = macroRef.getReferencedObject();
            if (csmItem == null) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("referenced macro is null. ref " + macroRef + ", file " + macroRef.getContainingFile() + ", name " + macroRef.getText()));
            }
            return csmItem;
        }
        return null;
    }

    private static DefineImpl getDefine(final Document doc, final CsmFile file, final int offset) {
        final DefineTarget dt = new DefineTarget();
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).render(new Runnable(){

                @Override
                public void run() {
                    TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)0, (boolean)false, (boolean)false);
                    int start = ReferencesSupport.getDefineStartOffset((TokenSequence<TokenId>)ts, offset);
                    if (start == -1) {
                        return;
                    }
                    ts.move(start);
                    if (!ts.moveNext()) {
                        return;
                    }
                    if (ts.token().id().equals(CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                        if ((ts = ts.embedded()) == null) {
                            return;
                        }
                        if (!ts.moveNext()) {
                            return;
                        }
                        if (!ts.token().id().equals(CppTokenId.PREPROCESSOR_START)) {
                            return;
                        }
                        if (!ts.moveNext()) {
                            return;
                        }
                        while (ts.token().id().equals(CppTokenId.WHITESPACE) || ts.token().id().equals(CppTokenId.NEW_LINE) || ts.token().id().equals(CppTokenId.BLOCK_COMMENT)) {
                            if (ts.moveNext()) continue;
                            return;
                        }
                        if (!ts.token().id().equals(CppTokenId.PREPROCESSOR_DEFINE)) {
                            return;
                        }
                        if (!ts.moveNext()) {
                            return;
                        }
                        while (ts.token().id().equals(CppTokenId.WHITESPACE) || ts.token().id().equals(CppTokenId.NEW_LINE) || ts.token().id().equals(CppTokenId.BLOCK_COMMENT)) {
                            if (ts.moveNext()) continue;
                            return;
                        }
                        if (!ts.token().id().equals(CppTokenId.PREPROCESSOR_IDENTIFIER)) {
                            return;
                        }
                        CharSequence name = ts.token().text();
                        if (!ts.moveNext()) {
                            return;
                        }
                        ArrayList<DefineParameterImpl> params = new ArrayList<DefineParameterImpl>();
                        if (ts.token().id().equals(CppTokenId.LPAREN)) {
                            while (!ts.token().id().equals(CppTokenId.RPAREN)) {
                                if (ts.token().id().equals(CppTokenId.PREPROCESSOR_IDENTIFIER)) {
                                    params.add(new DefineParameterImpl(ts.token().text(), file, ts.offset()));
                                }
                                if (ts.moveNext()) continue;
                            }
                        }
                        int end = ts.offset();
                        dt.setDefine(new DefineImpl(name, params, file, start, offset));
                    }
                }
            });
        }
        return dt.getDefine();
    }

    private static int getDefineStartOffset(TokenSequence<TokenId> ts, int offset) {
        if (!ts.moveNext()) {
            return -1;
        }
        int lastDefineOffset = -1;
        int currentOffset = ts.offset();
        while (currentOffset < offset) {
            if (ts.token().id().equals(CppTokenId.PREPROCESSOR_DIRECTIVE)) {
                lastDefineOffset = ts.offset();
            }
            if (!ts.moveNext()) break;
            currentOffset = ts.offset();
        }
        return lastDefineOffset;
    }

    private static class DefineImpl
    implements CsmOffsetable {
        private final int startOffset;
        private final int endOffset;
        private final CsmFile file;
        private final CharSequence name;
        private final List<DefineParameterImpl> params;

        public DefineImpl(CharSequence name, List<DefineParameterImpl> params, CsmFile file, int startOffset, int endOffset) {
            this.name = CharSequences.create((CharSequence)name);
            this.file = file;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.params = params;
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public CharSequence getText() {
            return this.name;
        }

        public List<DefineParameterImpl> getParams() {
            return this.params;
        }
    }

    private static class DefineTarget {
        private DefineImpl define;

        private DefineTarget() {
        }

        public DefineImpl getDefine() {
            return this.define;
        }

        public void setDefine(DefineImpl define) {
            this.define = define;
        }
    }

    private static class DefineParameterImpl
    implements CsmOffsetable,
    CsmNamedElement {
        private final CharSequence name;
        private final CsmFile file;
        private final int startOffset;

        public DefineParameterImpl(CharSequence name, CsmFile file, int startOffset) {
            this.name = CharSequences.create((CharSequence)name);
            this.file = file;
            this.startOffset = startOffset;
        }

        public CharSequence getName() {
            return this.name;
        }

        public CsmFile getContainingFile() {
            return this.file;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.startOffset + this.name.length();
        }

        public CsmOffsetable.Position getStartPosition() {
            return DUMMY_POSITION;
        }

        public CsmOffsetable.Position getEndPosition() {
            return DUMMY_POSITION;
        }

        public CharSequence getText() {
            return this.name;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 97 * hash + (this.file != null ? this.file.hashCode() : 0);
            hash = 97 * hash + this.startOffset;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefineParameterImpl other = (DefineParameterImpl)obj;
            if (!(this.name == other.name || this.name != null && this.name.equals(other.name))) {
                return false;
            }
            if (!(this.file == other.file || this.file != null && this.file.equals(other.file))) {
                return false;
            }
            return this.startOffset == other.startOffset;
        }
    }

    public static final class RefSupportDiagnostic
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return Bundle.RefSupportDiagnostic_displayName();
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            ReferencesSupport inst = instance;
            inst.cache.dumpInfo(printOut);
        }
    }

    private static final class RefOffsetKey
    implements CsmReference {
        private final int offset;

        private RefOffsetKey(int offset) {
            this.offset = offset;
        }

        public CsmReferenceKind getKind() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmObject getReferencedObject() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmObject getOwner() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmFile getContainingFile() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public int getStartOffset() {
            return this.offset;
        }

        public int getEndOffset() {
            return this.offset;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmObject getClosestTopLevelObject() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

