/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import java.util.HashSet;

public class EfNames {
    private static HashSet<String> reservedIdentifiers;

    public static boolean validClassName(String string) {
        int n;
        while ((n = string.indexOf(47)) >= 0) {
            if (!EfNames.validIdentifier(string.substring(0, n))) {
                return false;
            }
            string = string.substring(n + 1);
        }
        return EfNames.validIdentifier(string);
    }

    public static boolean validSrcFileName(String string) {
        int n;
        while ((n = string.indexOf(46)) >= 0) {
            if (!EfNames.validIdentifier(string.substring(0, n))) {
                return false;
            }
            string = string.substring(n + 1);
        }
        return EfNames.validIdentifier(string);
    }

    public static boolean validPackageName(String string) {
        return string.length() == 0 || EfNames.validClassName(string);
    }

    public static boolean isFieldReferenceType(String string) {
        switch (string.charAt(0)) {
            case 'B': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return false;
            }
            case 'L': 
            case '[': {
                return true;
            }
        }
        throw new VerifierError("EfField.6", string);
    }

    public static boolean validFieldName(String string) {
        return EfNames.validIdentifier(string);
    }

    public static boolean validMethodName(String string) {
        return string.equals("<init>") || EfNames.validIdentifier(string);
    }

    private static boolean validIdentifier(String string) {
        if (string.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return !reservedIdentifiers.contains(string);
    }

    public static boolean validFieldDescriptor(String string) {
        return EfNames.checkDescriptor(string, 0) == string.length();
    }

    public static boolean validMethodDescriptor(String string) {
        int n;
        int n2;
        block5: {
            n2 = string.length();
            if (n2 == 0) {
                return false;
            }
            if (string.charAt(0) != '(') {
                return false;
            }
            n = 1;
            do {
                if (n >= n2) {
                    return false;
                }
                if (string.charAt(n) == ')') break block5;
            } while ((n = EfNames.checkDescriptor(string, n)) >= 0);
            return false;
        }
        if (++n == n2 - 1 && string.charAt(n) == 'V') {
            return true;
        }
        return EfNames.checkDescriptor(string, n) == n2;
    }

    private static int checkDescriptor(String string, int n) {
        if (n >= string.length()) {
            return -1;
        }
        switch (string.charAt(n)) {
            case 'B': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return n + 1;
            }
            case 'L': {
                int n2 = string.indexOf(59, n + 1);
                if (n2 >= 0 && EfNames.validClassName(string.substring(n + 1, n2))) {
                    return n2 + 1;
                }
                return -1;
            }
            case '[': {
                return EfNames.checkDescriptor(string, n + 1);
            }
        }
        return -1;
    }

    static String prettyClass(String string) {
        return string.replace('/', '.');
    }

    static String prettyField(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        EfNames.prettyDescriptor(string2, 0, stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static String prettyMethod(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        EfNames.prettyDescriptor(string2, string2.indexOf(41) + 1, stringBuffer);
        stringBuffer.append(' ');
        stringBuffer.append(string);
        stringBuffer.append('(');
        int n = 1;
        if (string2.charAt(n) != ')') {
            while (string2.charAt(n = EfNames.prettyDescriptor(string2, n, stringBuffer)) != ')') {
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static int prettyDescriptor(String string, int n, StringBuffer stringBuffer) {
        switch (string.charAt(n)) {
            case 'B': {
                stringBuffer.append("byte");
                return n + 1;
            }
            case 'I': {
                stringBuffer.append("int");
                return n + 1;
            }
            case 'S': {
                stringBuffer.append("short");
                return n + 1;
            }
            case 'Z': {
                stringBuffer.append("boolean");
                return n + 1;
            }
            case 'V': {
                stringBuffer.append("void");
                return n + 1;
            }
            case 'L': {
                int n2 = string.indexOf(59, n + 1);
                stringBuffer.append(EfNames.prettyClass(string.substring(n + 1, n2)));
                return n2 + 1;
            }
            case '[': {
                n = EfNames.prettyDescriptor(string, n + 1, stringBuffer);
                stringBuffer.append("[]");
                return n;
            }
        }
        return -1;
    }

    static {
        String[] stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "class", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "this", "throw", "throws", "try", "void", "while", "true", "false", "null"};
        reservedIdentifiers = new HashSet();
        for (String string : stringArray) {
            reservedIdentifiers.add(string);
        }
    }
}

