/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.netbeans.modules.cnd.api.model.CsmExpressionBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmVariadicSpecializationParameter;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndCollectionUtils;

public class VariadicSpecializationParameterImpl
extends OffsetableBase
implements CsmVariadicSpecializationParameter,
SelfPersistent,
Persistent {
    private final List<CsmSpecializationParameter> args = new ArrayList<CsmSpecializationParameter>();

    public VariadicSpecializationParameterImpl(List<CsmSpecializationParameter> args, CsmFile file, int start, int end) {
        super(file, start, end);
        this.args.addAll(args);
    }

    public CsmScope getScope() {
        return null;
    }

    public List<CsmSpecializationParameter> getArgs() {
        return this.args;
    }

    @Override
    public CharSequence getText() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (CsmSpecializationParameter p : this.getArgs()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)p)) {
                sb.append(TypeImpl.getCanonicalText(((CsmTypeBasedSpecializationParameter)p).getType()));
            }
            if (!CsmKindUtilities.isExpressionBasedSpecalizationParameter((CsmObject)p)) continue;
            sb.append(((CsmExpressionBasedSpecializationParameter)p).getText());
        }
        return sb;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        for (CsmSpecializationParameter a : this.args) {
            hash = 29 * hash + Objects.hashCode(a);
        }
        hash = 29 * hash + Objects.hashCode(super.hashCode());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariadicSpecializationParameterImpl other = (VariadicSpecializationParameterImpl)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return CndCollectionUtils.equals(this.args, other.args);
    }

    @Override
    public String toString() {
        return this.getText().toString();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeSpecializationParameters(this.args, output);
    }

    public VariadicSpecializationParameterImpl(RepositoryDataInput input) throws IOException {
        super(input);
        PersistentUtils.readSpecializationParameters(this.args, input);
    }
}

