/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;
import org.netbeans.modules.mobility.end2end.E2EDataObject;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassService;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.PortData;
import org.netbeans.modules.mobility.end2end.classdata.TypeData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedTreeBeanView;
import org.netbeans.modules.mobility.end2end.ui.treeview.MultiStateCheckBox;
import org.netbeans.modules.mobility.end2end.util.ServiceNodeManager;
import org.netbeans.modules.mobility.end2end.util.Util;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ServicesPanel
extends SectionInnerPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static final RequestProcessor RP = new RequestProcessor(ServicesPanel.class);
    private final String INVALID_OPERATION = "TXT_InvalidOperation";
    private final String INVALID_OPERATION_NULL_PARAM = "TXT_InvalidOperationNoParam";
    private final JLabel servicesLabel;
    private final MethodCheckedTreeBeanView checkedTreeView;
    private final Node waitNode;
    private final transient E2EDataObject dataObject;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final RequestProcessor.Task repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            ServicesPanel.this.updateTree();
        }
    });
    private final RequestProcessor.Task changeTask = RP.create(new Runnable(){

        @Override
        public void run() {
            ServicesPanel.this.selectionChanged();
        }
    });
    private Configuration configuration;
    boolean wsdl = false;
    private FileObject serverProjectFolder;
    private transient ExplorerManager manager;
    private transient Node rootNode;
    private JButton generateButton;

    public ServicesPanel(SectionView sectionView, final E2EDataObject dataObject) {
        super(sectionView);
        this.dataObject = dataObject;
        this.initComponents();
        this.servicesLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 11, 5, 0);
        this.add(this.servicesLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = dataObject != null ? new Insets(5, 10, 5, 0) : new Insets(5, 0, 5, 0);
        this.checkedTreeView = new MethodCheckedTreeBeanView();
        this.waitNode = this.checkedTreeView.getWaitNode();
        this.checkedTreeView.setPopupAllowed(false);
        this.checkedTreeView.setDefaultActionAllowed(false);
        this.checkedTreeView.setBorder(new LineBorder(Color.BLACK, 1, true));
        this.checkedTreeView.setRootVisible(true);
        this.getExplorerManager().setRootContext(this.waitNode);
        this.add((Component)((Object)this.checkedTreeView), gridBagConstraints);
        this.servicesLabel.setLabelFor((Component)((Object)this.checkedTreeView));
        this.generateButton.setEnabled(false);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicesPanel.class, (String)"ACSD_ServicesPanel"));
        this.checkedTreeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServicesPanel.class, (String)"ACSD_Services"));
        if (dataObject == null || dataObject.isGenerating()) {
            this.generateButton.setEnabled(false);
        }
        if (dataObject == null) {
            this.generateButton.setVisible(false);
        }
        this.checkedTreeView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (dataObject != null) {
                    ServicesPanel.this.dataObject.setModified(true);
                }
                ServicesPanel.this.changeTask.schedule(100);
            }
        });
        if (dataObject != null) {
            this.setConfiguration(dataObject.getConfiguration());
            dataObject.addPropertyChangeListener(this);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        if (configuration != null) {
            this.wsdl = "wsdlClass".equals(configuration.getServiceType());
            Mnemonics.setLocalizedText((JLabel)this.servicesLabel, (String)NbBundle.getMessage(ServicesPanel.class, (String)(this.wsdl ? "LBL_Operations" : "LBL_Methods")));
            this.waitNode.setDisplayName(NbBundle.getMessage(ServicesPanel.class, (String)(this.wsdl ? "MSG_WaitComputingWebServices" : "MSG_WaitComputingMethods")));
            this.getExplorerManager().setRootContext(this.waitNode);
            this.repaintingTask.schedule(100);
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void removeNotify() {
        if (this.repaintingTask != null) {
            this.repaintingTask.cancel();
        }
        if (this.changeTask != null) {
            this.changeTask.cancel();
        }
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.dataObject != null) {
            this.dataObject.removePropertyChangeListener(this);
        }
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    private void updateTree() {
        if (!this.wsdl) {
            this.rootNode = ServiceNodeManager.getRootNode(this.configuration, this.checkedTreeView);
        } else {
            Project serverProject = Util.getServerProject(this.configuration);
            List<AbstractService> services = this.configuration.getServices();
            WSDLService service = (WSDLService)services.get(0);
            JAXWSClientView a = JAXWSClientView.getJAXWSClientView();
            this.rootNode = a.createJAXWSClientView(serverProject);
            for (Node nn : this.rootNode.getChildren().getNodes()) {
                if (!nn.getName().equals(service.getName())) continue;
                this.rootNode = nn;
                break;
            }
            if (this.rootNode.getChildren().getNodesCount() == 0) {
                this.repaintingTask.schedule(500);
                return;
            }
            List<org.netbeans.modules.mobility.end2end.classdata.ClassData> ports = service.getData();
            HashSet<String> selectedIDs = new HashSet<String>();
            List<org.netbeans.modules.mobility.end2end.classdata.ClassData> data = this.configuration.getServices().get(0).getData();
            if (data != null) {
                for (org.netbeans.modules.mobility.end2end.classdata.ClassData cd : data) {
                    for (OperationData od : cd.getOperations()) {
                        StringBuffer sb = new StringBuffer(cd.getType());
                        sb.append('.').append(od.getMethodName());
                        for (TypeData td : od.getParameterTypes()) {
                            sb.append(',').append(td.getType());
                        }
                        selectedIDs.add(sb.toString());
                    }
                }
            }
            FileObject generatedClientFO = serverProject.getProjectDirectory().getFileObject("build/generated/wsimport/client/");
            List<ClasspathInfo> classpaths = Collections.singletonList(ClasspathInfo.create((FileObject)generatedClientFO));
            ClassDataRegistry registry = ClassDataRegistry.getRegistry("default", classpaths);
            final PortData port = ports != null && ports.size() > 0 ? (PortData)ports.get(0) : null;
            this.rootNode = new FilterNode(this.rootNode, (Children)new FilterNode.Children(this.rootNode){

                protected Node[] createNodes(Node serviceNode) {
                    return new Node[]{new FilterNode(serviceNode, (Children)new FilterNode.Children(serviceNode){
                        String firstWSPortName;
                        {
                            this.firstWSPortName = null;
                        }

                        protected Node[] createNodes(Node portNode) {
                            WSPort wsdlPort = (WSPort)portNode.getLookup().lookup(WSPort.class);
                            if (wsdlPort == null) {
                                return null;
                            }
                            if (this.firstWSPortName == null) {
                                this.firstWSPortName = wsdlPort.getName();
                            }
                            return portNode.getName().equals(port == null ? this.firstWSPortName : port.getName()) ? super.createNodes(portNode) : null;
                        }
                    })};
                }
            });
            for (Node serviceNode : this.rootNode.getChildren().getNodes()) {
                boolean serviceValid = false;
                for (Node portNode : serviceNode.getChildren().getNodes()) {
                    boolean portValid = false;
                    WSPort wsdlPort = (WSPort)portNode.getLookup().lookup(WSPort.class);
                    ClassData cd = registry.getClassData(wsdlPort.getJavaName());
                    HashSet<String> methodIDs = new HashSet<String>();
                    if (cd != null) {
                        for (MethodData md : cd.getMethods()) {
                            StringBuffer sb = new StringBuffer(md.getName());
                            for (MethodParameter mp : md.getParameters()) {
                                sb.append(',').append(mp.getType().getFullyQualifiedName());
                            }
                            methodIDs.add(sb.toString());
                        }
                    }
                    for (Node operationNode : portNode.getChildren().getNodes()) {
                        WSOperation wsdlOperation = (WSOperation)operationNode.getLookup().lookup(WSOperation.class);
                        boolean operationValid = false;
                        StringBuilder operationId = new StringBuilder();
                        StringBuilder parameters = new StringBuilder();
                        if (wsdlOperation != null) {
                            operationId.append(wsdlOperation.getJavaName());
                            for (WSParameter par : wsdlOperation.getParameters()) {
                                String pt = par.getTypeName();
                                int i = pt.indexOf(60);
                                operationId.append(',').append(i > 0 ? pt.substring(0, i) : pt);
                                parameters.append(i > 0 ? pt.substring(0, i) : pt);
                                parameters.append(", ");
                            }
                            operationValid = methodIDs.contains(operationId.toString());
                        }
                        operationNode.setValue("isValid", (Object)operationValid);
                        if (!operationValid) {
                            String message;
                            if (parameters.length() > 0) {
                                message = NbBundle.getMessage(ServicesPanel.class, (String)"TXT_InvalidOperation");
                                String params = message.substring(0, message.length() - 2);
                                operationNode.setShortDescription(MessageFormat.format(message, wsdlOperation.getName(), params));
                            } else {
                                message = NbBundle.getMessage(ServicesPanel.class, (String)"TXT_InvalidOperationNoParam");
                                operationNode.setShortDescription(MessageFormat.format(message, wsdlOperation.getName()));
                            }
                        }
                        if (operationValid && cd != null) {
                            operationNode.setValue("isSelected", (Object)(selectedIDs.contains(cd.getFullyQualifiedName() + '.' + operationId.toString()) ? MultiStateCheckBox.State.SELECTED : MultiStateCheckBox.State.UNSELECTED));
                        }
                        portValid = portValid || operationValid;
                    }
                    portNode.setValue("isValid", (Object)portValid);
                    serviceValid = serviceValid || portValid;
                }
                serviceNode.setValue("isValid", (Object)serviceValid);
            }
            this.checkedTreeView.updateTreeNodeStates(null);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (!ServicesPanel.this.wsdl && ServicesPanel.this.rootNode.getChildren().getNodesCount() == 0) {
                        ServicesPanel.this.waitNode.setDisplayName(NbBundle.getMessage(ServicesPanel.class, (String)"MSG_NoMethodAvailable"));
                        return;
                    }
                    ServicesPanel.this.checkedTreeView.setRootVisible(false);
                    ServicesPanel.this.checkedTreeView.setRoot(ServicesPanel.this.rootNode);
                    ServicesPanel.this.getExplorerManager().setRootContext(ServicesPanel.this.rootNode);
                    ServicesPanel.this.expandNodes(ServicesPanel.this.rootNode);
                    ServicesPanel.this.checkValid();
                }
            });
        }
        catch (Exception ite) {
            ErrorManager.getDefault().notify((Throwable)ite);
        }
    }

    private void expandNodes(Node n) {
        if (Boolean.FALSE != n.getValue("isValid")) {
            this.checkedTreeView.expandNode(n);
        }
        for (Node ch : n.getChildren().getNodes()) {
            this.expandNodes(ch);
        }
    }

    private void selectionChanged() {
        this.getSelectedMethods();
        this.checkValid();
        this.fireChange();
    }

    private void checkValid() {
        AbstractService service = this.configuration.getServices().get(0);
        SectionView sectionView = this.getSectionView();
        if (sectionView != null) {
            if (service == null || service != null && service.getData().size() == 0) {
                sectionView.getErrorPanel().setError(new Error(0, 2, NbBundle.getMessage(ServicesPanel.class, (String)"ERR_MissingServiceSelection"), (JComponent)((Object)this.checkedTreeView)));
                this.generateButton.setEnabled(false);
            } else {
                sectionView.getErrorPanel().clearError();
                this.generateButton.setEnabled(true);
            }
        }
    }

    public void getSelectedMethods() {
        if (!this.wsdl) {
            Node[] packageNodes;
            ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData> classData = new ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData>();
            for (Node pkNode : packageNodes = this.rootNode.getChildren().getNodes()) {
                Node[] classNodes;
                for (Node clNode : classNodes = pkNode.getChildren().getNodes()) {
                    Node[] methodNodes = clNode.getChildren().getNodes();
                    ArrayList<OperationData> methodData = new ArrayList<OperationData>();
                    for (Node node : methodNodes) {
                        if (MultiStateCheckBox.State.SELECTED != node.getValue("isSelected")) continue;
                        MethodData mthData = (MethodData)node.getLookup().lookup(MethodData.class);
                        List<MethodParameter> params = mthData.getParameters();
                        ArrayList<TypeData> newParams = new ArrayList<TypeData>(params.size());
                        for (MethodParameter param : params) {
                            TypeData td = new TypeData(param.getName(), param.getType().getFullyQualifiedName());
                            newParams.add(td);
                        }
                        OperationData od = new OperationData(mthData.getName());
                        od.setReturnType(mthData.getReturnType().getFullyQualifiedName());
                        od.setParameterTypes(newParams);
                        methodData.add(od);
                    }
                    if (methodData.size() == 0) continue;
                    String classFQN = ((ClassData)clNode.getLookup().lookup(ClassData.class)).getFullyQualifiedName();
                    org.netbeans.modules.mobility.end2end.classdata.ClassData cd = new org.netbeans.modules.mobility.end2end.classdata.ClassData(classFQN);
                    cd.setOperations(methodData);
                    classData.add(cd);
                }
            }
            ClassService classService = (ClassService)this.configuration.getServices().get(0);
            classService.setData(classData);
            ArrayList<AbstractService> services = new ArrayList<AbstractService>();
            services.add(classService);
            this.configuration.setServices(services);
        } else {
            ArrayList<AbstractService> servicesData = new ArrayList<AbstractService>();
            Client client = (Client)this.rootNode.getLookup().lookup(Client.class);
            if (client != null) {
                for (Node serviceNode : this.rootNode.getChildren().getNodes()) {
                    ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData> classData = new ArrayList<org.netbeans.modules.mobility.end2end.classdata.ClassData>();
                    for (Node portNode : serviceNode.getChildren().getNodes()) {
                        WSPort port = (WSPort)portNode.getLookup().lookup(WSPort.class);
                        ArrayList<OperationData> methodData = new ArrayList<OperationData>();
                        if (port != null) {
                            for (Node operationNode : portNode.getChildren().getNodes()) {
                                String operationName = operationNode.getName();
                                if (MultiStateCheckBox.State.SELECTED != operationNode.getValue("isSelected")) continue;
                                WSOperation wsdlOp = (WSOperation)operationNode.getLookup().lookup(WSOperation.class);
                                OperationData md = new OperationData(operationName);
                                md.setMethodName(wsdlOp.getJavaName());
                                md.setReturnType(wsdlOp.getReturnTypeName());
                                List wsdlParams = wsdlOp.getParameters();
                                ArrayList<TypeData> params = new ArrayList<TypeData>();
                                for (WSParameter param : wsdlParams) {
                                    params.add(new TypeData(param.getName(), param.getTypeName()));
                                }
                                md.setParameterTypes(params);
                                if (md == null) continue;
                                methodData.add(md);
                            }
                        }
                        if (port == null || methodData.size() <= 0) continue;
                        PortData pd = new PortData(port.getJavaName());
                        pd.setName(portNode.getName());
                        pd.setOperations(methodData);
                        classData.add(pd);
                    }
                    WSDLService wsdlService = (WSDLService)this.configuration.getServices().get(0);
                    wsdlService.setData(classData);
                    wsdlService.setName(this.rootNode.getName());
                    wsdlService.setType(serviceNode.getName());
                    servicesData.add(wsdlService);
                }
            }
            this.configuration.setServices(servicesData);
        }
    }

    private void initComponents() {
        this.generateButton = new JButton();
        this.setPreferredSize(new Dimension(500, 350));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.generateButton, (String)NbBundle.getBundle(ServicesPanel.class).getString("LBL_Generate"));
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServicesPanel.this.generateButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 12, 0, 11);
        this.add(this.generateButton, gridBagConstraints);
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        this.dataObject.generate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("generating".equals(evt.getPropertyName())) {
            this.generateButton.setEnabled((Boolean)evt.getNewValue() == false);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener cl : this.listeners) {
            cl.stateChanged(e);
        }
    }

    public void setServerProjectFolder(FileObject serverProjectFolder) {
        this.serverProjectFolder = serverProjectFolder;
    }

    public void setValue(JComponent source, Object value) {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }
}

