/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutMetricDataRequestMarshaller
implements Marshaller<Request<PutMetricDataRequest>, PutMetricDataRequest> {
    @Override
    public Request<PutMetricDataRequest> marshall(PutMetricDataRequest putMetricDataRequest) {
        DefaultRequest<PutMetricDataRequest> request = new DefaultRequest<PutMetricDataRequest>(putMetricDataRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutMetricData");
        request.addParameter("Version", "2010-08-01");
        if (putMetricDataRequest != null && putMetricDataRequest.getNamespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString(putMetricDataRequest.getNamespace()));
        }
        if (putMetricDataRequest != null) {
            List<MetricDatum> metricDataList = putMetricDataRequest.getMetricData();
            int metricDataListIndex = 1;
            for (MetricDatum metricDataListValue : metricDataList) {
                if (metricDataListValue != null && metricDataListValue.getMetricName() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".MetricName", StringUtils.fromString(metricDataListValue.getMetricName()));
                }
                if (metricDataListValue != null) {
                    List<Dimension> dimensionsList = metricDataListValue.getDimensions();
                    int dimensionsListIndex = 1;
                    for (Dimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue != null && dimensionsListValue.getName() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString(dimensionsListValue.getName()));
                        }
                        if (dimensionsListValue != null && dimensionsListValue.getValue() != null) {
                            request.addParameter("MetricData.member." + metricDataListIndex + ".Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString(dimensionsListValue.getValue()));
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (metricDataListValue != null && metricDataListValue.getTimestamp() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Timestamp", StringUtils.fromDate(metricDataListValue.getTimestamp()));
                }
                if (metricDataListValue != null && metricDataListValue.getValue() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Value", StringUtils.fromDouble(metricDataListValue.getValue()));
                }
                if (metricDataListValue != null) {
                    StatisticSet statisticValues = metricDataListValue.getStatisticValues();
                    if (statisticValues != null && statisticValues.getSampleCount() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.SampleCount", StringUtils.fromDouble(statisticValues.getSampleCount()));
                    }
                    if (statisticValues != null && statisticValues.getSum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Sum", StringUtils.fromDouble(statisticValues.getSum()));
                    }
                    if (statisticValues != null && statisticValues.getMinimum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Minimum", StringUtils.fromDouble(statisticValues.getMinimum()));
                    }
                    if (statisticValues != null && statisticValues.getMaximum() != null) {
                        request.addParameter("MetricData.member." + metricDataListIndex + ".StatisticValues.Maximum", StringUtils.fromDouble(statisticValues.getMaximum()));
                    }
                }
                if (metricDataListValue != null && metricDataListValue.getUnit() != null) {
                    request.addParameter("MetricData.member." + metricDataListIndex + ".Unit", StringUtils.fromString(metricDataListValue.getUnit()));
                }
                ++metricDataListIndex;
            }
        }
        return request;
    }
}

