/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.macroview;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionPanel;
import org.netbeans.modules.cnd.navigation.macroview.MacroExpansionViewUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

public final class MacroExpansionTopComponent
extends TopComponent {
    private static final Logger LOGGER = Logger.getLogger(MacroExpansionTopComponent.class.getName());
    private static MacroExpansionTopComponent instance;
    public static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/macroview/resources/macroexpansion.png";
    private static final String PREFERRED_ID = "MacroExpansionTopComponent";
    private static final String LOCAL_KEY = "show-local-context";
    private static final String SYNC_KEY = "sync-context";
    private MacroExpansionPanel panel = null;
    private Document lastExpandedContextDoc = null;
    private JButton jButton1;
    private static final AtomicBoolean panelInitialized;

    private MacroExpansionTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"CTL_MacroExpansionTopComponent"));
        this.setToolTipText(NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"HINT_MacroExpansionTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    public void setDocuments(Document expandedContextDoc) {
        this.lastExpandedContextDoc = expandedContextDoc;
        if (this.panel == null) {
            this.panel = new MacroExpansionPanel(true);
            this.removeAll();
            this.add(this.panel, "Center");
        }
        this.panel.setContextExpansionDocument(expandedContextDoc);
        if (MacroExpansionTopComponent.isSyncCaretAndContext()) {
            this.panel.updateCaretPosition();
        }
        this.validate();
        panelInitialized.set(true);
    }

    public void updateCaretPosition() {
        if (this.panel != null) {
            this.panel.updateCaretPosition();
        }
    }

    public static boolean isLocalContext() {
        return NbPreferences.forModule(MacroExpansionTopComponent.class).getBoolean(LOCAL_KEY, true);
    }

    public static void setLocalContext(boolean localContext) {
        NbPreferences.forModule(MacroExpansionTopComponent.class).putBoolean(LOCAL_KEY, localContext);
    }

    public static boolean isSyncCaretAndContext() {
        return NbPreferences.forModule(MacroExpansionTopComponent.class).getBoolean(SYNC_KEY, true);
    }

    public static void setSyncCaretAndContext(boolean syncContext) {
        NbPreferences.forModule(MacroExpansionTopComponent.class).putBoolean(SYNC_KEY, syncContext);
    }

    public Document getExpandedContextDoc() {
        return this.lastExpandedContextDoc;
    }

    public void setStatusBarText(String s) {
        if (this.panel != null) {
            this.panel.setStatusBarText(s);
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(MacroExpansionTopComponent.class, (String)"NoViewAvailable"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setEnabled(false);
        this.add(this.jButton1, "Center");
    }

    public static synchronized MacroExpansionTopComponent getDefault() {
        if (instance == null) {
            instance = new MacroExpansionTopComponent();
        }
        return instance;
    }

    static synchronized MacroExpansionTopComponent getInstance() {
        return instance;
    }

    public static synchronized MacroExpansionTopComponent findInstance() {
        TopComponent win = CsmUtilities.getTopComponentInEQ((String)PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(MacroExpansionTopComponent.class.getName()).warning("Cannot find MacroExpansionTopComponent component. It will not be located properly in the window system.");
            return MacroExpansionTopComponent.getDefault();
        }
        if (win instanceof MacroExpansionTopComponent) {
            return (MacroExpansionTopComponent)win;
        }
        Logger.getLogger(MacroExpansionTopComponent.class.getName()).warning("There seem to be multiple components with the 'MacroExpansionTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return MacroExpansionTopComponent.getDefault();
    }

    public void requestActive() {
        super.requestActive();
        if (this.panel != null) {
            this.panel.requestFocusInWindow();
        }
    }

    public int getPersistenceType() {
        return 0;
    }

    public static boolean isMacroExpansionInitialized() {
        return panelInitialized.get();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("MacroExpansionWindow");
    }

    public void componentClosed() {
        this.removeAll();
        this.initComponents();
        if (this.panel != null) {
            Document doc = this.getExpandedContextDoc();
            if (doc != null) {
                Document doc2 = (Document)doc.getProperty(Document.class);
                if (doc2 != null) {
                    doc2.putProperty(Document.class, null);
                }
                MacroExpansionViewUtils.closeMemoryBasedDocument(doc);
            }
            this.lastExpandedContextDoc = null;
            this.panel.removeAll();
            this.panel = null;
            panelInitialized.set(false);
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        panelInitialized = new AtomicBoolean(false);
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return MacroExpansionTopComponent.getDefault();
        }
    }
}

