/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.ojet.data.DataProviderImpl;
import org.netbeans.modules.html.ojet.data.OJETPreferences;
import org.netbeans.modules.html.ojet.ui.Bundle;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class OJETPanel
extends JPanel
implements CustomizerPanelImplementation {
    public static final String IDENTIFIER = "ojet";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Project project;
    private final ProjectCustomizer.Category category;
    private JComboBox cbVersion;
    private JLabel lVersion;

    public OJETPanel(Project project, ProjectCustomizer.Category category) {
        this.project = project;
        this.category = category;
        this.initComponents();
        this.initData();
    }

    private void initData() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String version : DataProviderImpl.getInstance().getAvailableVersions()) {
            model.addElement(version);
        }
        model.setSelectedItem(OJETPreferences.get(this.project, OJETPreferences.VERSION));
        this.cbVersion.setModel(model);
        this.category.setStoreListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OJETPanel.this.save();
            }
        });
    }

    private void initComponents() {
        this.cbVersion = new JComboBox();
        this.lVersion = new JLabel();
        this.cbVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbVersion.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OJETPanel.this.cbVersionItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lVersion, (String)NbBundle.getMessage(OJETPanel.class, (String)"OJETPanel.lVersion.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lVersion).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbVersion, 0, 265, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbVersion, -2, -1, -2).addComponent(this.lVersion)).addContainerGap(269, Short.MAX_VALUE)));
    }

    private void cbVersionItemStateChanged(ItemEvent evt) {
        this.changeSupport.fireChange();
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.OJETPanel_name();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public JComponent getComponent() {
        return this;
    }

    public String getErrorMessage() {
        return null;
    }

    public String getWarningMessage() {
        return null;
    }

    public void save() {
        DataProviderImpl.getInstance().setCurrentVersion((String)this.cbVersion.getSelectedItem());
        OJETPreferences.put(this.project, OJETPreferences.VERSION, (String)this.cbVersion.getSelectedItem());
    }
}

