/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitCherryPickResult {
    private final CherryPickStatus status;
    private final List<VCSFileProxy> conflicts;
    private final List<VCSFileProxy> failures;
    private final GitRevisionInfo currentHead;
    private final List<GitRevisionInfo> cherryPickedCommits;

    GitCherryPickResult(CherryPickStatus status, List<VCSFileProxy> conflicts, List<VCSFileProxy> failures, GitRevisionInfo currentHead, List<GitRevisionInfo> cherryPickedCommits) {
        this.status = status;
        this.currentHead = currentHead;
        this.conflicts = conflicts;
        this.failures = failures;
        this.cherryPickedCommits = cherryPickedCommits;
    }

    public CherryPickStatus getCherryPickStatus() {
        return this.status;
    }

    public GitRevisionInfo getCurrentHead() {
        return this.currentHead;
    }

    public Collection<VCSFileProxy> getConflicts() {
        return Collections.unmodifiableList(this.conflicts);
    }

    public Collection<VCSFileProxy> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public GitRevisionInfo[] getCherryPickedCommits() {
        return this.cherryPickedCommits.toArray(new GitRevisionInfo[this.cherryPickedCommits.size()]);
    }

    public static enum CherryPickStatus {
        OK,
        ABORTED,
        FAILED,
        UNCOMMITTED,
        CONFLICTING;

    }
}

