/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class GitRevertResult {
    private final Status status;
    private final GitRevisionInfo revertCommit;
    private final List<VCSFileProxy> conflicts;
    private final List<VCSFileProxy> failures;

    GitRevertResult(Status status, GitRevisionInfo commit, List<VCSFileProxy> conflicts, List<VCSFileProxy> failures) {
        this.status = status;
        this.revertCommit = commit;
        this.conflicts = conflicts == null ? Collections.emptyList() : conflicts;
        this.failures = failures == null ? Collections.emptyList() : failures;
    }

    public Status getStatus() {
        return this.status;
    }

    public GitRevisionInfo getNewHead() {
        return this.revertCommit;
    }

    public Collection<VCSFileProxy> getConflicts() {
        return this.conflicts;
    }

    public Collection<VCSFileProxy> getFailures() {
        return this.failures;
    }

    public static enum Status {
        REVERTED{

            public String toString() {
                return "Reverted";
            }
        }
        ,
        REVERTED_IN_INDEX{

            public String toString() {
                return "Reverted In Index";
            }
        }
        ,
        CONFLICTING{

            public String toString() {
                return "Conflicting";
            }
        }
        ,
        FAILED{

            public String toString() {
                return "Failed";
            }
        }
        ,
        NO_CHANGE{

            public String toString() {
                return "No Change";
            }
        };

    }
}

