/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.net.URI;
import java.net.URISyntaxException;

public final class GitURI {
    private URI uri;

    private GitURI() {
    }

    private GitURI create(URI uri) {
        GitURI u = new GitURI();
        u.uri = uri;
        return u;
    }

    public GitURI(String uriString) throws URISyntaxException {
        this.uri = new URI(uriString);
        String scheme = this.uri.getScheme();
        if (scheme != null && !scheme.startsWith("file:") && this.uri.getHost() == null && !uriString.endsWith("/")) {
            this.uri = new URI(uriString + "/");
        }
    }

    public String toPrivateString() {
        return this.uri.toString();
    }

    public GitURI setUser(String user) {
        return this;
    }

    public GitURI setPass(String password) {
        return this;
    }

    public String getUser() {
        return this.uri.getUserInfo();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof GitURI) {
            return this.uri.equals(((GitURI)o).uri);
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

