/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.ide.JBOutputSupport;
import org.netbeans.modules.j2ee.jboss4.ide.JBStartServer;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class JBStopRunnable
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(JBStopRunnable.class.getName());
    private static final String SHUTDOWN_SH = "/bin/shutdown.sh";
    private static final String JBOSS_CLI_SH = "/bin/jboss-cli.sh";
    private static final String SHUTDOWN_BAT = "/bin/shutdown.bat";
    private static final String JBOSS_CLI_BAT = "/bin/jboss-cli.bat";
    private static final int TIMEOUT = 300000;
    private final JBDeploymentManager dm;
    private final JBStartServer startServer;

    JBStopRunnable(JBDeploymentManager dm, JBStartServer startServer) {
        this.dm = dm;
        this.startServer = startServer;
    }

    private boolean isJBoss7() {
        return this.dm.getProperties().isVersion(JBPluginUtils.JBOSS_7_0_0);
    }

    private String[] createEnvironment() {
        JBProperties properties = this.dm.getProperties();
        JavaPlatform platform = properties.getJavaPlatform();
        FileObject fo = (FileObject)platform.getInstallFolders().iterator().next();
        String javaHome = FileUtil.toFile((FileObject)fo).getAbsolutePath();
        ArrayList<String> envp = new ArrayList<String>(3);
        envp.add("JAVA=" + javaHome + "/bin/java");
        envp.add("JAVA_HOME=" + javaHome);
        envp.add("JBOSS_HOME=" + properties.getRootDir().getAbsolutePath());
        if (Utilities.isWindows()) {
            envp.add("NOPAUSE=true");
        }
        return envp.toArray(new String[envp.size()]);
    }

    @Override
    public void run() {
        NbProcessDescriptor pd;
        InstanceProperties ip = this.dm.getInstanceProperties();
        String configName = ip.getProperty("server");
        if ("minimal".equals(configName)) {
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_MINIMAL")));
            return;
        }
        String serverName = ip.getProperty("displayName");
        String serverLocation = ip.getProperty("root-dir");
        String serverStopFileName = serverLocation + (this.isJBoss7() ? (Utilities.isWindows() ? JBOSS_CLI_BAT : JBOSS_CLI_SH) : (Utilities.isWindows() ? SHUTDOWN_BAT : SHUTDOWN_SH));
        File serverStopFile = new File(serverStopFileName);
        if (!serverStopFile.exists()) {
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_FNF", (Object)serverName)));
            return;
        }
        JBProperties properties = this.dm.getProperties();
        StringBuilder additionalParams = new StringBuilder(32);
        if (this.isJBoss7()) {
            pd = new NbProcessDescriptor(serverStopFileName, "--connect --controller=localhost:" + JBPluginUtils.getJmxPortNumber(properties, ip) + " --command=:shutdown");
        } else {
            if (this.dm.getProperties().getServerVersion().compareTo(JBPluginUtils.JBOSS_6_0_0) < 0) {
                int jnpPort = JBPluginUtils.getJnpPortNumber(ip.getProperty("server-dir"));
                additionalParams.append(" -s jnp://localhost:").append(jnpPort);
            }
            additionalParams.append(" -u ").append(properties.getUsername());
            additionalParams.append(" -p ").append(properties.getPassword());
            pd = new NbProcessDescriptor(serverStopFileName, "--shutdown " + additionalParams);
        }
        Process stoppingProcess = null;
        try {
            String[] envp = this.createEnvironment();
            stoppingProcess = pd.exec(null, envp, true, null);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED_PD", (Object)serverName, (Object)serverStopFileName)));
            return;
        }
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
        LOGGER.log(Level.FINER, "Entering the loop");
        int elapsed = 0;
        while (elapsed < 300000) {
            block21: {
                try {
                    int processExitValue = stoppingProcess.exitValue();
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "The stopping process has terminated with the exit value " + processExitValue);
                    }
                    if (processExitValue != 0) {
                        String msg = NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED", (Object)serverName);
                        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, msg));
                        return;
                    }
                }
                catch (IllegalThreadStateException processExitValue) {
                    // empty catch block
                }
                if (this.startServer.isRunning()) {
                    this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
                    LOGGER.log(Level.FINER, "STOPPING message fired");
                    try {
                        elapsed += 500;
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException processExitValue) {}
                    continue;
                }
                LOGGER.log(Level.FINER, "JBoss has been stopped, going to stop the Log Writer thread");
                JBOutputSupport outputSupport = JBOutputSupport.getInstance(ip, false);
                try {
                    if (outputSupport == null) break block21;
                    try {
                        outputSupport.waitForStop(10000L);
                    }
                    catch (TimeoutException ex) {
                        LOGGER.log(Level.FINE, null, ex);
                    }
                    outputSupport.stop();
                }
                catch (InterruptedException ex) {
                    this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_StopServerInterrupted", (Object)serverName)));
                    LOGGER.log(Level.INFO, null, ex);
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (ExecutionException ex) {
                    this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_STOP_SERVER_FAILED", (Object)serverName)));
                    LOGGER.log(Level.INFO, null, ex);
                    return;
                }
            }
            this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.COMPLETED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_SERVER_STOPPED", (Object)serverName)));
            LOGGER.log(Level.FINER, "STOPPED message fired");
            return;
        }
        this.startServer.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(JBStopRunnable.class, (String)"MSG_StopServerTimeout")));
        if (stoppingProcess != null) {
            stoppingProcess.destroy();
        }
        LOGGER.log(Level.FINER, "TIMEOUT expired");
    }
}

