/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashSet;
import org.netbeans.modules.remote.impl.RemoteLogger;
import org.netbeans.modules.remote.impl.fs.RemoteExceptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class FastPasteAction
extends CookieAction {
    protected Class<?>[] cookieClasses() {
        return new Class[]{DataFolder.class};
    }

    protected void performAction(Node[] nodes) {
        DataFlavor[] flavors;
        HashSet<FileObject> fileObjects = new HashSet<FileObject>();
        Transferable rf = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        for (DataFlavor dataFlavor : flavors = rf.getTransferDataFlavors()) {
            if (!dataFlavor.getRepresentationClass().isAssignableFrom(Node.class)) continue;
            try {
                FileObject fo;
                DataObject dao;
                Object transferData = rf.getTransferData(dataFlavor);
                if (!(transferData instanceof Node) || (dao = (DataObject)((Node)transferData).getLookup().lookup(DataObject.class)) == null || (fo = dao.getPrimaryFile()) == null) continue;
                fileObjects.add(fo);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                RemoteLogger.fine(ex);
            }
        }
        if (!fileObjects.isEmpty()) {
            for (DataFlavor dataFlavor : nodes) {
                DataFolder df = (DataFolder)dataFlavor.getLookup().lookup(DataFolder.class);
                if (df == null) continue;
                FileObject targetFolder = df.getPrimaryFile();
                for (FileObject fo : fileObjects) {
                    try {
                        this.testNesting(fo, targetFolder);
                        String suffix = this.existInFolder(fo, targetFolder);
                        String newName = fo.getName() + suffix;
                        fo.copy(targetFolder, newName, fo.getExt());
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private String existInFolder(FileObject fo, FileObject folder) {
        String orig = fo.getName();
        String name = FileUtil.findFreeFileName((FileObject)folder, (String)orig, (String)fo.getExt());
        if (name.length() <= orig.length()) {
            return "";
        }
        return name.substring(orig.length());
    }

    private void testNesting(FileObject folder, FileObject targetFolder) throws IOException {
        if (targetFolder.equals(folder)) {
            throw RemoteExceptions.createIOException(NbBundle.getMessage(FastPasteAction.class, (String)"EXC_CannotCopyTheSame", (Object)folder.getNameExt()));
        }
        for (FileObject testFolder = targetFolder.getParent(); testFolder != null; testFolder = testFolder.getParent()) {
            if (!testFolder.equals(folder)) continue;
            throw RemoteExceptions.createIOException(NbBundle.getMessage(FastPasteAction.class, (String)"EXC_CannotCopySubfolder", (Object)folder.getNameExt()));
        }
    }

    protected boolean asynchronous() {
        return true;
    }

    protected int mode() {
        return 8;
    }

    protected boolean enable(Node[] activatedNodes) {
        return super.enable(activatedNodes) && this.clipboardHasFolders();
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.clipboardHasFolders();
    }

    private boolean clipboardHasFolders() {
        DataFlavor[] flavors;
        Transferable tfr = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        for (DataFlavor fl : flavors = tfr.getTransferDataFlavors()) {
            if (!fl.getRepresentationClass().isAssignableFrom(Node.class)) continue;
            try {
                FileObject fo;
                DataObject dao;
                Object transferData = tfr.getTransferData(fl);
                if (!(transferData instanceof Node) || (dao = (DataObject)((Node)transferData).getLookup().lookup(DataObject.class)) == null || !(fo = dao.getPrimaryFile()).isFolder()) continue;
                return true;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                RemoteLogger.fine(ex);
            }
        }
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(FastPasteAction.class, (String)"LAB_FastPaste");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.remote.actions.PasteAction");
    }
}

