/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.RequestContextUtils;

class DefaultMvcResult
implements MvcResult {
    private final MockHttpServletRequest mockRequest;
    private final MockHttpServletResponse mockResponse;
    private Object handler;
    private HandlerInterceptor[] interceptors;
    private ModelAndView modelAndView;
    private Exception resolvedException;
    private Object asyncResult;
    private CountDownLatch asyncResultLatch;

    public DefaultMvcResult(MockHttpServletRequest request, MockHttpServletResponse response) {
        this.mockRequest = request;
        this.mockResponse = response;
    }

    @Override
    public MockHttpServletResponse getResponse() {
        return this.mockResponse;
    }

    @Override
    public MockHttpServletRequest getRequest() {
        return this.mockRequest;
    }

    @Override
    public Object getHandler() {
        return this.handler;
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }

    @Override
    public HandlerInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(HandlerInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public Exception getResolvedException() {
        return this.resolvedException;
    }

    public void setResolvedException(Exception resolvedException) {
        this.resolvedException = resolvedException;
    }

    @Override
    public ModelAndView getModelAndView() {
        return this.modelAndView;
    }

    public void setModelAndView(ModelAndView mav) {
        this.modelAndView = mav;
    }

    @Override
    public FlashMap getFlashMap() {
        return RequestContextUtils.getOutputFlashMap((HttpServletRequest)this.mockRequest);
    }

    public void setAsyncResult(Object asyncResult) {
        this.asyncResult = asyncResult;
    }

    @Override
    public Object getAsyncResult() {
        return this.getAsyncResult(-1L);
    }

    @Override
    public Object getAsyncResult(long timeout) {
        MockHttpServletRequest request = this.mockRequest;
        if (timeout != 0L && request.isAsyncStarted()) {
            if (timeout == -1L) {
                timeout = request.getAsyncContext().getTimeout();
            }
            if (!this.awaitAsyncResult(timeout)) {
                throw new IllegalStateException("Gave up waiting on async result from handler [" + this.handler + "] to complete");
            }
        }
        return this.asyncResult;
    }

    private boolean awaitAsyncResult(long timeout) {
        if (this.asyncResultLatch != null) {
            try {
                return this.asyncResultLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    public void setAsyncResultLatch(CountDownLatch asyncResultLatch) {
        this.asyncResultLatch = asyncResultLatch;
    }
}

