/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex.llvm;

import org.clang.lex.HeaderFileInfo;
import org.clang.lex.HeaderSearch;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.llvm.adt.aliases.SmallVector;

public final class HeaderFileInfoVector
implements NativeType.SizeofCapable,
Destructors.ClassWithDestructor {
    public static final HeaderFileInfoVector DEFAULT = new HeaderFileInfoVector(0, HeaderFileInfo.DEFAULT);
    private static final HeaderFileInfo[] EMPTY = new HeaderFileInfo[0];
    private static final SmallVector<HeaderFileInfoVector> POOL = new SmallVector(2 * Native.availableProcessors(), null);
    protected final HeaderFileInfo defaultValue;
    private HeaderFileInfo[] array;
    private int end;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HeaderFileInfoVector $create() {
        if (HeaderSearch.REUSE_HEADER_FILE_INFOS) {
            SmallVector<HeaderFileInfoVector> smallVector = POOL;
            synchronized (smallVector) {
                if (!POOL.empty()) {
                    return (HeaderFileInfoVector)POOL.pop_back_val();
                }
            }
        }
        return new HeaderFileInfoVector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void $release(HeaderFileInfoVector Vector) {
        Vector.clear();
        if (HeaderSearch.REUSE_HEADER_FILE_INFOS) {
            SmallVector<HeaderFileInfoVector> smallVector = POOL;
            synchronized (smallVector) {
                POOL.push_back((Object)Vector);
            }
        }
    }

    final HeaderFileInfo[] $array() {
        return this.array;
    }

    public HeaderFileInfoVector() {
        this(0, HeaderFileInfo.DEFAULT);
    }

    public HeaderFileInfoVector(int capacity, HeaderFileInfo defaultValue) {
        this.array = capacity == 0 ? EMPTY : new HeaderFileInfo[capacity];
        this.end = 0;
        assert (defaultValue != null);
        this.defaultValue = defaultValue;
        assert (defaultValue == HeaderFileInfo.DEFAULT);
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.end = 0;
    }

    public final boolean resize(int newSize) {
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = new HeaderFileInfo();
            }
        }
        this.end = newSize;
        return grown;
    }

    public final void reserve(int N) {
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final HeaderFileInfo $at(int idx) {
        assert (this.array[idx] != null);
        return this.array[idx];
    }

    public final HeaderFileInfo $set(int idx, HeaderFileInfo value) {
        assert (this.array[idx] != null);
        this.array[idx].$assign(value);
        return this.array[idx];
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
        this.destroy_range(0, this.size());
        this.end = 0;
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final int $sizeof() {
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        int oneElemSize = HeaderFileInfo.$sizeof_HeaderFileInfo();
        return this.array.length * oneElemSize;
    }

    public final void set_size(int N) {
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
        for (int i = from; i < to; ++i) {
            assert (this.array[i] != null);
            this.array[i].clear();
        }
    }

    private void grow(int newSize) {
        Object[] oldArray = this.array;
        this.array = new HeaderFileInfo[newSize];
        NativePointer.copy$Object((Object[])oldArray, (int)0, (Object[])this.array, (int)0, (int)oldArray.length);
    }

    private void setEnd(int to) {
        this.end = to;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorHeaderFileInfo{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            HeaderFileInfo element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorHeaderFileInfo}\n");
        return out.toString();
    }
}

