/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.context;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

public abstract class ResolutionContext<Context extends ResolutionContext<Context>> {
    @NotNull
    public final BindingTrace trace;
    @NotNull
    public final LexicalScope scope;
    @NotNull
    public final KotlinType expectedType;
    @NotNull
    public final DataFlowInfo dataFlowInfo;
    @NotNull
    public final ContextDependency contextDependency;
    @NotNull
    public final ResolutionResultsCache resolutionResultsCache;
    @NotNull
    public final StatementFilter statementFilter;
    public final boolean isAnnotationContext;
    public final boolean isDebuggerContext;
    public final boolean collectAllCandidates;
    @NotNull
    public final CallPosition callPosition;
    @NotNull
    public final Function1<KtExpression, KtExpression> expressionContextProvider;
    public static final Function1<KtExpression, KtExpression> DEFAULT_EXPRESSION_CONTEXT_PROVIDER = new Function1<KtExpression, KtExpression>(){

        @Override
        public KtExpression invoke(KtExpression expression) {
            return null;
        }
    };

    protected ResolutionContext(@NotNull BindingTrace trace, @NotNull LexicalScope scope, @NotNull KotlinType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ContextDependency contextDependency, @NotNull ResolutionResultsCache resolutionResultsCache, @NotNull StatementFilter statementFilter, boolean isAnnotationContext, boolean isDebuggerContext, boolean collectAllCandidates2, @NotNull CallPosition callPosition, @NotNull Function1<KtExpression, KtExpression> expressionContextProvider) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (resolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsCache", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (callPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callPosition", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        if (expressionContextProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionContextProvider", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "<init>"));
        }
        this.trace = trace;
        this.scope = scope;
        this.expectedType = expectedType;
        this.dataFlowInfo = dataFlowInfo;
        this.contextDependency = contextDependency;
        this.resolutionResultsCache = resolutionResultsCache;
        this.statementFilter = statementFilter;
        this.isAnnotationContext = isAnnotationContext;
        this.isDebuggerContext = isDebuggerContext;
        this.collectAllCandidates = collectAllCandidates2;
        this.callPosition = callPosition;
        this.expressionContextProvider = expressionContextProvider;
    }

    protected abstract Context create(@NotNull BindingTrace var1, @NotNull LexicalScope var2, @NotNull DataFlowInfo var3, @NotNull KotlinType var4, @NotNull ContextDependency var5, @NotNull ResolutionResultsCache var6, @NotNull StatementFilter var7, boolean var8, @NotNull CallPosition var9, @NotNull Function1<KtExpression, KtExpression> var10);

    @NotNull
    private Context self() {
        ResolutionContext resolutionContext = this;
        if (resolutionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "self"));
        }
        return (Context)resolutionContext;
    }

    @NotNull
    public Context replaceBindingTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceBindingTrace"));
        }
        if (this.trace == trace) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceBindingTrace"));
            }
            return Context2;
        }
        Context Context3 = this.create(trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceBindingTrace"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceDataFlowInfo(@NotNull DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDataFlowInfo", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceDataFlowInfo"));
        }
        if (newDataFlowInfo == this.dataFlowInfo) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceDataFlowInfo"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, this.scope, newDataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceDataFlowInfo"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceExpectedType(@Nullable KotlinType newExpectedType) {
        if (newExpectedType == null) {
            Context Context2 = this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceExpectedType"));
            }
            return Context2;
        }
        if (this.expectedType == newExpectedType) {
            Context Context3 = this.self();
            if (Context3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceExpectedType"));
            }
            return Context3;
        }
        Context Context4 = this.create(this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceExpectedType"));
        }
        return Context4;
    }

    @NotNull
    public Context replaceScope(@NotNull LexicalScope newScope) {
        if (newScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newScope", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceScope"));
        }
        if (newScope == this.scope) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceScope"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, newScope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceScope"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceContextDependency(@NotNull ContextDependency newContextDependency) {
        if (newContextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContextDependency", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceContextDependency"));
        }
        if (newContextDependency == this.contextDependency) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceContextDependency"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, newContextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceContextDependency"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceResolutionResultsCache(@NotNull ResolutionResultsCache newResolutionResultsCache) {
        if (newResolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newResolutionResultsCache", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceResolutionResultsCache"));
        }
        if (newResolutionResultsCache == this.resolutionResultsCache) {
            Context Context2 = this.self();
            if (Context2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceResolutionResultsCache"));
            }
            return Context2;
        }
        Context Context3 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, newResolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceResolutionResultsCache"));
        }
        return Context3;
    }

    @NotNull
    public Context replaceTraceAndCache(@NotNull TemporaryTraceAndCache traceAndCache) {
        if (traceAndCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceAndCache", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceTraceAndCache"));
        }
        Context Context2 = ((ResolutionContext)this.replaceBindingTrace(traceAndCache.trace)).replaceResolutionResultsCache(traceAndCache.cache);
        if (Context2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceTraceAndCache"));
        }
        return Context2;
    }

    @NotNull
    public Context replaceCollectAllCandidates(boolean newCollectAllCandidates) {
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, newCollectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceCollectAllCandidates"));
        }
        return Context2;
    }

    @NotNull
    public Context replaceStatementFilter(@NotNull StatementFilter statementFilter) {
        if (statementFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statementFilter", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceStatementFilter"));
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, statementFilter, this.collectAllCandidates, this.callPosition, this.expressionContextProvider);
        if (Context2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceStatementFilter"));
        }
        return Context2;
    }

    @NotNull
    public Context replaceCallPosition(@NotNull CallPosition callPosition) {
        if (callPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callPosition", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceCallPosition"));
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, callPosition, this.expressionContextProvider);
        if (Context2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceCallPosition"));
        }
        return Context2;
    }

    @NotNull
    public Context replaceExpressionContextProvider(@NotNull Function1<KtExpression, KtExpression> expressionContextProvider) {
        if (expressionContextProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionContextProvider", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceExpressionContextProvider"));
        }
        Context Context2 = this.create(this.trace, this.scope, this.dataFlowInfo, this.expectedType, this.contextDependency, this.resolutionResultsCache, this.statementFilter, this.collectAllCandidates, this.callPosition, expressionContextProvider);
        if (Context2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "replaceExpressionContextProvider"));
        }
        return Context2;
    }

    @Nullable
    public <T extends PsiElement> T getContextParentOfType(@NotNull KtExpression expression, Class<? extends T> ... classes2) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "getContextParentOfType"));
        }
        if (classes2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "org/jetbrains/kotlin/resolve/calls/context/ResolutionContext", "getContextParentOfType"));
        }
        PsiElement current = expression.getParent();
        while (current != null) {
            KtExpression context;
            for (Class<T> clazz : classes2) {
                if (!clazz.isInstance(current)) continue;
                return (T)current;
            }
            if (current instanceof PsiFile) {
                return null;
            }
            if (current instanceof KtExpression && (context = this.expressionContextProvider.invoke((KtExpression)current)) != null) {
                current = context;
                continue;
            }
            current = current.getParent();
        }
        return null;
    }
}

