/*
 * Decompiled with CFR 0.152.
 */
package dguitar.adaptors.song.impl;

import dguitar.adaptors.song.SongMeasure;
import dguitar.adaptors.song.SongPhrase;
import dguitar.adaptors.song.SongPhraseList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SongPhraseListImpl
implements SongPhraseList {
    private List phrases = new LinkedList();

    public void addPhrase(SongPhrase phrase) {
        this.phrases.add(phrase);
    }

    public int getScoreMeasureCount() {
        int count = 0;
        Iterator it = this.phrases.iterator();
        while (it.hasNext()) {
            SongPhrase phrase = (SongPhrase)it.next();
            count += phrase.getScoreMeasureCount();
        }
        return count;
    }

    public SongMeasure getScoreMeasure(int measure) {
        int startMeasure = 0;
        Iterator it = this.phrases.iterator();
        while (it.hasNext()) {
            SongPhrase phrase = (SongPhrase)it.next();
            int measureCount = phrase.getScoreMeasureCount();
            if (measure >= startMeasure && measure < startMeasure + measureCount) {
                return phrase.getScoreMeasure(measure - startMeasure);
            }
            startMeasure += measureCount;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public int getPerformanceMeasureCount() {
        int count = 0;
        Iterator it = this.phrases.iterator();
        while (it.hasNext()) {
            SongPhrase phrase = (SongPhrase)it.next();
            count += phrase.getPerformanceMeasureCount();
        }
        return count;
    }

    public SongMeasure getPerformanceMeasure(int measure) {
        int startMeasure = 0;
        Iterator it = this.phrases.iterator();
        while (it.hasNext()) {
            SongPhrase phrase = (SongPhrase)it.next();
            int measureCount = phrase.getPerformanceMeasureCount();
            if (measure >= startMeasure && measure < startMeasure + measureCount) {
                return phrase.getPerformanceMeasure(measure - startMeasure);
            }
            startMeasure += measureCount;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public SongPhrase getPhrase(int index) {
        return (SongPhrase)this.phrases.get(index);
    }

    public int getPhraseCount() {
        return this.phrases.size();
    }
}

