/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.arguments.MissingArgumentBehavior;
import org.jruby.truffle.language.arguments.ProfileArgumentNode;
import org.jruby.truffle.language.arguments.ReadPreArgumentNode;
import org.jruby.truffle.language.control.SequenceNode;
import org.jruby.truffle.parser.BodyTranslator;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.OptArgParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.RestArgParseNode;

public class ReloadArgumentsTranslator
extends Translator {
    private final BodyTranslator methodBodyTranslator;
    private int index = 0;
    private boolean hasRestParameter = false;

    public ReloadArgumentsTranslator(Node currentNode, RubyContext context, Source source, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.methodBodyTranslator = methodBodyTranslator;
    }

    @Override
    public RubyNode visitArgsNode(ArgsParseNode node) {
        int optArgsCount;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        ParseNode[] args = node.getArgs();
        int preCount = node.getPreCount();
        if (preCount > 0) {
            for (int i = 0; i < preCount; ++i) {
                sequence.add(args[i].accept(this));
                ++this.index;
            }
        }
        if ((optArgsCount = node.getOptionalArgsCount()) > 0) {
            int optArgsIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgsCount; ++i) {
                sequence.add(args[optArgsIndex + i].accept(this));
                ++this.index;
            }
        }
        if (node.hasRestArg()) {
            this.hasRestParameter = true;
            sequence.add(node.getRestArgNode().accept(this));
        }
        SourceSection sourceSectionX = sourceSection.toSourceSection(this.source);
        if (node.getPostCount() > 0) {
            System.err.printf("WARNING: post args in zsuper not yet implemented at %s:%d%n", sourceSectionX.getSource().getName(), sourceSectionX.getStartLine());
        }
        if (node.hasKwargs() && !this.source.getName().endsWith("/language/fixtures/super.rb")) {
            System.err.printf("WARNING: kwargs in zsuper not yet implemented at %s:%d%n", sourceSectionX.getSource().getName(), sourceSectionX.getStartLine());
        }
        return new SequenceNode(sourceSection.toSourceSection(this.source), sequence.toArray(new RubyNode[sequence.size()]));
    }

    @Override
    public RubyNode visitArgumentNode(ArgumentParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), this.source, sourceSection);
    }

    @Override
    public RubyNode visitOptArgNode(OptArgParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), this.source, sourceSection);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        return new ProfileArgumentNode(new ReadPreArgumentNode(this.index, MissingArgumentBehavior.NIL));
    }

    @Override
    public RubyNode visitRestArgNode(RestArgParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        return this.methodBodyTranslator.getEnvironment().findLocalVarNode(node.getName(), this.source, sourceSection);
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        return this.nilNode(this.source, sourceSection);
    }

    public boolean isSplatted() {
        return this.hasRestParameter;
    }
}

