/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.openjdk;

import java.lang.invoke.MethodHandle;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jruby.truffle.core.queue.ArrayBlockingQueueLocksConditions;
import org.jruby.truffle.core.queue.DelegatingBlockingQueue;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.platform.openjdk.MethodHandleUtils;

public class OpenJDKArrayBlockingQueueLocksConditions<T>
extends DelegatingBlockingQueue<T>
implements ArrayBlockingQueueLocksConditions<T> {
    private static final MethodHandle LOCK_FIELD_GETTER = MethodHandleUtils.getPrivateGetter(ArrayBlockingQueue.class, "lock");
    private static final MethodHandle NOT_EMPTY_CONDITION_FIELD_GETTER = MethodHandleUtils.getPrivateGetter(ArrayBlockingQueue.class, "notEmpty");
    private static final MethodHandle NOT_FULL_CONDITION_FIELD_GETTER = MethodHandleUtils.getPrivateGetter(ArrayBlockingQueue.class, "notFull");
    private final ReentrantLock lock;
    private final Condition notEmptyCondition;
    private final Condition notFullCondition;

    public OpenJDKArrayBlockingQueueLocksConditions(int capacity) {
        super(new ArrayBlockingQueue(capacity));
        ArrayBlockingQueue queue = (ArrayBlockingQueue)this.getQueue();
        try {
            this.lock = LOCK_FIELD_GETTER.invokeExact(queue);
            this.notEmptyCondition = NOT_EMPTY_CONDITION_FIELD_GETTER.invokeExact(queue);
            this.notFullCondition = NOT_FULL_CONDITION_FIELD_GETTER.invokeExact(queue);
        }
        catch (Throwable throwable) {
            throw new JavaException(throwable);
        }
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public Condition getNotEmptyCondition() {
        return this.notEmptyCondition;
    }

    @Override
    public Condition getNotFullCondition() {
        return this.notFullCondition;
    }
}

