/*
 * Decompiled with CFR 0.152.
 */
package dguitar.adaptors.guitarPro;

import dguitar.adaptors.guitarPro.DynamicsMap;
import dguitar.adaptors.guitarPro.TripletMap;
import dguitar.adaptors.guitarPro.TripletValue;
import dguitar.adaptors.song.RepeatedSongPhrase;
import dguitar.adaptors.song.Song;
import dguitar.adaptors.song.SongMeasure;
import dguitar.adaptors.song.SongPhrase;
import dguitar.adaptors.song.SongVirtualTrack;
import dguitar.adaptors.song.Tempo;
import dguitar.adaptors.song.TimeSignature;
import dguitar.adaptors.song.event.SongEventImpl;
import dguitar.adaptors.song.event.SongNoteOnMessage;
import dguitar.adaptors.song.event.SongTieMessage;
import dguitar.adaptors.song.impl.RepeatedSongPhraseImpl;
import dguitar.adaptors.song.impl.SongDeviceImpl;
import dguitar.adaptors.song.impl.SongImpl;
import dguitar.adaptors.song.impl.SongMeasureImpl;
import dguitar.adaptors.song.impl.SongMeasureTrackImpl;
import dguitar.adaptors.song.impl.SongPhraseListImpl;
import dguitar.adaptors.song.impl.SongTrackImpl;
import dguitar.codecs.guitarPro.GPBeat;
import dguitar.codecs.guitarPro.GPDuration;
import dguitar.codecs.guitarPro.GPDynamic;
import dguitar.codecs.guitarPro.GPFormatException;
import dguitar.codecs.guitarPro.GPMIDIChannel;
import dguitar.codecs.guitarPro.GPMeasure;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPNote;
import dguitar.codecs.guitarPro.GPSong;
import dguitar.codecs.guitarPro.GPTrack;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class GPAdaptor {
    private static String className;
    private static Logger logger;
    private static final int PPQ_HIGH_RESOLUTION = 2882880;
    private static final int PPQ_SCALE_FACTOR = 286;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("dguitar.adaptors.guitarPro.GPAdaptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        className = clazz.toString();
        logger = Logger.getLogger(className);
    }

    private static RepeatedSongPhrase makeRepeatedSongPhrase(Song song, ListIterator itM, ListIterator itMTP, List tracks) throws GPFormatException {
        String methodName = "makeRepeatedSongPhrase";
        SongPhraseListImpl spl = new SongPhraseListImpl();
        spl.addPhrase(GPAdaptor.makeSongMeasure(song, itM, itMTP, tracks));
        GPMeasure measure = (GPMeasure)itM.previous();
        itM.next();
        int repeatCount = measure.getNumberOfRepetitions();
        while (repeatCount == 0) {
            if (!itM.hasNext()) {
                logger.fine("Got to end of score before finding a closing repeat mark, assuming 1");
                repeatCount = 1;
                break;
            }
            SongPhrase phrase = GPAdaptor.phraseFactory(song, itM, itMTP, tracks);
            spl.addPhrase(phrase);
            measure = (GPMeasure)itM.previous();
            itM.next();
            repeatCount = measure.getNumberOfRepetitions();
            logger.fine("Repeat count measure at " + measure.getNumber() + " is " + repeatCount);
        }
        return new RepeatedSongPhraseImpl(spl, repeatCount);
    }

    private static SongMeasure makeSongMeasure(Song song, ListIterator itM, ListIterator itMTP, List tracks) {
        String methodName = "makeSongMeasure";
        GPMeasure measure = (GPMeasure)itM.next();
        int ending = measure.getNumberOfAlternateEnding();
        if (ending > 0) {
            logger.warning("Measure " + measure.getNumber() + " is alternate ending " + ending);
        }
        int numerator = measure.getNumerator();
        int denominator = measure.getDenominator();
        int measureLength = 11531520 * numerator / denominator;
        TimeSignature ts = new TimeSignature(numerator, denominator);
        SongMeasureImpl sm = new SongMeasureImpl(measure.getNumber(), measureLength / 286, ts);
        int trackIndex = 1;
        while (trackIndex <= tracks.size()) {
            int strings;
            GPTrack track = (GPTrack)tracks.get(trackIndex - 1);
            int capo = track.getCapo();
            int channel = track.getChannel();
            int virtualTracks = strings = track.getNumberOfStrings();
            int[] stringTuning = new int[strings];
            int i = 0;
            while (i < strings) {
                stringTuning[i] = track.getStringsTuning(i);
                ++i;
            }
            GPMeasureTrackPair mtp = (GPMeasureTrackPair)itMTP.next();
            SongMeasureTrackImpl smt = new SongMeasureTrackImpl(song.getTrack(trackIndex));
            sm.addTrack(smt);
            List beats = mtp.getBeats();
            int beatOffset = 0;
            Iterator itBeat = beats.iterator();
            while (itBeat.hasNext()) {
                GPBeat beat = (GPBeat)itBeat.next();
                GPDuration duration = beat.getDuration();
                boolean dotted = beat.dottedNotes;
                int ntuplet = beat.getNTuplet();
                int beatDuration = GPAdaptor.calculateDuration(duration, dotted, ntuplet);
                if (beat.isNoteBeat()) {
                    List notes = beat.getNotes();
                    LinkedList<Integer> stringsPlayed = new LinkedList<Integer>();
                    int i2 = 6;
                    while (i2 >= 0) {
                        if (beat.isStringPlayed(i2)) {
                            stringsPlayed.add(new Integer(i2));
                        }
                        --i2;
                    }
                    Iterator itNotes = notes.iterator();
                    Iterator itStrings = stringsPlayed.iterator();
                    while (itNotes.hasNext()) {
                        if (!itStrings.hasNext()) break;
                        Integer stringObject = (Integer)itStrings.next();
                        int stringID = 6 - stringObject;
                        GPNote note = (GPNote)itNotes.next();
                        int noteDuration = beatDuration;
                        GPDuration tiDuration = note.duration;
                        if (tiDuration != null) {
                            boolean tiDotted = note.isDotted;
                            int tiTriplet = note.getNTuplet();
                            noteDuration = GPAdaptor.calculateDuration(tiDuration, tiDotted, tiTriplet);
                        }
                        int virtualTrackID = stringID;
                        SongVirtualTrack svt = smt.getVirtualTrack(virtualTrackID);
                        int noteStart = beatOffset / 286;
                        int noteEnd = (beatOffset + noteDuration) / 286;
                        if (note.isTieNote()) {
                            svt.addEvent(new SongEventImpl(noteStart, new SongTieMessage(noteEnd - noteStart)));
                            continue;
                        }
                        int baseFret = note.getFretNumber();
                        int fret = baseFret + capo;
                        GPDynamic dynamic = note.getDynamic();
                        int velocity = DynamicsMap.velocityOf(dynamic);
                        int pitch = stringTuning[stringID] + fret;
                        svt.addEvent(new SongEventImpl(noteStart, new SongNoteOnMessage(pitch, velocity, noteEnd - noteStart, baseFret)));
                    }
                }
                beatOffset += beatDuration;
            }
            if (beatOffset != measureLength) {
                String reason = "Measure: " + measure.getNumber() + " track: " + trackIndex + " length mismatch, expected " + measureLength + ", got " + beatOffset;
                if (beatOffset > measureLength) {
                    logger.fine(reason);
                    System.err.println(reason);
                } else {
                    logger.fine(reason);
                }
            }
            ++trackIndex;
        }
        return sm;
    }

    private static int calculateDuration(GPDuration duration, boolean dotted, int ntuplet) {
        int durationIndex = duration.getIndex();
        int beatDuration = 11531520 >> durationIndex;
        if (dotted) {
            beatDuration += beatDuration >> 1;
        }
        if (ntuplet != 0) {
            TripletValue tv = TripletMap.getTriplet(ntuplet);
            beatDuration *= tv.getTimeOf();
            beatDuration /= tv.getNotes();
        }
        return beatDuration;
    }

    private static SongPhrase phraseFactory(Song song, ListIterator itM, ListIterator itMTP, List tracks) throws GPFormatException {
        SongPhrase sp = null;
        GPMeasure measure = (GPMeasure)itM.next();
        itM.previous();
        logger.finer("Measure " + measure.getNumber() + " repeat start " + measure.repeatStart);
        logger.finer("Measure " + measure.getNumber() + " repeat count " + measure.getNumberOfRepetitions());
        if (measure.repeatStart) {
            logger.fine("Creating a repeated phrase at " + measure.getNumber());
            sp = GPAdaptor.makeRepeatedSongPhrase(song, itM, itMTP, tracks);
        }
        if (sp == null) {
            logger.fine("Creating a measure phrase at " + measure.getNumber());
            sp = GPAdaptor.makeSongMeasure(song, itM, itMTP, tracks);
        }
        return sp;
    }

    public static Song makeSong(GPSong piece) throws GPFormatException {
        String methodName = "makeSong";
        logger.entering(className, methodName);
        int bpm = piece.getTempo();
        logger.finer("Tempo: " + bpm + "BPM");
        Tempo tempo = new Tempo();
        tempo.setBPM(bpm);
        SongImpl song = new SongImpl(10080, tempo);
        List measures = piece.getMeasures();
        logger.finer("Number of measures: " + measures.size());
        List tracks = piece.getTracks();
        logger.finer("Number of tracks: " + tracks.size());
        LinkedList fretStates = new LinkedList();
        int index = 1;
        Iterator it = tracks.iterator();
        while (it.hasNext()) {
            GPTrack track = (GPTrack)it.next();
            int port = track.getPort();
            int channel = track.getChannel();
            int channelEffects = track.getChannelEffects();
            logger.fine("Track " + index + " port " + port + " channels " + channel + "," + channelEffects);
            int channelIndex = (port - 1) * 16 + (channel - 1);
            GPMIDIChannel mc = piece.getChannels(channelIndex);
            int strings = track.getNumberOfStrings();
            SongTrackImpl st = new SongTrackImpl(index, strings);
            st.setPrimaryDevice(new SongDeviceImpl(port, channel));
            if (channel != channelEffects) {
                st.setSecondaryDevice(new SongDeviceImpl(port, channelEffects));
            }
            st.setBendSensitivity(2);
            int instrument = mc.getInstrument();
            logger.fine("Instrument " + instrument);
            st.setProgram(instrument);
            st.setVolume(8 * mc.getVolume());
            st.setPan(8 * mc.getBalance());
            st.setChorus(8 * mc.getChorus());
            st.setReverb(8 * mc.getReverb());
            st.setTremolo(8 * mc.getTremolo());
            st.setPhaser(8 * mc.getPhaser());
            song.addTrack(st);
            ++index;
        }
        List measureTrackPairs = piece.getMeasuresTracksPairs();
        logger.finer("Measure/Track pairs: " + measureTrackPairs.size());
        ListIterator itMTP = measureTrackPairs.listIterator();
        ListIterator itM = measures.listIterator();
        while (itM.hasNext()) {
            SongPhrase sp = GPAdaptor.phraseFactory(song, itM, itMTP, tracks);
            song.addPhrase(sp);
        }
        logger.exiting(className, methodName, song);
        return song;
    }
}

