/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.types.ILiteralNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;
import org.jruby.util.KeyValuePair;

public class HashParseNode
extends ParseNode
implements ILiteralNode {
    private final List<KeyValuePair<ParseNode, ParseNode>> pairs = new ArrayList<KeyValuePair<ParseNode, ParseNode>>();

    public HashParseNode(ISourcePosition position) {
        super(position, false);
    }

    public HashParseNode(ISourcePosition position, KeyValuePair<ParseNode, ParseNode> pair) {
        this(position);
        this.pairs.add(pair);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.HASHNODE;
    }

    public HashParseNode add(KeyValuePair<ParseNode, ParseNode> pair) {
        if (pair.getKey() != null && ((ParseNode)pair.getKey()).containsVariableAssignment() || pair.getValue() != null && ((ParseNode)pair.getValue()).containsVariableAssignment()) {
            this.containsVariableAssignment = true;
        }
        this.pairs.add(pair);
        return this;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitHashNode(this);
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public List<KeyValuePair<ParseNode, ParseNode>> getPairs() {
        return this.pairs;
    }

    @Override
    public List<ParseNode> childNodes() {
        ArrayList<ParseNode> children = new ArrayList<ParseNode>();
        for (KeyValuePair<ParseNode, ParseNode> pair : this.pairs) {
            children.add((ParseNode)pair.getKey());
            children.add((ParseNode)pair.getValue());
        }
        return children;
    }
}

