/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContent;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;

public class BulkItemResponse
implements Streamable,
StatusToXContent {
    private int id;
    private String opType;
    private DocWriteResponse response;
    private Failure failure;

    @Override
    public RestStatus status() {
        return this.failure == null ? this.response.status() : this.failure.getStatus();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.opType);
        if (this.failure == null) {
            this.response.toXContent(builder, params);
            builder.field("status", this.response.status().getStatus());
        } else {
            builder.field("_index", this.failure.getIndex());
            builder.field("_type", this.failure.getType());
            builder.field("_id", this.failure.getId());
            builder.field("status", this.failure.getStatus().getStatus());
            builder.startObject("error");
            ElasticsearchException.toXContent(builder, params, this.failure.getCause());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    BulkItemResponse() {
    }

    public BulkItemResponse(int id, String opType, DocWriteResponse response) {
        this.id = id;
        this.opType = opType;
        this.response = response;
    }

    public BulkItemResponse(int id, String opType, Failure failure) {
        this.id = id;
        this.opType = opType;
        this.failure = failure;
    }

    public int getItemId() {
        return this.id;
    }

    public String getOpType() {
        return this.opType;
    }

    public String getIndex() {
        if (this.failure != null) {
            return this.failure.getIndex();
        }
        return this.response.getIndex();
    }

    public String getType() {
        if (this.failure != null) {
            return this.failure.getType();
        }
        return this.response.getType();
    }

    public String getId() {
        if (this.failure != null) {
            return this.failure.getId();
        }
        return this.response.getId();
    }

    public long getVersion() {
        if (this.failure != null) {
            return -1L;
        }
        return this.response.getVersion();
    }

    public <T extends DocWriteResponse> T getResponse() {
        return (T)this.response;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public String getFailureMessage() {
        if (this.failure != null) {
            return this.failure.getMessage();
        }
        return null;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public static BulkItemResponse readBulkItem(StreamInput in) throws IOException {
        BulkItemResponse response = new BulkItemResponse();
        response.readFrom(in);
        return response;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.opType = in.readString();
        byte type = in.readByte();
        if (type == 0) {
            this.response = new IndexResponse();
            this.response.readFrom(in);
        } else if (type == 1) {
            this.response = new DeleteResponse();
            this.response.readFrom(in);
        } else if (type == 3) {
            this.response = new UpdateResponse();
            this.response.readFrom(in);
        }
        if (in.readBoolean()) {
            this.failure = new Failure(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeString(this.opType);
        if (this.response == null) {
            out.writeByte((byte)2);
        } else {
            if (this.response instanceof IndexResponse) {
                out.writeByte((byte)0);
            } else if (this.response instanceof DeleteResponse) {
                out.writeByte((byte)1);
            } else if (this.response instanceof UpdateResponse) {
                out.writeByte((byte)3);
            }
            this.response.writeTo(out);
        }
        if (this.failure == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.failure.writeTo(out);
        }
    }

    public static class Failure
    implements Writeable,
    ToXContent {
        static final String INDEX_FIELD = "index";
        static final String TYPE_FIELD = "type";
        static final String ID_FIELD = "id";
        static final String CAUSE_FIELD = "cause";
        static final String STATUS_FIELD = "status";
        private final String index;
        private final String type;
        private final String id;
        private final Throwable cause;
        private final RestStatus status;

        public Failure(String index, String type, String id, Throwable cause) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.cause = cause;
            this.status = ExceptionsHelper.status(cause);
        }

        public Failure(StreamInput in) throws IOException {
            this.index = in.readString();
            this.type = in.readString();
            this.id = in.readOptionalString();
            this.cause = in.readException();
            this.status = ExceptionsHelper.status(this.cause);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.getIndex());
            out.writeString(this.getType());
            out.writeOptionalString(this.getId());
            out.writeException(this.getCause());
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.cause.toString();
        }

        public RestStatus getStatus() {
            return this.status;
        }

        public Throwable getCause() {
            return this.cause;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(INDEX_FIELD, this.index);
            builder.field(TYPE_FIELD, this.type);
            if (this.id != null) {
                builder.field(ID_FIELD, this.id);
            }
            builder.startObject(CAUSE_FIELD);
            ElasticsearchException.toXContent(builder, params, this.cause);
            builder.endObject();
            builder.field(STATUS_FIELD, this.status.getStatus());
            return builder;
        }

        public String toString() {
            return Strings.toString(this, true);
        }
    }

    static final class Fields {
        static final String _INDEX = "_index";
        static final String _TYPE = "_type";
        static final String _ID = "_id";
        static final String STATUS = "status";
        static final String ERROR = "error";

        Fields() {
        }
    }
}

