/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMStyleDeclaration
implements CSSStyleDeclaration {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected CSSRule parentRule;
    protected Map values;

    public CSSOMStyleDeclaration(ValueProvider vp, CSSRule parent) {
        this.valueProvider = vp;
        this.parentRule = parent;
    }

    public void setModificationHandler(ModificationHandler h) {
        this.handler = h;
    }

    public String getCssText() {
        return this.valueProvider.getText();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.values = null;
        this.handler.textChanged(cssText);
    }

    public String getPropertyValue(String propertyName) {
        Value value = this.valueProvider.getValue(propertyName);
        if (value == null) {
            return "";
        }
        return value.getCssText();
    }

    public CSSValue getPropertyCSSValue(String propertyName) {
        Value value = this.valueProvider.getValue(propertyName);
        if (value == null) {
            return null;
        }
        return this.getCSSValue(propertyName);
    }

    public String removeProperty(String propertyName) throws DOMException {
        String result = this.getPropertyValue(propertyName);
        if (result.length() > 0) {
            if (this.handler == null) {
                throw new DOMException(7, "");
            }
            if (this.values != null) {
                this.values.remove(propertyName);
            }
            this.handler.propertyRemoved(propertyName);
        }
        return result;
    }

    public String getPropertyPriority(String propertyName) {
        return this.valueProvider.isImportant(propertyName) ? "important" : "";
    }

    public void setProperty(String propertyName, String value, String prio) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.propertyChanged(propertyName, value, prio);
    }

    public int getLength() {
        return this.valueProvider.getLength();
    }

    public String item(int index) {
        return this.valueProvider.item(index);
    }

    public CSSRule getParentRule() {
        return this.parentRule;
    }

    protected CSSValue getCSSValue(String name) {
        CSSValue result = null;
        if (this.values != null) {
            result = (CSSValue)this.values.get(name);
        }
        if (result == null) {
            result = this.createCSSValue(name);
            if (this.values == null) {
                this.values = new HashMap(11);
            }
            this.values.put(name, result);
        }
        return result;
    }

    protected CSSValue createCSSValue(String name) {
        return new StyleDeclarationValue(name);
    }

    public class StyleDeclarationValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        protected String property;

        public StyleDeclarationValue(String prop) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMValue.AbstractModificationHandler(this){
                private final /* synthetic */ StyleDeclarationValue this$1;
                {
                    this.this$1 = this$1;
                }

                protected Value getValue() {
                    return this.this$1.getValue();
                }

                public void textChanged(String text) throws DOMException {
                    if (StyleDeclarationValue.access$000((StyleDeclarationValue)this.this$1).values == null || StyleDeclarationValue.access$000((StyleDeclarationValue)this.this$1).values.get(this) == null || this.this$1.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String prio = StyleDeclarationValue.access$000(this.this$1).getPropertyPriority(this.this$1.property);
                    StyleDeclarationValue.access$000((StyleDeclarationValue)this.this$1).handler.propertyChanged(this.this$1.property, text, prio);
                }
            });
            this.property = prop;
        }

        public Value getValue() {
            return CSSOMStyleDeclaration.this.valueProvider.getValue(this.property);
        }

        static /* synthetic */ CSSOMStyleDeclaration access$000(StyleDeclarationValue x0) {
            return x0.CSSOMStyleDeclaration.this;
        }
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void propertyRemoved(String var1) throws DOMException;

        public void propertyChanged(String var1, String var2, String var3) throws DOMException;
    }

    public static interface ValueProvider {
        public Value getValue(String var1);

        public boolean isImportant(String var1);

        public String getText();

        public int getLength();

        public String item(int var1);
    }
}

