/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class PNGReader
implements ImageReader {
    private static final int PNG_SIG_LENGTH = 24;

    public FopImage.ImageInfo verifySignature(String uri, InputStream bis, FOUserAgent ua) throws IOException {
        boolean supported;
        byte[] header = this.getDefaultHeader(bis);
        boolean bl = supported = header[0] == -119 && header[1] == 80 && header[2] == 78 && header[3] == 71 && header[4] == 13 && header[5] == 10 && header[6] == 26 && header[7] == 10;
        if (supported) {
            FopImage.ImageInfo info = new FopImage.ImageInfo();
            info.dpiVertical = info.dpiHorizontal = (double)ua.getFactory().getSourceResolution();
            this.getDimension(header, info);
            info.originalURI = uri;
            info.mimeType = this.getMimeType();
            info.inputStream = bis;
            return info;
        }
        return null;
    }

    public String getMimeType() {
        return "image/png";
    }

    private void getDimension(byte[] header, FopImage.ImageInfo info) {
        int byte1 = header[16] & 0xFF;
        int byte2 = header[17] & 0xFF;
        int byte3 = header[18] & 0xFF;
        int byte4 = header[19] & 0xFF;
        long l = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
        info.width = (int)l;
        byte1 = header[20] & 0xFF;
        byte2 = header[21] & 0xFF;
        byte3 = header[22] & 0xFF;
        byte4 = header[23] & 0xFF;
        l = byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4;
        info.height = (int)l;
    }

    private byte[] getDefaultHeader(InputStream imageStream) throws IOException {
        byte[] header = new byte[24];
        try {
            imageStream.mark(25);
            imageStream.read(header);
            imageStream.reset();
        }
        catch (IOException ex) {
            try {
                imageStream.reset();
            }
            catch (IOException exbis) {
                // empty catch block
            }
            throw ex;
        }
        return header;
    }
}

