/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij;

import java.lang.ref.Reference;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.CommonBundle;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.reference.SoftReference;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.FactoryMap;

public abstract class AbstractBundle {
    private static final Logger LOG = Logger.getInstance("#com.intellij.AbstractBundle");
    private Reference<ResourceBundle> myBundle;
    @NonNls
    private final String myPathToBundle;
    private static final FactoryMap<ClassLoader, Map<String, ResourceBundle>> ourCache = new ConcurrentWeakFactoryMap<ClassLoader, Map<String, ResourceBundle>>(){

        @Override
        protected Map<String, ResourceBundle> create(ClassLoader key) {
            return ContainerUtil.createConcurrentSoftValueMap();
        }
    };

    protected AbstractBundle(@NonNls @NotNull String pathToBundle) {
        if (pathToBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToBundle", "org/jetbrains/kotlin/com/intellij/AbstractBundle", "<init>"));
        }
        this.myPathToBundle = pathToBundle;
    }

    public String getMessage(@NotNull String key, Object ... params) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/com/intellij/AbstractBundle", "getMessage"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/com/intellij/AbstractBundle", "getMessage"));
        }
        return CommonBundle.message(this.getBundle(), key, params);
    }

    private ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(this.myBundle);
        if (bundle == null) {
            bundle = AbstractBundle.getResourceBundle(this.myPathToBundle, this.getClass().getClassLoader());
            this.myBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static ResourceBundle getResourceBundle(@NotNull String pathToBundle, @NotNull ClassLoader loader) {
        if (pathToBundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToBundle", "org/jetbrains/kotlin/com/intellij/AbstractBundle", "getResourceBundle"));
        }
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "org/jetbrains/kotlin/com/intellij/AbstractBundle", "getResourceBundle"));
        }
        Map<String, ResourceBundle> map2 = ourCache.get(loader);
        ResourceBundle result2 = map2.get(pathToBundle);
        if (result2 == null) {
            try {
                ResourceBundle.Control control = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES);
                result2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader, control);
            }
            catch (MissingResourceException e) {
                LOG.info("Cannot load resource bundle from *.properties file, falling back to slow class loading: " + pathToBundle);
                ResourceBundle.clearCache(loader);
                result2 = ResourceBundle.getBundle(pathToBundle, Locale.getDefault(), loader);
            }
            map2.put(pathToBundle, result2);
        }
        return result2;
    }
}

