/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lexer;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lexer.FlexLexer;
import org.jetbrains.kotlin.com.intellij.lexer.LexerBase;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class FlexAdapter
extends LexerBase {
    private FlexLexer myFlex = null;
    private IElementType myTokenType = null;
    private CharSequence myText;
    private int myEnd;
    private int myState;

    public FlexAdapter(FlexLexer flex) {
        this.myFlex = flex;
    }

    public FlexLexer getFlex() {
        return this.myFlex;
    }

    @Override
    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/kotlin/com/intellij/lexer/FlexAdapter", "start"));
        }
        this.myText = buffer;
        this.myEnd = endOffset;
        this.myFlex.reset(this.myText, startOffset, endOffset, initialState);
        this.myTokenType = null;
    }

    @Override
    public int getState() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myState;
    }

    @Override
    public IElementType getTokenType() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenType;
    }

    @Override
    public int getTokenStart() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myFlex.getTokenStart();
    }

    @Override
    public int getTokenEnd() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myFlex.getTokenEnd();
    }

    @Override
    public void advance() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        this.myTokenType = null;
    }

    @Override
    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lexer/FlexAdapter", "getBufferSequence"));
        }
        return charSequence;
    }

    @Override
    public int getBufferEnd() {
        return this.myEnd;
    }

    protected void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        try {
            this.myState = this.myFlex.yystate();
            this.myTokenType = this.myFlex.advance();
        }
        catch (IOException iOException) {
        }
        catch (Error e) {
            Error error = new Error(this.myFlex.getClass().getName() + ": " + e.getMessage());
            error.setStackTrace(e.getStackTrace());
            throw error;
        }
    }
}

