/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.ApiGroovyCompiler;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.NormalizingGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonFactory;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.api.internal.tasks.compile.daemon.DaemonGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.InProcessCompilerDaemonFactory;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;

public class GroovyCompilerFactory
implements CompilerFactory<GroovyJavaJointCompileSpec> {
    private final ProjectInternal project;
    private final JavaCompilerFactory javaCompilerFactory;
    private final CompilerDaemonManager compilerDaemonFactory;
    private final InProcessCompilerDaemonFactory inProcessCompilerDaemonFactory;

    public GroovyCompilerFactory(ProjectInternal project, JavaCompilerFactory javaCompilerFactory, CompilerDaemonManager compilerDaemonManager, InProcessCompilerDaemonFactory inProcessCompilerDaemonFactory) {
        this.project = project;
        this.javaCompilerFactory = javaCompilerFactory;
        this.compilerDaemonFactory = compilerDaemonManager;
        this.inProcessCompilerDaemonFactory = inProcessCompilerDaemonFactory;
    }

    public Compiler<GroovyJavaJointCompileSpec> newCompiler(GroovyJavaJointCompileSpec spec) {
        GroovyCompileOptions groovyOptions = spec.getGroovyCompileOptions();
        Compiler javaCompiler = this.javaCompilerFactory.createForJointCompilation(spec.getClass());
        Object groovyCompiler = new ApiGroovyCompiler((Compiler<JavaCompileSpec>)javaCompiler);
        Object daemonFactory = groovyOptions.isFork() ? this.compilerDaemonFactory : this.inProcessCompilerDaemonFactory;
        groovyCompiler = new DaemonGroovyCompiler(this.project.getRootProject().getProjectDir(), (Compiler<GroovyJavaJointCompileSpec>)groovyCompiler, (ClassPathRegistry)this.project.getServices().get(ClassPathRegistry.class), (CompilerDaemonFactory)daemonFactory);
        return new NormalizingGroovyCompiler((Compiler<GroovyJavaJointCompileSpec>)groovyCompiler);
    }
}

