/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.gui.download.DownloadObjectDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadPrimitiveAction
extends JosmAction {
    public static final Shortcut SHORTCUT = Shortcut.registerShortcut("system:download_primitive", I18n.tr("File: {0}", I18n.tr("Download object...", new Object[0])), 79, 5009);

    public DownloadPrimitiveAction() {
        super(I18n.tr("Download object...", new Object[0]), "downloadprimitive", I18n.tr("Download OSM object by ID.", new Object[0]), SHORTCUT, true);
        this.putValue("help", HelpUtil.ht("/Action/DownloadObject"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        DownloadObjectDialog downloadObjectDialog = new DownloadObjectDialog();
        if (downloadObjectDialog.showDialog().getValue() != downloadObjectDialog.getContinueButtonIndex()) {
            return;
        }
        DownloadPrimitiveAction.processItems(downloadObjectDialog.isNewLayerRequested(), downloadObjectDialog.getOsmIds(), downloadObjectDialog.isReferrersRequested(), downloadObjectDialog.isFullRelationRequested());
    }

    public static void processItems(boolean bl, List<PrimitiveId> list, boolean bl2, boolean bl3) {
        DownloadPrimitivesWithReferrersTask downloadPrimitivesWithReferrersTask = new DownloadPrimitivesWithReferrersTask(bl, list, bl2, bl3, null, null);
        Main.worker.submit(downloadPrimitivesWithReferrersTask);
        Main.worker.submit(() -> {
            List<PrimitiveId> list = downloadPrimitivesWithReferrersTask.getDownloadedId();
            if (list != null) {
                GuiHelper.runInEDT(() -> Main.getLayerManager().getEditDataSet().setSelected(list));
            }
        });
    }
}

