/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

public final class DebugStackFrame
implements Iterable<DebugValue> {
    final SuspendedEvent event;
    private final FrameInstance currentFrame;

    DebugStackFrame(SuspendedEvent session, FrameInstance instance) {
        this.event = session;
        this.currentFrame = instance;
    }

    public boolean isInternal() {
        this.verifyValidState();
        return this.findCurrentRoot().getSourceSection().getSource().isInternal();
    }

    public String getName() {
        this.verifyValidState();
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        try {
            return root.getName();
        }
        catch (Throwable e) {
            try {
                assert (false);
            }
            catch (AssertionError e1) {
                throw e;
            }
            return null;
        }
    }

    public SourceSection getSourceSection() {
        this.verifyValidState();
        EventContext context = this.getContext();
        if (this.currentFrame == null) {
            return context.getInstrumentedSourceSection();
        }
        Node callNode = this.currentFrame.getCallNode();
        if (callNode != null) {
            return callNode.getEncapsulatingSourceSection();
        }
        return null;
    }

    public DebugValue getValue(String name) {
        this.verifyValidState();
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return null;
        }
        FrameSlot slot = root.getFrameDescriptor().findFrameSlot(name);
        if (slot == null) {
            return null;
        }
        MaterializedFrame frame = this.findTruffleFrame();
        if (frame.getValue(slot) == null) {
            return null;
        }
        return new DebugValue.StackValue(this, slot);
    }

    DebugValue wrapHeapValue(Object result) {
        return new DebugValue.HeapValue(this.event.getSession().getDebugger(), this.findCurrentRoot(), result);
    }

    public DebugValue eval(String code) {
        Object result;
        this.verifyValidState();
        try {
            result = DebuggerSession.evalInContext(this.event, code, this.currentFrame);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.wrapHeapValue(result);
    }

    @Override
    public Iterator<DebugValue> iterator() {
        this.verifyValidState();
        RootNode root = this.findCurrentRoot();
        if (root == null) {
            return Collections.emptyList().iterator();
        }
        final FrameDescriptor descriptor = root.getFrameDescriptor();
        return new Iterator<DebugValue>(){
            private final Iterator<? extends FrameSlot> slots;
            private DebugValue.StackValue nextValue;
            {
                this.slots = descriptor.getSlots().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.nextValue == null) {
                    this.nextValue = this.getNext();
                }
                return this.nextValue != null;
            }

            private DebugValue.StackValue getNext() {
                while (this.slots.hasNext()) {
                    FrameSlot slot = this.slots.next();
                    DebugValue.StackValue value = new DebugValue.StackValue(DebugStackFrame.this, slot);
                    if (value.get() == null) continue;
                    return value;
                }
                return null;
            }

            @Override
            public DebugValue.StackValue next() {
                DebugValue.StackValue next = this.nextValue;
                if (next == null) {
                    return this.getNext();
                }
                this.nextValue = null;
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    MaterializedFrame findTruffleFrame() {
        if (this.currentFrame == null) {
            return this.event.getMaterializedFrame();
        }
        return this.currentFrame.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize();
    }

    private EventContext getContext() {
        return this.event.getContext();
    }

    Class<? extends TruffleLanguage> findCurrentLanguage() {
        RootNode root = this.findCurrentRoot();
        if (root != null) {
            return Debugger.ACCESSOR.findLanguage(root);
        }
        return null;
    }

    RootNode findCurrentRoot() {
        EventContext context = this.getContext();
        if (this.currentFrame == null) {
            return context.getInstrumentedNode().getRootNode();
        }
        CallTarget target = this.currentFrame.getCallTarget();
        if (target instanceof RootCallTarget) {
            return ((RootCallTarget)target).getRootNode();
        }
        return null;
    }

    void verifyValidState() {
        this.event.verifyValidState();
    }
}

