/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.JavaObjectMessageResolution;
import com.oracle.truffle.api.interop.java.WriteFieldNodeSubNodeGen;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

abstract class WriteFieldNodeSub
extends JavaObjectMessageResolution.WriteFieldNode {
    WriteFieldNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, JavaObject receiver, String name, Object value) {
        return this.access(frame, receiver, name, value);
    }

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, JavaObject receiver, Number index, Object value) {
        return this.access(frame, receiver, index, value);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new WriteRootNode(language);
    }

    private static final class WriteRootNode
    extends RootNode {
        @Node.Child
        private WriteFieldNodeSub node = WriteFieldNodeSubNodeGen.create();

        protected WriteRootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            TruffleObject receiver = ForeignAccess.getReceiver(frame);
            Object identifier = ForeignAccess.getArguments(frame).get(0);
            Object value = ForeignAccess.getArguments(frame).get(1);
            try {
                return this.node.executeWithTarget(frame, receiver, identifier, value);
            }
            catch (UnsupportedSpecializationException e) {
                throw UnsupportedTypeException.raise(e.getSuppliedValues());
            }
        }
    }
}

