/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import java.io.IOException;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.parser.ParserContext;
import org.jruby.util.Memo;

@CoreClass(value="Truffle::Boot")
public abstract class TruffleBootNodes {

    @CoreMethod(names={"source_of_caller"}, isModuleFunction=true)
    public static abstract class SourceOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject sourceOfCaller() {
            Memo frameCount = new Memo((Object)0);
            String source = Truffle.getRuntime().iterateFrames(frameInstance -> {
                if ((Integer)frameCount.get() == 2) {
                    return frameInstance.getCallNode().getEncapsulatingSourceSection().getSource().getName();
                }
                frameCount.set((Object)((Integer)frameCount.get() + 1));
                return null;
            });
            if (source == null) {
                return this.nil();
            }
            return this.createString(StringOperations.encodeRope(source, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"original_load_path"}, onSingleton=true)
    public static abstract class OriginalLoadPathNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject originalLoadPath() {
            String[] path = this.getContext().getJRubyInterop().getOriginalLoadPath();
            Object[] array = new Object[path.length];
            for (int n = 0; n < array.length; ++n) {
                array[n] = StringOperations.createString(this.getContext(), StringOperations.encodeRope(path[n], (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.createArray(array, array.length);
        }
    }

    @CoreMethod(names={"original_argv"}, onSingleton=true)
    public static abstract class OriginalArgvNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject originalArgv() {
            String[] argv = this.getContext().getJRubyInterop().getArgv();
            Object[] array = new Object[argv.length];
            for (int n = 0; n < array.length; ++n) {
                array[n] = StringOperations.createString(this.getContext(), StringOperations.encodeRope(argv[n], (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.createArray(array, array.length);
        }
    }

    @CoreMethod(names={"run_jruby_root"}, onSingleton=true)
    public static abstract class RunJRubyRootNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public Object runJRubyRootNode(VirtualFrame frame, @Cached(value="create()") IndirectCallNode callNode) {
            Source source;
            String dollar0 = this.getContext().getJRubyInterop().getArg0();
            this.coreLibrary().getGlobalVariables().put("$0", StringOperations.createString(this.getContext(), StringOperations.encodeRope(dollar0, (Encoding)UTF8Encoding.INSTANCE)));
            String inputFile = this.getContext().getJRubyInterop().getOriginalInputFile();
            try {
                source = this.getContext().getSourceCache().getSource(inputFile);
            }
            catch (IOException e) {
                throw new JavaException(e);
            }
            RubyRootNode rootNode = this.getContext().getCodeLoader().parse(source, (Encoding)UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL_FIRST, null, true, null);
            CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, rootNode, null, this.coreLibrary().getMainObject());
            return deferredCall.call(frame, callNode);
        }
    }

    @CoreMethod(names={"context"}, onSingleton=true)
    public static abstract class ContextNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public RubyContext context() {
            return this.getContext();
        }
    }

    @CoreMethod(names={"jruby_home_directory_protocol"}, onSingleton=true)
    public static abstract class JRubyHomeDirectoryProtocolNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject jrubyHomeDirectoryProtocol() {
            String home = this.getContext().getJRubyInterop().getJRubyHome();
            if (home.startsWith("uri:classloader:")) {
                home = home.substring("uri:classloader:".length());
                while (home.startsWith("/")) {
                    home = home.substring(1);
                }
                home = "jruby:/" + home;
            }
            return this.createString(StringOperations.encodeRope(home, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"jruby_home_directory"}, onSingleton=true)
    public static abstract class JRubyHomeDirectoryNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject jrubyHomeDirectory() {
            return this.createString(StringOperations.encodeRope(this.getContext().getJRubyInterop().getJRubyHome(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }
}

