/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.IsANode;
import org.jruby.truffle.language.objects.IsANodeGen;

public abstract class RescueNode
extends RubyNode {
    @Node.Child
    private RubyNode body;
    @Node.Child
    private IsANode isANode;

    public RescueNode(RubyContext context, SourceSection sourceSection, RubyNode body) {
        super(context, sourceSection);
        this.body = body;
    }

    public abstract boolean canHandle(VirtualFrame var1, DynamicObject var2);

    @Override
    public Object execute(VirtualFrame frame) {
        return this.body.execute(frame);
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.body.executeVoid(frame);
    }

    protected IsANode getIsANode() {
        if (this.isANode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isANode = this.insert(IsANodeGen.create(this.getContext(), null, null, null));
        }
        return this.isANode;
    }
}

