/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Syntax;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.PrimitiveNodeConstructor;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.IsNilNode;
import org.jruby.truffle.core.IsRubiniusUndefinedNode;
import org.jruby.truffle.core.RaiseIfFrozenNode;
import org.jruby.truffle.core.array.ArrayAppendOneNode;
import org.jruby.truffle.core.array.ArrayAppendOneNodeGen;
import org.jruby.truffle.core.array.ArrayConcatNode;
import org.jruby.truffle.core.array.ArrayDropTailNode;
import org.jruby.truffle.core.array.ArrayDropTailNodeGen;
import org.jruby.truffle.core.array.ArrayGetTailNodeGen;
import org.jruby.truffle.core.array.ArrayLiteralNode;
import org.jruby.truffle.core.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.core.cast.HashCastNodeGen;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.core.cast.SplatCastNode;
import org.jruby.truffle.core.cast.SplatCastNodeGen;
import org.jruby.truffle.core.cast.StringToSymbolNode;
import org.jruby.truffle.core.cast.StringToSymbolNodeGen;
import org.jruby.truffle.core.cast.ToProcNodeGen;
import org.jruby.truffle.core.cast.ToSNode;
import org.jruby.truffle.core.cast.ToSNodeGen;
import org.jruby.truffle.core.hash.ConcatHashLiteralNode;
import org.jruby.truffle.core.hash.HashLiteralNode;
import org.jruby.truffle.core.hash.HashNodes;
import org.jruby.truffle.core.hash.HashNodesFactory;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.module.ModuleNodes;
import org.jruby.truffle.core.module.ModuleNodesFactory;
import org.jruby.truffle.core.numeric.BignumOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.core.range.RangeNodes;
import org.jruby.truffle.core.range.RangeNodesFactory;
import org.jruby.truffle.core.regexp.InterpolatedRegexpNode;
import org.jruby.truffle.core.regexp.MatchDataNodes;
import org.jruby.truffle.core.regexp.MatchDataNodesFactory;
import org.jruby.truffle.core.regexp.RegexpNodes;
import org.jruby.truffle.core.regexp.RegexpNodesFactory;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rubinius.RubiniusLastStringReadNode;
import org.jruby.truffle.core.rubinius.RubiniusLastStringWriteNodeGen;
import org.jruby.truffle.core.string.InterpolatedStringNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.RubySourceSection;
import org.jruby.truffle.language.arguments.ArrayIsAtLeastAsLargeAsNode;
import org.jruby.truffle.language.arguments.SingleBlockArgNode;
import org.jruby.truffle.language.constants.ReadConstantNode;
import org.jruby.truffle.language.constants.ReadConstantWithLexicalScopeNode;
import org.jruby.truffle.language.constants.WriteConstantNode;
import org.jruby.truffle.language.control.AndNode;
import org.jruby.truffle.language.control.BreakID;
import org.jruby.truffle.language.control.BreakNode;
import org.jruby.truffle.language.control.ElidableResultNode;
import org.jruby.truffle.language.control.FrameOnStackNode;
import org.jruby.truffle.language.control.IfElseNode;
import org.jruby.truffle.language.control.IfNode;
import org.jruby.truffle.language.control.NextNode;
import org.jruby.truffle.language.control.NotNode;
import org.jruby.truffle.language.control.OnceNode;
import org.jruby.truffle.language.control.OrNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.RedoNode;
import org.jruby.truffle.language.control.RetryNode;
import org.jruby.truffle.language.control.ReturnID;
import org.jruby.truffle.language.control.ReturnNode;
import org.jruby.truffle.language.control.UnlessNode;
import org.jruby.truffle.language.control.WhileNode;
import org.jruby.truffle.language.defined.DefinedNode;
import org.jruby.truffle.language.defined.DefinedWrapperNode;
import org.jruby.truffle.language.dispatch.RubyCallNode;
import org.jruby.truffle.language.dispatch.RubyCallNodeParameters;
import org.jruby.truffle.language.exceptions.DisablingBacktracesNode;
import org.jruby.truffle.language.exceptions.EnsureNode;
import org.jruby.truffle.language.exceptions.RescueAnyNode;
import org.jruby.truffle.language.exceptions.RescueClassesNode;
import org.jruby.truffle.language.exceptions.RescueNode;
import org.jruby.truffle.language.exceptions.RescueSplatNode;
import org.jruby.truffle.language.exceptions.TryNode;
import org.jruby.truffle.language.globals.CheckMatchVariableTypeNode;
import org.jruby.truffle.language.globals.CheckOutputSeparatorVariableTypeNode;
import org.jruby.truffle.language.globals.CheckProgramNameVariableTypeNode;
import org.jruby.truffle.language.globals.CheckRecordSeparatorVariableTypeNode;
import org.jruby.truffle.language.globals.CheckStdoutVariableTypeNode;
import org.jruby.truffle.language.globals.ReadGlobalVariableNodeGen;
import org.jruby.truffle.language.globals.ReadLastBacktraceNode;
import org.jruby.truffle.language.globals.ReadMatchReferenceNode;
import org.jruby.truffle.language.globals.ReadThreadLocalGlobalVariableNode;
import org.jruby.truffle.language.globals.UpdateLastBacktraceNode;
import org.jruby.truffle.language.globals.UpdateVerbosityNode;
import org.jruby.truffle.language.globals.WriteGlobalVariableNode;
import org.jruby.truffle.language.globals.WriteGlobalVariableNodeGen;
import org.jruby.truffle.language.globals.WriteProgramNameNodeGen;
import org.jruby.truffle.language.globals.WriteReadOnlyGlobalNode;
import org.jruby.truffle.language.literal.BooleanLiteralNode;
import org.jruby.truffle.language.literal.FloatLiteralNode;
import org.jruby.truffle.language.literal.IntegerFixnumLiteralNode;
import org.jruby.truffle.language.literal.LongFixnumLiteralNode;
import org.jruby.truffle.language.literal.NilLiteralNode;
import org.jruby.truffle.language.literal.ObjectLiteralNode;
import org.jruby.truffle.language.literal.StringLiteralNode;
import org.jruby.truffle.language.locals.DeclarationFlipFlopStateNode;
import org.jruby.truffle.language.locals.FlipFlopNode;
import org.jruby.truffle.language.locals.FlipFlopStateNode;
import org.jruby.truffle.language.locals.InitFlipFlopSlotNode;
import org.jruby.truffle.language.locals.LocalFlipFlopStateNode;
import org.jruby.truffle.language.locals.LocalVariableType;
import org.jruby.truffle.language.locals.ReadLocalVariableNode;
import org.jruby.truffle.language.methods.AddMethodNodeGen;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.BlockDefinitionNode;
import org.jruby.truffle.language.methods.CatchBreakNode;
import org.jruby.truffle.language.methods.ExceptionTranslatingNode;
import org.jruby.truffle.language.methods.GetCurrentVisibilityNode;
import org.jruby.truffle.language.methods.GetDefaultDefineeNode;
import org.jruby.truffle.language.methods.MethodDefinitionNode;
import org.jruby.truffle.language.methods.ModuleBodyDefinitionNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.language.objects.DefineClassNode;
import org.jruby.truffle.language.objects.DefineModuleNode;
import org.jruby.truffle.language.objects.DefineModuleNodeGen;
import org.jruby.truffle.language.objects.LexicalScopeNode;
import org.jruby.truffle.language.objects.ReadClassVariableNode;
import org.jruby.truffle.language.objects.ReadInstanceVariableNode;
import org.jruby.truffle.language.objects.RunModuleDefinitionNode;
import org.jruby.truffle.language.objects.SelfNode;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;
import org.jruby.truffle.language.objects.WriteClassVariableNode;
import org.jruby.truffle.language.objects.WriteInstanceVariableNode;
import org.jruby.truffle.language.threadlocal.GetFromThreadLocalNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNode;
import org.jruby.truffle.language.threadlocal.ThreadLocalObjectNodeGen;
import org.jruby.truffle.language.threadlocal.WrapInThreadLocalNodeGen;
import org.jruby.truffle.language.yield.YieldExpressionNode;
import org.jruby.truffle.parser.ConstantReplacer;
import org.jruby.truffle.parser.DeadNode;
import org.jruby.truffle.parser.Helpers;
import org.jruby.truffle.parser.MethodTranslator;
import org.jruby.truffle.parser.ParseEnvironment;
import org.jruby.truffle.parser.ReadLocalDummyParseNode;
import org.jruby.truffle.parser.ReadLocalNode;
import org.jruby.truffle.parser.Translator;
import org.jruby.truffle.parser.TranslatorEnvironment;
import org.jruby.truffle.parser.ast.AliasParseNode;
import org.jruby.truffle.parser.ast.AndParseNode;
import org.jruby.truffle.parser.ast.ArgsCatParseNode;
import org.jruby.truffle.parser.ast.ArgsParseNode;
import org.jruby.truffle.parser.ast.ArgsPushParseNode;
import org.jruby.truffle.parser.ast.ArgumentParseNode;
import org.jruby.truffle.parser.ast.ArrayParseNode;
import org.jruby.truffle.parser.ast.AssignableParseNode;
import org.jruby.truffle.parser.ast.AttrAssignParseNode;
import org.jruby.truffle.parser.ast.BackRefParseNode;
import org.jruby.truffle.parser.ast.BeginParseNode;
import org.jruby.truffle.parser.ast.BignumParseNode;
import org.jruby.truffle.parser.ast.BlockParseNode;
import org.jruby.truffle.parser.ast.BlockPassParseNode;
import org.jruby.truffle.parser.ast.BreakParseNode;
import org.jruby.truffle.parser.ast.CallParseNode;
import org.jruby.truffle.parser.ast.CaseParseNode;
import org.jruby.truffle.parser.ast.ClassParseNode;
import org.jruby.truffle.parser.ast.ClassVarAsgnParseNode;
import org.jruby.truffle.parser.ast.ClassVarParseNode;
import org.jruby.truffle.parser.ast.Colon2ConstParseNode;
import org.jruby.truffle.parser.ast.Colon2ImplicitParseNode;
import org.jruby.truffle.parser.ast.Colon2ParseNode;
import org.jruby.truffle.parser.ast.Colon3ParseNode;
import org.jruby.truffle.parser.ast.ComplexParseNode;
import org.jruby.truffle.parser.ast.ConstDeclParseNode;
import org.jruby.truffle.parser.ast.ConstParseNode;
import org.jruby.truffle.parser.ast.DAsgnParseNode;
import org.jruby.truffle.parser.ast.DRegexpParseNode;
import org.jruby.truffle.parser.ast.DStrParseNode;
import org.jruby.truffle.parser.ast.DSymbolParseNode;
import org.jruby.truffle.parser.ast.DVarParseNode;
import org.jruby.truffle.parser.ast.DXStrParseNode;
import org.jruby.truffle.parser.ast.DefinedParseNode;
import org.jruby.truffle.parser.ast.DefnParseNode;
import org.jruby.truffle.parser.ast.DefsParseNode;
import org.jruby.truffle.parser.ast.DotParseNode;
import org.jruby.truffle.parser.ast.EncodingParseNode;
import org.jruby.truffle.parser.ast.EnsureParseNode;
import org.jruby.truffle.parser.ast.EvStrParseNode;
import org.jruby.truffle.parser.ast.FCallParseNode;
import org.jruby.truffle.parser.ast.FalseParseNode;
import org.jruby.truffle.parser.ast.FixnumParseNode;
import org.jruby.truffle.parser.ast.FlipParseNode;
import org.jruby.truffle.parser.ast.FloatParseNode;
import org.jruby.truffle.parser.ast.ForParseNode;
import org.jruby.truffle.parser.ast.GlobalAsgnParseNode;
import org.jruby.truffle.parser.ast.GlobalVarParseNode;
import org.jruby.truffle.parser.ast.HashParseNode;
import org.jruby.truffle.parser.ast.IArgumentNode;
import org.jruby.truffle.parser.ast.IfParseNode;
import org.jruby.truffle.parser.ast.InstAsgnParseNode;
import org.jruby.truffle.parser.ast.InstVarParseNode;
import org.jruby.truffle.parser.ast.IterParseNode;
import org.jruby.truffle.parser.ast.LambdaParseNode;
import org.jruby.truffle.parser.ast.ListParseNode;
import org.jruby.truffle.parser.ast.LiteralParseNode;
import org.jruby.truffle.parser.ast.LocalAsgnParseNode;
import org.jruby.truffle.parser.ast.LocalVarParseNode;
import org.jruby.truffle.parser.ast.Match2ParseNode;
import org.jruby.truffle.parser.ast.Match3ParseNode;
import org.jruby.truffle.parser.ast.MatchParseNode;
import org.jruby.truffle.parser.ast.ModuleParseNode;
import org.jruby.truffle.parser.ast.MultipleAsgnParseNode;
import org.jruby.truffle.parser.ast.NextParseNode;
import org.jruby.truffle.parser.ast.NilParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.NthRefParseNode;
import org.jruby.truffle.parser.ast.OpAsgnAndParseNode;
import org.jruby.truffle.parser.ast.OpAsgnOrParseNode;
import org.jruby.truffle.parser.ast.OpAsgnParseNode;
import org.jruby.truffle.parser.ast.OpElementAsgnParseNode;
import org.jruby.truffle.parser.ast.OrParseNode;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.PostExeParseNode;
import org.jruby.truffle.parser.ast.PreExeParseNode;
import org.jruby.truffle.parser.ast.RationalParseNode;
import org.jruby.truffle.parser.ast.RedoParseNode;
import org.jruby.truffle.parser.ast.RegexpParseNode;
import org.jruby.truffle.parser.ast.RescueBodyParseNode;
import org.jruby.truffle.parser.ast.RescueParseNode;
import org.jruby.truffle.parser.ast.RetryParseNode;
import org.jruby.truffle.parser.ast.ReturnParseNode;
import org.jruby.truffle.parser.ast.SClassParseNode;
import org.jruby.truffle.parser.ast.SValueParseNode;
import org.jruby.truffle.parser.ast.SelfParseNode;
import org.jruby.truffle.parser.ast.SideEffectFree;
import org.jruby.truffle.parser.ast.SplatParseNode;
import org.jruby.truffle.parser.ast.StarParseNode;
import org.jruby.truffle.parser.ast.StrParseNode;
import org.jruby.truffle.parser.ast.SymbolParseNode;
import org.jruby.truffle.parser.ast.TrueParseNode;
import org.jruby.truffle.parser.ast.TruffleFragmentParseNode;
import org.jruby.truffle.parser.ast.UndefParseNode;
import org.jruby.truffle.parser.ast.UntilParseNode;
import org.jruby.truffle.parser.ast.VCallParseNode;
import org.jruby.truffle.parser.ast.WhenParseNode;
import org.jruby.truffle.parser.ast.WhileParseNode;
import org.jruby.truffle.parser.ast.XStrParseNode;
import org.jruby.truffle.parser.ast.YieldParseNode;
import org.jruby.truffle.parser.ast.ZArrayParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;
import org.jruby.truffle.parser.lexer.InvalidSourcePosition;
import org.jruby.truffle.parser.parser.ParserSupport;
import org.jruby.truffle.platform.graal.AssertConstantNode;
import org.jruby.truffle.platform.graal.AssertConstantNodeGen;
import org.jruby.truffle.platform.graal.AssertNotCompiledNode;
import org.jruby.truffle.platform.graal.AssertNotCompiledNodeGen;
import org.jruby.truffle.tools.ChaosNodeGen;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.ByteList;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;

public class BodyTranslator
extends Translator {
    protected final BodyTranslator parent;
    protected final TranslatorEnvironment environment;
    public boolean translatingForStatement = false;
    private boolean translatingNextExpression = false;
    private boolean translatingWhile = false;
    protected String currentCallMethodName = null;
    private boolean privately = false;
    protected boolean usesRubiniusPrimitive = false;
    public static final Object BAD_FRAME_SLOT = new Object();
    public Deque<Object> frameOnStackMarkerSlotStack = new ArrayDeque<Object>();
    private final ParserSupport parserSupport;

    public BodyTranslator(Node currentNode, RubyContext context, BodyTranslator parent, TranslatorEnvironment environment, Source source, boolean topLevel) {
        super(currentNode, context, source);
        this.parserSupport = new ParserSupport(context);
        this.parent = parent;
        this.environment = environment;
    }

    private DynamicObject translateNameNodeToSymbol(ParseNode node) {
        return this.context.getSymbolTable().getSymbol(((LiteralParseNode)node).getName());
    }

    @Override
    public RubyNode visitAliasNode(AliasParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        DynamicObject oldName = this.translateNameNodeToSymbol(node.getOldName());
        DynamicObject newName = this.translateNameNodeToSymbol(node.getNewName());
        if (newName.toString().equals("allocate") && this.source.getName().endsWith("/ostruct.rb")) {
            return this.nilNode(this.source, sourceSection);
        }
        ModuleNodes.AliasMethodNode ret = ModuleNodesFactory.AliasMethodNodeFactory.create(new RaiseIfFrozenNode(this.context, fullSourceSection, new GetDefaultDefineeNode(this.context, fullSourceSection)), new ObjectLiteralNode(this.context, fullSourceSection, newName), new ObjectLiteralNode(this.context, fullSourceSection, oldName));
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitAndNode(AndParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        AndNode ret = new AndNode(x, y);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitArgsCatNode(ArgsCatParseNode node) {
        ArrayList<ParseNode> nodes = new ArrayList<ParseNode>();
        this.collectArgsCatNodes(nodes, node);
        ArrayList<RubyNode> translatedNodes = new ArrayList<RubyNode>();
        for (ParseNode catNode : nodes) {
            translatedNodes.add(catNode.accept(this));
        }
        ArrayConcatNode ret = new ArrayConcatNode(this.context, this.translate(node.getPosition()).toSourceSection(this.source), translatedNodes.toArray(new RubyNode[translatedNodes.size()]));
        return this.addNewlineIfNeeded(node, ret);
    }

    private void collectArgsCatNodes(List<ParseNode> nodes, ArgsCatParseNode node) {
        if (node.getFirstNode() instanceof ArgsCatParseNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatParseNode)node.getFirstNode());
        } else {
            nodes.add(node.getFirstNode());
        }
        if (node.getSecondNode() instanceof ArgsCatParseNode) {
            this.collectArgsCatNodes(nodes, (ArgsCatParseNode)node.getSecondNode());
        } else {
            SplatParseNode secondNode = new SplatParseNode(node.getSecondNode().getPosition(), node.getSecondNode());
            nodes.add(secondNode);
        }
    }

    @Override
    public RubyNode visitArgsPushNode(ArgsPushParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode args = node.getFirstNode().accept(this);
        RubyNode value = node.getSecondNode().accept(this);
        ArrayAppendOneNode ret = ArrayAppendOneNodeGen.create(this.context, fullSourceSection, KernelNodesFactory.DupNodeFactory.create(this.context, fullSourceSection, new RubyNode[]{args}), value);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitArrayNode(ArrayParseNode node) {
        ParseNode[] values = node.children();
        RubyNode[] translatedValues = new RubyNode[values.length];
        for (int n = 0; n < values.length; ++n) {
            translatedValues[n] = values[n].accept(this);
        }
        ArrayLiteralNode ret = ArrayLiteralNode.create(this.context, this.translate(node.getPosition()), translatedValues);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitAttrAssignNode(AttrAssignParseNode node) {
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), node.getName(), node.getArgsNode(), null, node.isLazy());
        this.copyNewline(node, callNode);
        boolean isAccessorOnSelf = node.getReceiverNode() instanceof SelfParseNode;
        RubyNode actualCall = this.translateCallNode(callNode, isAccessorOnSelf, false, true);
        return this.addNewlineIfNeeded(node, actualCall);
    }

    @Override
    public RubyNode visitBeginNode(BeginParseNode node) {
        RubyNode ret = node.getBodyNode().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBignumNode(BignumParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        BigInteger value = node.getValue();
        RubyNode ret = value.bitLength() >= 64 ? new ObjectLiteralNode(this.context, fullSourceSection, BignumOperations.createBignum(this.context, node.getValue())) : new LongFixnumLiteralNode(this.context, fullSourceSection, value.longValue());
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitBlockNode(BlockParseNode node) {
        int firstLine;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> translatedChildren = new ArrayList<RubyNode>();
        int lastLine = firstLine = node.getPosition().getLine() + 1;
        for (ParseNode child : node.children()) {
            RubyNode translatedChild;
            if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.push(sourceSection);
            } else {
                lastLine = Math.max(lastLine, child.getPosition().getLine() + 1);
            }
            try {
                translatedChild = child.accept(this);
            }
            finally {
                if (child.getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection.pop();
                }
            }
            if (translatedChild instanceof DeadNode) continue;
            translatedChildren.add(translatedChild);
        }
        RubyNode ret = translatedChildren.size() == 1 ? (RubyNode)translatedChildren.get(0) : BodyTranslator.sequence(this.context, this.source, new RubySourceSection(firstLine, lastLine), translatedChildren);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitBreakNode(BreakParseNode node) {
        RubyNode resultNode;
        assert (this.environment.isBlock() || this.translatingWhile) : "The parser did not see an invalid break";
        RubySourceSection sourceSection = this.translate(node.getPosition());
        if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection.push(sourceSection);
            try {
                resultNode = node.getValueNode().accept(this);
            }
            finally {
                this.parentSourceSection.pop();
            }
        } else {
            resultNode = node.getValueNode().accept(this);
        }
        BreakNode ret = new BreakNode(this.environment.getBreakID(), this.translatingWhile, resultNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitCallNode(CallParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ParseNode receiver = node.getReceiverNode();
        String methodName = node.getName();
        if (receiver instanceof StrParseNode && methodName.equals("freeze")) {
            StrParseNode strNode = (StrParseNode)receiver;
            ByteList byteList = strNode.getValue();
            int codeRange = strNode.getCodeRange();
            Rope rope = this.context.getRopeTable().getRope(byteList.bytes(), byteList.getEncoding(), CodeRange.fromInt(codeRange));
            DynamicObject frozenString = this.context.getFrozenStrings().getFrozenString(rope);
            return this.addNewlineIfNeeded(node, new DefinedWrapperNode(this.context, fullSourceSection, this.context.getCoreStrings().METHOD, new ObjectLiteralNode(this.context, null, frozenString)));
        }
        if (receiver instanceof ConstParseNode && ((ConstParseNode)receiver).getName().equals("Truffle")) {
            if (methodName.equals("primitive")) {
                RubyNode ret = this.translateRubiniusPrimitive(fullSourceSection, node);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("invoke_primitive")) {
                RubyNode ret = this.translateRubiniusInvokePrimitive(fullSourceSection, node);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("privately")) {
                RubyNode ret = this.translateRubiniusPrivately(fullSourceSection, node);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("single_block_arg")) {
                RubyNode ret = this.translateSingleBlockArg(fullSourceSection, node);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("check_frozen")) {
                RubyNode ret = this.translateCheckFrozen(fullSourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (receiver instanceof Colon2ConstParseNode && ((Colon2ConstParseNode)receiver).getLeftNode() instanceof ConstParseNode && ((ConstParseNode)((Colon2ConstParseNode)receiver).getLeftNode()).getName().equals("Truffle") && ((Colon2ConstParseNode)receiver).getName().equals("Graal")) {
            if (methodName.equals("assert_constant")) {
                AssertConstantNode ret = AssertConstantNodeGen.create(this.context, fullSourceSection, node.getArgsNode().childNodes().get(0).accept(this));
                return this.addNewlineIfNeeded(node, ret);
            }
            if (methodName.equals("assert_not_compiled")) {
                AssertNotCompiledNode ret = AssertNotCompiledNodeGen.create(this.context, fullSourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (receiver instanceof VCallParseNode && ((VCallParseNode)receiver).getName().equals("undefined") && this.getSourcePath(sourceSection).startsWith(this.buildCorePath("")) && methodName.equals("equal?")) {
            RubyNode argument = this.translateArgumentsAndBlock(sourceSection, null, node.getArgsNode(), methodName).getArguments()[0];
            IsRubiniusUndefinedNode ret = new IsRubiniusUndefinedNode(this.context, fullSourceSection, argument);
            return this.addNewlineIfNeeded(node, ret);
        }
        return this.translateCallNode(node, false, false, false);
    }

    private RubyNode translateRubiniusPrimitive(SourceSection sourceSection, CallParseNode node) {
        this.usesRubiniusPrimitive = true;
        if (node.getArgsNode().childNodes().size() != 1 || !(node.getArgsNode().childNodes().get(0) instanceof SymbolParseNode)) {
            throw new UnsupportedOperationException("Truffle.primitive must have a single literal symbol argument");
        }
        String primitiveName = ((SymbolParseNode)node.getArgsNode().childNodes().get(0)).getName();
        PrimitiveNodeConstructor primitive = this.context.getPrimitiveManager().getPrimitive(primitiveName);
        ReturnID returnID = this.environment.getReturnID();
        return primitive.createCallPrimitiveNode(this.context, sourceSection, returnID);
    }

    private RubyNode translateRubiniusInvokePrimitive(SourceSection sourceSection, CallParseNode node) {
        List<ParseNode> args = node.getArgsNode().childNodes();
        if (args.size() < 1 || !(args.get(0) instanceof SymbolParseNode)) {
            throw new UnsupportedOperationException("Truffle.invoke_primitive must have at least an initial literal symbol argument");
        }
        String primitiveName = ((SymbolParseNode)args.get(0)).getName();
        PrimitiveNodeConstructor primitive = this.context.getPrimitiveManager().getPrimitive(primitiveName);
        ArrayList<RubyNode> arguments = new ArrayList<RubyNode>();
        for (int n = 1; n < args.size(); ++n) {
            RubyNode readArgumentNode = args.get(n).accept(this);
            arguments.add(readArgumentNode);
        }
        return primitive.createInvokePrimitiveNode(this.context, sourceSection, arguments.toArray(new RubyNode[arguments.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateRubiniusPrivately(SourceSection sourceSection, CallParseNode node) {
        if (!(node.getIterNode() instanceof IterParseNode)) {
            throw new UnsupportedOperationException("Truffle.privately needs a literal block");
        }
        if (node.getArgsNode() != null && node.getArgsNode().childNodes().size() > 0) {
            throw new UnsupportedOperationException("Truffle.privately should not have any arguments");
        }
        this.currentCallMethodName = "privately";
        boolean previousPrivately = this.privately;
        this.privately = true;
        try {
            RubyNode rubyNode = ((IterParseNode)node.getIterNode()).getBodyNode().accept(this);
            return rubyNode;
        }
        finally {
            this.privately = previousPrivately;
        }
    }

    public RubyNode translateSingleBlockArg(SourceSection sourceSection, CallParseNode node) {
        return new SingleBlockArgNode(this.context, sourceSection);
    }

    private RubyNode translateCheckFrozen(SourceSection sourceSection) {
        return new RaiseIfFrozenNode(this.context, sourceSection, new SelfNode(this.environment.getFrameDescriptor()));
    }

    private RubyNode translateCallNode(CallParseNode node, boolean ignoreVisibility, boolean isVCall, boolean isAttrAssign) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode receiver = node.getReceiverNode().accept(this);
        ParseNode args = node.getArgsNode();
        ParseNode block = node.getIterNode();
        if (block == null && args instanceof IterParseNode) {
            block = args;
            args = null;
        }
        String methodName = node.getName();
        ArgumentsAndBlockTranslation argumentsAndBlock = this.translateArgumentsAndBlock(sourceSection, block, args, methodName);
        ArrayList<RubyNode> children = new ArrayList<RubyNode>();
        if (argumentsAndBlock.getBlock() != null) {
            children.add(argumentsAndBlock.getBlock());
        }
        children.addAll(Arrays.asList(argumentsAndBlock.getArguments()));
        RubySourceSection enclosingSourceSection = BodyTranslator.enclosing(sourceSection, children.toArray(new RubyNode[children.size()]));
        SourceSection enclosingFullSourceSection = enclosingSourceSection.toSourceSection(this.source);
        RubyCallNodeParameters callParameters = new RubyCallNodeParameters(this.context, enclosingFullSourceSection, receiver, methodName, argumentsAndBlock.getBlock(), argumentsAndBlock.getArguments(), argumentsAndBlock.isSplatted(), this.privately || ignoreVisibility, isVCall, node.isLazy(), isAttrAssign);
        RubyNode translated = this.context.getCoreMethods().createCallNode(callParameters);
        if (argumentsAndBlock.getBlock() instanceof BlockDefinitionNode) {
            BlockDefinitionNode blockDef = (BlockDefinitionNode)argumentsAndBlock.getBlock();
            translated = new FrameOnStackNode(translated, argumentsAndBlock.getFrameOnStackMarkerSlot());
            translated = new CatchBreakNode(this.context, enclosingFullSourceSection, blockDef.getBreakID(), translated);
        }
        return this.addNewlineIfNeeded(node, translated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArgumentsAndBlockTranslation translateArgumentsAndBlock(RubySourceSection sourceSection, ParseNode iterNode, ParseNode argsNode, String nameToSetWhenTranslatingBlock) {
        FrameSlot frameOnStackMarkerSlot;
        RubyNode blockTranslated;
        assert (!(argsNode instanceof IterParseNode));
        ArrayList<ParseNode> arguments = new ArrayList<ParseNode>();
        ParseNode blockPassNode = null;
        boolean isSplatted = false;
        if (argsNode instanceof ListParseNode) {
            arguments.addAll(argsNode.childNodes());
        } else if (argsNode instanceof BlockPassParseNode) {
            BlockPassParseNode blockPass = (BlockPassParseNode)argsNode;
            ParseNode blockPassArgs = blockPass.getArgsNode();
            if (blockPassArgs instanceof ListParseNode) {
                arguments.addAll(blockPassArgs.childNodes());
            } else if (blockPassArgs instanceof ArgsCatParseNode) {
                arguments.add(blockPassArgs);
            } else if (blockPassArgs != null) {
                throw new UnsupportedOperationException("Don't know how to block pass " + blockPassArgs);
            }
            blockPassNode = blockPass.getBodyNode();
        } else if (argsNode instanceof SplatParseNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode instanceof ArgsCatParseNode) {
            isSplatted = true;
            arguments.add(argsNode);
        } else if (argsNode != null) {
            isSplatted = true;
            arguments.add(argsNode);
        }
        RubyNode[] argumentsTranslated = new RubyNode[arguments.size()];
        for (int i = 0; i < arguments.size(); ++i) {
            argumentsTranslated[i] = ((ParseNode)arguments.get(i)).accept(this);
        }
        if (iterNode instanceof BlockPassParseNode) {
            blockPassNode = ((BlockPassParseNode)iterNode).getBodyNode();
        }
        this.currentCallMethodName = nameToSetWhenTranslatingBlock;
        if (blockPassNode != null) {
            blockTranslated = ToProcNodeGen.create(this.context, sourceSection.toSourceSection(this.source), blockPassNode.accept(this));
            frameOnStackMarkerSlot = null;
        } else if (iterNode != null) {
            frameOnStackMarkerSlot = this.environment.declareVar(this.environment.allocateLocalTemp("frame_on_stack_marker"));
            this.frameOnStackMarkerSlotStack.push(frameOnStackMarkerSlot);
            try {
                blockTranslated = iterNode.accept(this);
            }
            finally {
                this.frameOnStackMarkerSlotStack.pop();
            }
            if (blockTranslated instanceof ObjectLiteralNode && ((ObjectLiteralNode)blockTranslated).getObject() == this.context.getCoreLibrary().getNilObject()) {
                blockTranslated = null;
            }
        } else {
            blockTranslated = null;
            frameOnStackMarkerSlot = null;
        }
        return new ArgumentsAndBlockTranslation(blockTranslated, argumentsTranslated, isSplatted, frameOnStackMarkerSlot);
    }

    @Override
    public RubyNode visitCaseNode(CaseParseNode node) {
        RubyNode ret;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode elseNode = this.translateNodeOrNil(sourceSection, node.getElseNode());
        if (node.getCaseNode() != null) {
            String tempName = this.environment.allocateLocalTemp("case");
            ReadLocalNode readTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection);
            RubyNode assignTemp = readTemp.makeWriteNode(node.getCaseNode().accept(this));
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenParseNode when = (WhenParseNode)node.getCases().get(n);
                List<ParseNode> expressions = when.getExpressionNodes() instanceof ListParseNode && !(when.getExpressionNodes() instanceof ArrayParseNode) ? when.getExpressionNodes().childNodes() : Collections.singletonList(when.getExpressionNodes());
                ArrayList<RubyCallNode> comparisons = new ArrayList<RubyCallNode>();
                for (ParseNode expressionNode : expressions) {
                    RubyNode[] arguments;
                    String method;
                    RubyNode receiver;
                    RubyNode rubyExpression = expressionNode.accept(this);
                    if (expressionNode instanceof SplatParseNode || expressionNode instanceof ArgsCatParseNode || expressionNode instanceof ArgsPushParseNode) {
                        receiver = new ObjectLiteralNode(this.context, fullSourceSection, this.context.getCoreLibrary().getTruffleModule());
                        method = "when_splat";
                        arguments = new RubyNode[]{rubyExpression, NodeUtil.cloneNode(readTemp)};
                    } else {
                        receiver = rubyExpression;
                        method = "===";
                        arguments = new RubyNode[]{NodeUtil.cloneNode(readTemp)};
                    }
                    RubyCallNodeParameters callParameters = new RubyCallNodeParameters(this.context, fullSourceSection, receiver, method, null, arguments, false, true);
                    comparisons.add(new RubyCallNode(callParameters));
                }
                RubyNode conditionNode = (RubyNode)comparisons.get(comparisons.size() - 1);
                for (int i = comparisons.size() - 2; i >= 0; --i) {
                    conditionNode = new OrNode((RubyNode)comparisons.get(i), conditionNode);
                }
                RubyNode thenNode = this.translateNodeOrNil(sourceSection, when.getBodyNode());
                IfElseNode ifNode = new IfElseNode(conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            RubyNode ifNode = elseNode;
            ret = BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(assignTemp, ifNode));
        } else {
            for (int n = node.getCases().size() - 1; n >= 0; --n) {
                WhenParseNode when = (WhenParseNode)node.getCases().get(n);
                List<ParseNode> expressions = when.getExpressionNodes() instanceof ListParseNode ? when.getExpressionNodes().childNodes() : Collections.singletonList(when.getExpressionNodes());
                ArrayList<RubyNode> tests = new ArrayList<RubyNode>();
                for (ParseNode expressionNode : expressions) {
                    RubyNode rubyExpression = expressionNode.accept(this);
                    tests.add(rubyExpression);
                }
                RubyNode conditionNode = (RubyNode)tests.get(tests.size() - 1);
                for (int i = tests.size() - 2; i >= 0; --i) {
                    conditionNode = new OrNode((RubyNode)tests.get(i), conditionNode);
                }
                RubyNode thenNode = when.getBodyNode().accept(this);
                IfElseNode ifNode = new IfElseNode(conditionNode, thenNode, elseNode);
                elseNode = ifNode;
            }
            ret = elseNode;
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode openModule(RubySourceSection sourceSection, RubyNode defineOrGetNode, String name, ParseNode bodyNode, boolean sclass) {
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        LexicalScope newLexicalScope = this.environment.pushLexicalScope();
        try {
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(fullSourceSection, newLexicalScope, Arity.NO_ARGUMENTS, name, false, null, false, false, false);
            ReturnID returnId = sclass ? this.environment.getReturnID() : this.environment.getParseEnvironment().allocateReturnID();
            TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), returnId, true, true, sharedMethodInfo, name, 0, null);
            BodyTranslator moduleTranslator = new BodyTranslator(this.currentNode, this.context, this, newEnvironment, this.source, false);
            ModuleBodyDefinitionNode definition = moduleTranslator.compileClassNode(sourceSection, name, bodyNode, sclass);
            RunModuleDefinitionNode runModuleDefinitionNode = new RunModuleDefinitionNode(this.context, fullSourceSection, newLexicalScope, definition, defineOrGetNode);
            return runModuleDefinitionNode;
        }
        finally {
            this.environment.popLexicalScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModuleBodyDefinitionNode compileClassNode(RubySourceSection sourceSection, String name, ParseNode bodyNode, boolean sclass) {
        RubyNode body;
        this.parentSourceSection.push(sourceSection);
        try {
            body = this.translateNodeOrNil(sourceSection, bodyNode);
        }
        finally {
            this.parentSourceSection.pop();
        }
        if (this.environment.getFlipFlopStates().size() > 0) {
            body = BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(this.initFlipFlopStates(sourceSection), body));
        }
        RubyNode writeSelfNode = BodyTranslator.loadSelf(this.context, this.environment);
        body = BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(writeSelfNode, body));
        if (this.context.getOptions().CHAOS) {
            body = ChaosNodeGen.create(body);
        }
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyRootNode rootNode = new RubyRootNode(this.context, fullSourceSection, this.environment.getFrameDescriptor(), this.environment.getSharedMethodInfo(), body, this.environment.needsDeclarationFrame());
        ModuleBodyDefinitionNode definitionNode = new ModuleBodyDefinitionNode(this.context, fullSourceSection, this.environment.getSharedMethodInfo().getName(), this.environment.getSharedMethodInfo(), (CallTarget)Truffle.getRuntime().createCallTarget(rootNode), sclass);
        return definitionNode;
    }

    @Override
    public RubyNode visitClassNode(ClassParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        RubyNode superClass = node.getSuperNode() != null ? node.getSuperNode().accept(this) : new ObjectLiteralNode(this.context, fullSourceSection, this.context.getCoreLibrary().getObjectClass());
        DefineClassNode defineOrGetClass = new DefineClassNode(this.context, fullSourceSection, name, lexicalParent, superClass);
        RubyNode ret = this.openModule(sourceSection, defineOrGetClass, name, node.getBodyNode(), false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitClassVarAsgnNode(ClassVarAsgnParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode rhs = node.getValueNode().accept(this);
        WriteClassVariableNode ret = new WriteClassVariableNode(this.context, sourceSection.toSourceSection(this.source), this.environment.getLexicalScope(), node.getName(), rhs);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitClassVarNode(ClassVarParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        ReadClassVariableNode ret = new ReadClassVariableNode(this.context, sourceSection.toSourceSection(this.source), this.environment.getLexicalScope(), node.getName());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitColon2Node(Colon2ParseNode node) {
        if (!(node instanceof Colon2ConstParseNode)) {
            throw new UnsupportedOperationException(node.toString());
        }
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = ConstantReplacer.replacementName(fullSourceSection, node.getName());
        RubyNode lhs = node.getLeftNode().accept(this);
        ReadConstantNode ret = new ReadConstantNode(this.context, fullSourceSection, lhs, name);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitColon3Node(Colon3ParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = ConstantReplacer.replacementName(fullSourceSection, node.getName());
        ObjectLiteralNode root = new ObjectLiteralNode(this.context, fullSourceSection, this.context.getCoreLibrary().getObjectClass());
        ReadConstantNode ret = new ReadConstantNode(this.context, fullSourceSection, root, name);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateCPath(RubySourceSection sourceSection, Colon3ParseNode node) {
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode ret = node instanceof Colon2ImplicitParseNode ? new LexicalScopeNode(this.context, fullSourceSection, this.environment.getLexicalScope()) : (node instanceof Colon2ConstParseNode ? node.childNodes().get(0).accept(this) : new ObjectLiteralNode(this.context, fullSourceSection, this.context.getCoreLibrary().getObjectClass()));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitComplexNode(ComplexParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode ret = this.translateRationalComplex(sourceSection, "Complex", new IntegerFixnumLiteralNode(this.context, fullSourceSection, 0), node.getNumber().accept(this));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitConstDeclNode(ConstDeclParseNode node) {
        RubyNode moduleNode;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode rhs = node.getValueNode().accept(this);
        ParseNode constNode = node.getConstNode();
        if (constNode == null || constNode instanceof Colon2ImplicitParseNode) {
            moduleNode = new LexicalScopeNode(this.context, sourceSection.toSourceSection(this.source), this.environment.getLexicalScope());
        } else if (constNode instanceof Colon2ConstParseNode) {
            constNode = ((Colon2ParseNode)constNode).getLeftNode();
            moduleNode = constNode.accept(this);
        } else if (constNode instanceof Colon3ParseNode) {
            moduleNode = new ObjectLiteralNode(this.context, sourceSection.toSourceSection(this.source), this.context.getCoreLibrary().getObjectClass());
        } else {
            throw new UnsupportedOperationException();
        }
        WriteConstantNode ret = new WriteConstantNode(node.getName(), moduleNode, rhs);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    private String getSourcePath(RubySourceSection sourceSection) {
        if (sourceSection == null) {
            return "(unknown)";
        }
        if (this.source == null) {
            return "(unknown)";
        }
        String path = this.source.getName();
        if (path == null) {
            return this.source.getName();
        }
        return path;
    }

    private String buildCorePath(String ... components) {
        StringBuilder ret = new StringBuilder(this.context.getCoreLibrary().getCoreLoadPath());
        ret.append(File.separatorChar).append("core");
        for (String component : components) {
            ret.append(File.separatorChar);
            ret.append(component);
        }
        return ret.toString();
    }

    private String buildPartialPath(String ... components) {
        StringBuilder ret = new StringBuilder();
        for (String component : components) {
            ret.append(File.separatorChar);
            ret.append(component);
        }
        return ret.toString();
    }

    @Override
    public RubyNode visitConstNode(ConstParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = ConstantReplacer.replacementName(fullSourceSection, node.getName());
        if (name.equals("Rubinius") && this.getSourcePath(sourceSection).startsWith(this.buildCorePath(""))) {
            RubyNode ret = new Colon3ParseNode(node.getPosition(), name).accept(this);
            return this.addNewlineIfNeeded(node, ret);
        }
        if (name.equals("RUBY_PLATFORM") && this.getSourcePath(sourceSection).contains(this.buildPartialPath("test", "xml_mini", "jdom_engine_test.rb"))) {
            ObjectLiteralNode ret = new ObjectLiteralNode(this.context, fullSourceSection, StringOperations.createString(this.context, StringOperations.encodeRope("truffle", (Encoding)UTF8Encoding.INSTANCE, CodeRange.CR_7BIT)));
            return this.addNewlineIfNeeded(node, ret);
        }
        LexicalScope lexicalScope = this.environment.getLexicalScope();
        ReadConstantWithLexicalScopeNode ret = new ReadConstantWithLexicalScopeNode(this.context, fullSourceSection, lexicalScope, name);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDAsgnNode(DAsgnParseNode node) {
        RubyNode ret = new LocalAsgnParseNode(node.getPosition(), node.getName(), node.getDepth(), node.getValueNode()).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDRegxNode(DRegexpParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> children = new ArrayList<RubyNode>();
        for (ParseNode child : node.children()) {
            children.add(child.accept(this));
        }
        InterpolatedRegexpNode i = new InterpolatedRegexpNode(this.context, sourceSection.toSourceSection(this.source), children.toArray(new RubyNode[children.size()]), node.getOptions());
        if (node.getOptions().isOnce()) {
            OnceNode ret = new OnceNode(i);
            ret.unsafeSetSourceSection(sourceSection);
            return this.addNewlineIfNeeded(node, ret);
        }
        return this.addNewlineIfNeeded(node, i);
    }

    @Override
    public RubyNode visitDStrNode(DStrParseNode node) {
        RubyNode ret = this.translateInterpolatedString(this.translate(node.getPosition()).toSourceSection(this.source), node.children());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDSymbolNode(DSymbolParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode stringNode = this.translateInterpolatedString(fullSourceSection, node.children());
        StringToSymbolNode ret = StringToSymbolNodeGen.create(this.context, fullSourceSection, stringNode);
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateInterpolatedString(SourceSection sourceSection, ParseNode[] childNodes) {
        ToSNode[] children = new ToSNode[childNodes.length];
        for (int i = 0; i < childNodes.length; ++i) {
            children[i] = ToSNodeGen.create(this.context, sourceSection, childNodes[i].accept(this));
        }
        return new InterpolatedStringNode(this.context, sourceSection, children);
    }

    @Override
    public RubyNode visitDVarNode(DVarParseNode node) {
        ReadLocalNode readNode = this.environment.findLocalVarNode(node.getName(), this.source, this.translate(node.getPosition()));
        if (readNode == null) {
            int depth = node.getDepth();
            TranslatorEnvironment e = this.environment;
            for (int n = 0; n < depth; ++n) {
                e = e.getParent();
            }
            e.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(node.getName(), this.source, this.translate(node.getPosition()));
        }
        return this.addNewlineIfNeeded(node, readNode);
    }

    @Override
    public RubyNode visitDXStrNode(DXStrParseNode node) {
        DStrParseNode string = new DStrParseNode(node.getPosition(), node.getEncoding());
        string.addAll(node);
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), string, new ParseNode[0]);
        FCallParseNode callNode = new FCallParseNode(node.getPosition(), "`", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefinedNode(DefinedParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        DefinedNode ret = new DefinedNode(this.context, sourceSection.toSourceSection(this.source), node.getExpressionNode().accept(this));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefnNode(DefnParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RaiseIfFrozenNode classNode = new RaiseIfFrozenNode(this.context, fullSourceSection, new GetDefaultDefineeNode(this.context, fullSourceSection));
        String methodName = node.getName();
        RubyNode ret = this.translateMethodDefinition(sourceSection, classNode, methodName, node.getArgsNode(), node.getBodyNode(), false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitDefsNode(DefsParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode objectNode = node.getReceiverNode().accept(this);
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(this.context, fullSourceSection, objectNode);
        RubyNode ret = this.translateMethodDefinition(sourceSection, singletonClassNode, node.getName(), node.getArgsNode(), node.getBodyNode(), true);
        return this.addNewlineIfNeeded(node, ret);
    }

    protected RubyNode translateMethodDefinition(RubySourceSection sourceSection, RubyNode classNode, String methodName, ArgsParseNode argsNode, ParseNode bodyNode, boolean isDefs) {
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        Arity arity = MethodTranslator.getArity(argsNode);
        ArgumentDescriptor[] argumentDescriptors = Helpers.argsNodeToArgumentDescriptors(argsNode);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection.toSourceSection(this.source), this.environment.getLexicalScope(), arity, methodName, false, argumentDescriptors, false, false, false);
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, this.environment.getParseEnvironment(), this.environment.getParseEnvironment().allocateReturnID(), true, true, sharedMethodInfo, methodName, 0, null);
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, false, this.source, argsNode);
        MethodDefinitionNode methodDefinitionNode = methodCompiler.compileMethodNode(sourceSection, methodName, bodyNode, sharedMethodInfo);
        RubyNode visibilityNode = isDefs ? new ObjectLiteralNode(this.context, fullSourceSection, Visibility.PUBLIC) : new GetCurrentVisibilityNode(this.context, fullSourceSection);
        return AddMethodNodeGen.create(this.context, fullSourceSection, isDefs, true, classNode, methodDefinitionNode, visibilityNode);
    }

    @Override
    public RubyNode visitDotNode(DotParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode begin = node.getBeginNode().accept(this);
        RubyNode end = node.getEndNode().accept(this);
        ObjectLiteralNode rangeClass = new ObjectLiteralNode(this.context, fullSourceSection, this.context.getCoreLibrary().getRangeClass());
        ObjectLiteralNode isExclusive = new ObjectLiteralNode(this.context, fullSourceSection, node.isExclusive());
        RangeNodes.NewNode ret = RangeNodesFactory.NewNodeFactory.create(this.context, fullSourceSection, rangeClass, begin, end, isExclusive);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEncodingNode(EncodingParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        ObjectLiteralNode ret = new ObjectLiteralNode(this.context, sourceSection.toSourceSection(this.source), this.context.getEncodingManager().getRubyEncoding(node.getEncoding()));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEnsureNode(EnsureParseNode node) {
        RubyNode tryPart = node.getBodyNode().accept(this);
        RubyNode ensurePart = node.getEnsureNode().accept(this);
        EnsureNode ret = new EnsureNode(this.context, this.translate(node.getPosition()).toSourceSection(this.source), tryPart, ensurePart);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitEvStrNode(EvStrParseNode node) {
        RubyNode ret;
        if (node.getBody() == null) {
            RubySourceSection sourceSection = this.translate(node.getPosition());
            ret = new ObjectLiteralNode(this.context, sourceSection.toSourceSection(this.source), StringOperations.createString(this.context, RopeConstants.EMPTY_ASCII_8BIT_ROPE));
        } else {
            ret = node.getBody().accept(this);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFCallNode(FCallParseNode node) {
        SelfParseNode receiver = new SelfParseNode(node.getPosition());
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, node.getName(), node.getArgsNode(), node.getIterNode());
        this.copyNewline(node, callNode);
        return this.translateCallNode(callNode, true, false, false);
    }

    @Override
    public RubyNode visitFalseNode(FalseParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        BooleanLiteralNode ret = new BooleanLiteralNode(this.context, sourceSection.toSourceSection(this.source), false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFixnumNode(FixnumParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        long value = node.getValue();
        RubyNode ret = CoreLibrary.fitsIntoInteger(value) ? new IntegerFixnumLiteralNode(this.context, sourceSection.toSourceSection(this.source), (int)value) : new LongFixnumLiteralNode(this.context, sourceSection.toSourceSection(this.source), value);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitFlipNode(FlipParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode begin = node.getBeginNode().accept(this);
        RubyNode end = node.getEndNode().accept(this);
        FlipFlopStateNode stateNode = this.createFlipFlopState(sourceSection, 0);
        FlipFlopNode ret = new FlipFlopNode(this.context, sourceSection.toSourceSection(this.source), begin, end, stateNode, node.isExclusive());
        return this.addNewlineIfNeeded(node, ret);
    }

    protected FlipFlopStateNode createFlipFlopState(RubySourceSection sourceSection, int depth) {
        FrameSlot frameSlot = this.environment.declareVar(this.environment.allocateLocalTemp("flipflop"));
        this.environment.getFlipFlopStates().add(frameSlot);
        if (depth == 0) {
            return new LocalFlipFlopStateNode(frameSlot);
        }
        return new DeclarationFlipFlopStateNode(depth, frameSlot);
    }

    @Override
    public RubyNode visitFloatNode(FloatParseNode node) {
        FloatLiteralNode ret = new FloatLiteralNode(this.context, this.translate(node.getPosition()).toSourceSection(this.source), node.getValue());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitForNode(ForParseNode node) {
        String temp = this.environment.allocateLocalTemp("for");
        ParseNode receiver = node.getIterNode();
        LocalVarParseNode readTemp = new LocalVarParseNode(node.getPosition(), 0, temp);
        ParseNode forVar = node.getVarNode();
        ParseNode assignTemp = this.setRHS(forVar, readTemp);
        BlockParseNode bodyWithTempAssign = new BlockParseNode(node.getPosition());
        bodyWithTempAssign.add(assignTemp);
        bodyWithTempAssign.add(node.getBodyNode());
        ArgumentParseNode blockVar = new ArgumentParseNode(node.getPosition(), temp);
        ListParseNode blockArgsPre = new ListParseNode(node.getPosition(), blockVar);
        ArgsParseNode blockArgs = new ArgsParseNode(node.getPosition(), blockArgsPre, null, null, null, null, null, null);
        IterParseNode block = new IterParseNode(node.getPosition(), (ParseNode)blockArgs, node.getScope(), bodyWithTempAssign);
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, "each", null, block);
        this.copyNewline(node, callNode);
        this.translatingForStatement = true;
        RubyNode translated = callNode.accept(this);
        this.translatingForStatement = false;
        return this.addNewlineIfNeeded(node, translated);
    }

    private ParseNode setRHS(ParseNode node, ParseNode rhs) {
        if (node instanceof AssignableParseNode || node instanceof IArgumentNode) {
            return this.parserSupport.node_assign(node, rhs);
        }
        throw new UnsupportedOperationException("Don't know how to set the RHS of a " + node.getClass().getName());
    }

    private RubyNode translateDummyAssignment(ParseNode dummyAssignment, final RubyNode rhs) {
        if (dummyAssignment instanceof StarParseNode) {
            return rhs;
        }
        if (dummyAssignment instanceof AssignableParseNode || dummyAssignment instanceof IArgumentNode) {
            ParseNode wrappedRHS = new ParseNode(dummyAssignment.getPosition(), false){

                @Override
                public <T> T accept(NodeVisitor<T> visitor) {
                    return (T)rhs;
                }

                @Override
                public List<ParseNode> childNodes() {
                    return Collections.emptyList();
                }

                @Override
                public NodeType getNodeType() {
                    return NodeType.FIXNUMNODE;
                }
            };
            return this.setRHS(dummyAssignment, wrappedRHS).accept(this);
        }
        throw new UnsupportedOperationException("Don't know how to translate the dummy asgn " + dummyAssignment.getClass().getName());
    }

    @Override
    public RubyNode visitGlobalAsgnNode(GlobalAsgnParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode rhs = node.getValueNode().accept(this);
        String name = node.getName();
        if (GLOBAL_VARIABLE_ALIASES.containsKey(name)) {
            name = (String)GLOBAL_VARIABLE_ALIASES.get(name);
        }
        if (name.equals("$~")) {
            rhs = new CheckMatchVariableTypeNode(this.context, sourceSection.toSourceSection(this.source), rhs);
            rhs = WrapInThreadLocalNodeGen.create(this.context, sourceSection.toSourceSection(this.source), rhs);
            this.environment.declareVarInMethodScope("$~");
        } else if (name.equals("$0")) {
            rhs = new CheckProgramNameVariableTypeNode(this.context, sourceSection.toSourceSection(this.source), rhs);
        } else if (name.equals("$/")) {
            rhs = new CheckRecordSeparatorVariableTypeNode(this.context, sourceSection.toSourceSection(this.source), rhs);
        } else if (name.equals("$,")) {
            rhs = new CheckOutputSeparatorVariableTypeNode(this.context, sourceSection.toSourceSection(this.source), rhs);
        } else if (name.equals("$_")) {
            rhs = this.getSourcePath(sourceSection).endsWith(this.buildPartialPath("truffle", "rubysl", "rubysl-stringio", "lib", "rubysl", "stringio", "stringio.rb")) ? RubiniusLastStringWriteNodeGen.create(this.context, sourceSection.toSourceSection(this.source), rhs) : WrapInThreadLocalNodeGen.create(this.context, sourceSection.toSourceSection(this.source), rhs);
            this.environment.declareVar("$_");
        } else if (name.equals("$stdout")) {
            rhs = new CheckStdoutVariableTypeNode(this.context, fullSourceSection, rhs);
        } else if (name.equals("$VERBOSE")) {
            rhs = new UpdateVerbosityNode(this.context, fullSourceSection, rhs);
        } else if (name.equals("$@")) {
            return new UpdateLastBacktraceNode(this.context, fullSourceSection, rhs);
        }
        boolean inCore = this.getSourcePath(this.translate(node.getValueNode().getPosition())).startsWith(this.buildCorePath(""));
        if (!inCore && READ_ONLY_GLOBAL_VARIABLES.contains(name)) {
            return this.addNewlineIfNeeded(node, new WriteReadOnlyGlobalNode(this.context, fullSourceSection, name, rhs));
        }
        if (THREAD_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ThreadLocalObjectNode threadLocalVariablesObjectNode = ThreadLocalObjectNodeGen.create(this.context, fullSourceSection);
            return this.addNewlineIfNeeded(node, new WriteInstanceVariableNode(this.context, fullSourceSection, name, threadLocalVariablesObjectNode, rhs));
        }
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            ReadLocalNode localVarNode;
            if (this.environment.getNeverAssignInParentScope()) {
                this.environment.declareVar(name);
            }
            if ((localVarNode = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection)) == null) {
                if (this.environment.hasOwnScopeForAssignments()) {
                    this.environment.declareVar(node.getName());
                }
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
                localVarNode = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection);
                if (localVarNode == null) {
                    throw new RuntimeException("shouldn't be here");
                }
            }
            RubyNode assignment = localVarNode.makeWriteNode(rhs);
            if (name.equals("$_") || name.equals("$~")) {
                assignment = new GetFromThreadLocalNode(this.context, fullSourceSection, assignment);
            }
            return this.addNewlineIfNeeded(node, assignment);
        }
        WriteGlobalVariableNode writeGlobalVariableNode = WriteGlobalVariableNodeGen.create(this.context, fullSourceSection, name, rhs);
        RubyNode translated = name.equals("$0") ? WriteProgramNameNodeGen.create(this.context, fullSourceSection, writeGlobalVariableNode) : writeGlobalVariableNode;
        return this.addNewlineIfNeeded(node, translated);
    }

    @Override
    public RubyNode visitGlobalVarNode(GlobalVarParseNode node) {
        RubyNode ret;
        String name = node.getName();
        if (GLOBAL_VARIABLE_ALIASES.containsKey(name)) {
            name = (String)GLOBAL_VARIABLE_ALIASES.get(name);
        }
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (FRAME_LOCAL_GLOBAL_VARIABLES.contains(name)) {
            RubyNode readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
            if (readNode == null) {
                this.environment.declareVarInMethodScope(name);
                readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
            }
            if (name.equals("$_")) {
                readNode = this.getSourcePath(sourceSection).equals(this.buildCorePath("regexp.rb")) ? new RubiniusLastStringReadNode(this.context, fullSourceSection) : new GetFromThreadLocalNode(this.context, fullSourceSection, readNode);
            } else if (name.equals("$~")) {
                readNode = new GetFromThreadLocalNode(this.context, fullSourceSection, readNode);
            }
            ret = readNode;
        } else {
            ret = THREAD_LOCAL_GLOBAL_VARIABLES.contains(name) ? new ReadThreadLocalGlobalVariableNode(this.context, fullSourceSection, name, ALWAYS_DEFINED_GLOBALS.contains(name)) : (name.equals("$@") ? new ReadLastBacktraceNode(this.context, fullSourceSection) : ReadGlobalVariableNodeGen.create(this.context, fullSourceSection, name));
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitHashNode(HashParseNode node) {
        RubyNode ret;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ArrayList<RubyNode> hashConcats = new ArrayList<RubyNode>();
        ArrayList<RubyNode> keyValues = new ArrayList<RubyNode>();
        for (KeyValuePair<ParseNode, ParseNode> pair : node.getPairs()) {
            if (pair.getKey() == null) {
                HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, fullSourceSection, keyValues.toArray(new RubyNode[keyValues.size()]));
                hashConcats.add(hashLiteralSoFar);
                hashConcats.add(HashCastNodeGen.create(this.context, fullSourceSection, ((ParseNode)pair.getValue()).accept(this)));
                keyValues.clear();
                continue;
            }
            keyValues.add(((ParseNode)pair.getKey()).accept(this));
            if (pair.getValue() == null) {
                keyValues.add(this.nilNode(this.source, sourceSection));
                continue;
            }
            keyValues.add(((ParseNode)pair.getValue()).accept(this));
        }
        HashLiteralNode hashLiteralSoFar = HashLiteralNode.create(this.context, fullSourceSection, keyValues.toArray(new RubyNode[keyValues.size()]));
        hashConcats.add(hashLiteralSoFar);
        if (hashConcats.size() == 1) {
            ret = (RubyNode)hashConcats.get(0);
            return this.addNewlineIfNeeded(node, ret);
        }
        ret = new ConcatHashLiteralNode(this.context, fullSourceSection, hashConcats.toArray(new RubyNode[hashConcats.size()]));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitIfNode(IfParseNode node) {
        RubyNode ret;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode condition = this.translateNodeOrNil(sourceSection, node.getCondition());
        ParseNode thenBody = node.getThenBody();
        ParseNode elseBody = node.getElseBody();
        if (thenBody != null && elseBody != null) {
            RubyNode thenBodyTranslated = thenBody.accept(this);
            RubyNode elseBodyTranslated = elseBody.accept(this);
            ret = new IfElseNode(condition, thenBodyTranslated, elseBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else if (thenBody != null) {
            RubyNode thenBodyTranslated = thenBody.accept(this);
            ret = new IfNode(condition, thenBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else if (elseBody != null) {
            RubyNode elseBodyTranslated = elseBody.accept(this);
            ret = new UnlessNode(condition, elseBodyTranslated);
            ret.unsafeSetSourceSection(sourceSection);
        } else {
            ret = BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(condition, new NilLiteralNode(this.context, fullSourceSection, true)));
        }
        return ret;
    }

    @Override
    public RubyNode visitInstAsgnNode(InstAsgnParseNode node) {
        String corePath;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = node.getName();
        RubyNode rhs = node.getValueNode() == null ? new DeadNode(this.context, fullSourceSection, new Exception("null RHS of instance variable assignment")) : node.getValueNode().accept(this);
        RaiseIfFrozenNode self = new RaiseIfFrozenNode(this.context, fullSourceSection, new SelfNode(this.environment.getFrameDescriptor()));
        String path = this.getSourcePath(sourceSection);
        if (path.equals((corePath = this.buildCorePath("")) + "hash.rb")) {
            if (name.equals("@default")) {
                HashNodes.SetDefaultValueNode ret = HashNodesFactory.SetDefaultValueNodeFactory.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@default_proc")) {
                HashNodes.SetDefaultProcNode ret = HashNodesFactory.SetDefaultProcNodeFactory.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (path.equals(corePath + "range.rb")) {
            if (name.equals("@begin")) {
                RangeNodes.InternalSetBeginNode ret = RangeNodesFactory.InternalSetBeginNodeGen.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@end")) {
                RangeNodes.InternalSetEndNode ret = RangeNodesFactory.InternalSetEndNodeGen.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@excl")) {
                RangeNodes.InternalSetExcludeEndNode ret = RangeNodesFactory.InternalSetExcludeEndNodeGen.create(self, rhs);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        } else if (path.equals(corePath + "io.rb") && (name.equals("@used") || name.equals("@total") || name.equals("@lineno"))) {
            WriteInstanceVariableNode ret = new WriteInstanceVariableNode(this.context, fullSourceSection, name, self, IntegerCastNodeGen.create(this.context, fullSourceSection, rhs));
            return this.addNewlineIfNeeded(node, ret);
        }
        WriteInstanceVariableNode ret = new WriteInstanceVariableNode(this.context, fullSourceSection, name, self, rhs);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitInstVarNode(InstVarParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        SelfNode self = new SelfNode(this.environment.getFrameDescriptor());
        String path = this.getSourcePath(sourceSection);
        String corePath = this.buildCorePath("");
        if (path.equals(corePath + "regexp.rb")) {
            if (name.equals("@source")) {
                MatchDataNodes.RubiniusSourceNode ret = MatchDataNodesFactory.RubiniusSourceNodeGen.create(self);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@regexp")) {
                MatchDataNodes.RegexpNode ret = MatchDataNodesFactory.RegexpNodeFactory.create(new RubyNode[]{self});
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
            if (name.equals("@names")) {
                RegexpNodes.RubiniusNamesNode ret = RegexpNodesFactory.RubiniusNamesNodeGen.create(self);
                ret.unsafeSetSourceSection(sourceSection);
                return this.addNewlineIfNeeded(node, ret);
            }
        }
        ReadInstanceVariableNode ret = new ReadInstanceVariableNode(this.context, sourceSection.toSourceSection(this.source), name, self);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitIterNode(IterParseNode node) {
        return this.translateBlockLikeNode(node, false);
    }

    @Override
    public RubyNode visitLambdaNode(LambdaParseNode node) {
        return this.translateBlockLikeNode(node, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateBlockLikeNode(IterParseNode node, boolean isLambda) {
        BlockDefinitionNode definitionNode;
        ProcType type;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        ArgsParseNode argsNode = node.getArgsNode();
        boolean hasOwnScope = isLambda || !this.translatingForStatement;
        String name = isLambda ? "(lambda)" : this.getIdentifierInNewEnvironment(true, this.currentCallMethodName);
        boolean isProc = !isLambda;
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection.toSourceSection(this.source), this.environment.getLexicalScope(), MethodTranslator.getArity(argsNode), name, true, Helpers.argsNodeToArgumentDescriptors(argsNode), false, false, false);
        String namedMethodName = isLambda ? sharedMethodInfo.getName() : this.environment.getNamedMethodName();
        ParseEnvironment parseEnvironment = this.environment.getParseEnvironment();
        ReturnID returnID = isLambda ? parseEnvironment.allocateReturnID() : this.environment.getReturnID();
        TranslatorEnvironment newEnvironment = new TranslatorEnvironment(this.context, this.environment, parseEnvironment, returnID, hasOwnScope, false, sharedMethodInfo, namedMethodName, this.environment.getBlockDepth() + 1, parseEnvironment.allocateBreakID());
        MethodTranslator methodCompiler = new MethodTranslator(this.currentNode, this.context, this, newEnvironment, true, this.source, argsNode);
        if (isProc) {
            methodCompiler.translatingForStatement = this.translatingForStatement;
        }
        methodCompiler.frameOnStackMarkerSlotStack = this.frameOnStackMarkerSlotStack;
        ProcType procType = type = isLambda ? ProcType.LAMBDA : ProcType.PROC;
        if (isLambda) {
            this.frameOnStackMarkerSlotStack.push(BAD_FRAME_SLOT);
        }
        try {
            definitionNode = methodCompiler.compileBlockNode(sourceSection, sharedMethodInfo.getName(), node.getBodyNode(), sharedMethodInfo, type, node.getScope().getVariables());
        }
        finally {
            if (isLambda) {
                this.frameOnStackMarkerSlotStack.pop();
            }
        }
        return this.addNewlineIfNeeded(node, definitionNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitLocalAsgnNode(LocalAsgnParseNode node) {
        RubyNode rhs;
        ReadLocalNode lhs;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        if (this.environment.getNeverAssignInParentScope()) {
            this.environment.declareVar(node.getName());
        }
        if ((lhs = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection)) == null) {
            if (this.environment.hasOwnScopeForAssignments()) {
                this.environment.declareVar(node.getName());
            } else {
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(node.getName());
            }
            lhs = this.environment.findLocalVarNode(node.getName(), this.source, sourceSection);
            if (lhs == null) {
                throw new RuntimeException("shouldn't be here");
            }
        }
        if (node.getValueNode() == null) {
            rhs = new DeadNode(this.context, sourceSection.toSourceSection(this.source), new Exception());
        } else {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.push(sourceSection);
            }
            try {
                rhs = node.getValueNode().accept(this);
            }
            finally {
                if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                    this.parentSourceSection.pop();
                }
            }
        }
        RubyNode ret = lhs.makeWriteNode(rhs);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitLocalVarNode(LocalVarParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        String name = node.getName();
        ReadLocalNode readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
        if (readNode == null) {
            this.environment.declareVar(node.getName());
            readNode = this.environment.findLocalVarNode(name, this.source, sourceSection);
        }
        return this.addNewlineIfNeeded(node, readNode);
    }

    @Override
    public RubyNode visitMatchNode(MatchParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new GlobalVarParseNode(node.getPosition(), "$_"), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getRegexpNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMatch2Node(Match2ParseNode node) {
        RegexpParseNode regexpNode;
        Regex regex;
        if (node.getReceiverNode() instanceof RegexpParseNode && (regex = new Regex((regexpNode = (RegexpParseNode)node.getReceiverNode()).getValue().bytes(), 0, regexpNode.getValue().length(), regexpNode.getOptions().toOptions(), regexpNode.getEncoding(), Syntax.RUBY)).numberOfNames() > 0) {
            Iterator i = regex.namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                TranslatorEnvironment environmentToDeclareIn = this.environment;
                while (!environmentToDeclareIn.hasOwnScopeForAssignments()) {
                    environmentToDeclareIn = environmentToDeclareIn.getParent();
                }
                environmentToDeclareIn.declareVar(name);
            }
        }
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMatch3Node(Match3ParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), node.getValueNode(), new ParseNode[0]);
        CallParseNode callNode = new CallParseNode(node.getPosition(), node.getReceiverNode(), "=~", argsNode, null);
        this.copyNewline(node, callNode);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitModuleNode(ModuleParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        String name = node.getCPath().getName();
        RubyNode lexicalParent = this.translateCPath(sourceSection, node.getCPath());
        DefineModuleNode defineModuleNode = DefineModuleNodeGen.create(this.context, fullSourceSection, name, lexicalParent);
        RubyNode ret = this.openModule(sourceSection, defineModuleNode, name, node.getBodyNode(), false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitMultipleAsgnNode(MultipleAsgnParseNode node) {
        ArrayList<RubyNode> sequence;
        RubyNode result;
        RubyNode rhsTranslated;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ListParseNode preArray = node.getPre();
        ListParseNode postArray = node.getPost();
        ParseNode rhs = node.getValueNode();
        if (rhs == null) {
            this.context.getJRubyRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), "no RHS for multiple assignment - using nil");
            rhsTranslated = this.nilNode(this.source, sourceSection);
        } else {
            rhsTranslated = rhs.accept(this);
        }
        if (preArray != null && node.getPost() == null && node.getRest() == null && rhsTranslated instanceof ArrayLiteralNode && ((ArrayLiteralNode)rhsTranslated).getSize() == preArray.size()) {
            ArrayLiteralNode rhsArrayLiteral = (ArrayLiteralNode)rhsTranslated;
            int assignedValuesCount = preArray.size();
            RubyNode[] sequence2 = new RubyNode[assignedValuesCount * 2];
            RubyNode[] tempValues = new RubyNode[assignedValuesCount];
            for (int n = 0; n < assignedValuesCount; ++n) {
                String tempName = this.environment.allocateLocalTemp("multi");
                ReadLocalNode readTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection);
                RubyNode assignTemp = readTemp.makeWriteNode(rhsArrayLiteral.stealNode(n));
                RubyNode assignFinalValue = this.translateDummyAssignment(preArray.get(n), NodeUtil.cloneNode(readTemp));
                sequence2[n] = assignTemp;
                sequence2[assignedValuesCount + n] = assignFinalValue;
                tempValues[n] = NodeUtil.cloneNode(readTemp);
            }
            RubyNode blockNode = BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(sequence2));
            ArrayLiteralNode arrayNode = ArrayLiteralNode.create(this.context, sourceSection, tempValues);
            result = new ElidableResultNode(blockNode, arrayNode);
        } else if (preArray != null) {
            sequence = new ArrayList<RubyNode>();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.context, fullSourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, true, this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
            RubyNode writeTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            for (int n = 0; n < preArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, fullSourceSection, this.environment.findLocalVarNode(tempName, this.source, sourceSection), n);
                sequence.add(this.translateDummyAssignment(preArray.get(n), assignedValue));
            }
            if (node.getRest() != null) {
                RubyNode assignedValue = ArrayGetTailNodeGen.create(this.context, fullSourceSection, preArray.size(), this.environment.findLocalVarNode(tempName, this.source, sourceSection));
                if (postArray != null) {
                    assignedValue = ArrayDropTailNodeGen.create(this.context, fullSourceSection, postArray.size(), assignedValue);
                }
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            if (postArray != null) {
                ArrayList<RubyNode> smallerSequence = new ArrayList<RubyNode>();
                for (int n = 0; n < postArray.size(); ++n) {
                    RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, fullSourceSection, this.environment.findLocalVarNode(tempName, this.source, sourceSection), node.getPreCount() + n);
                    smallerSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
                }
                RubyNode smaller = BodyTranslator.sequence(this.context, this.source, sourceSection, smallerSequence);
                ArrayList<RubyNode> atLeastAsLargeSequence = new ArrayList<RubyNode>();
                for (int n = 0; n < postArray.size(); ++n) {
                    RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, fullSourceSection, this.environment.findLocalVarNode(tempName, this.source, sourceSection), -(postArray.size() - n));
                    atLeastAsLargeSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
                }
                RubyNode atLeastAsLarge = BodyTranslator.sequence(this.context, this.source, sourceSection, atLeastAsLargeSequence);
                IfElseNode assignPost = new IfElseNode(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.environment.findLocalVarNode(tempName, this.source, sourceSection)), atLeastAsLarge, smaller);
                sequence.add(assignPost);
            }
            result = new ElidableResultNode(BodyTranslator.sequence(this.context, this.source, sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() instanceof StarParseNode) {
            result = rhsTranslated;
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && !(rhs instanceof ArrayParseNode)) {
            SplatCastNode.NilBehavior nilBehavior;
            sequence = new ArrayList();
            if (this.translatingNextExpression) {
                nilBehavior = SplatCastNode.NilBehavior.EMPTY_ARRAY;
            } else if (rhsTranslated instanceof SplatCastNode && ((SplatCastNodeGen)rhsTranslated).getChild() instanceof NilLiteralNode) {
                rhsTranslated = ((SplatCastNodeGen)rhsTranslated).getChild();
                nilBehavior = SplatCastNode.NilBehavior.CONVERT;
            } else {
                nilBehavior = SplatCastNode.NilBehavior.ARRAY_WITH_NIL;
            }
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            SplatCastNode rhsSplatCast = SplatCastNodeGen.create(this.context, fullSourceSection, nilBehavior, true, this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
            String tempRHSSplattedName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempSplattedRHS = this.environment.findLocalVarNode(tempRHSSplattedName, this.source, sourceSection).makeWriteNode(rhsSplatCast);
            sequence.add(writeTempSplattedRHS);
            sequence.add(this.translateDummyAssignment(node.getRest(), this.environment.findLocalVarNode(tempRHSSplattedName, this.source, sourceSection)));
            ReadLocalNode assignmentResult = nilBehavior == SplatCastNode.NilBehavior.CONVERT ? this.environment.findLocalVarNode(tempRHSSplattedName, this.source, sourceSection) : this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection);
            result = new ElidableResultNode(BodyTranslator.sequence(this.context, this.source, sourceSection, sequence), assignmentResult);
        } else if (node.getPre() == null && node.getPost() == null && node.getRest() != null && rhs != null && rhs instanceof ArrayParseNode) {
            result = this.translateDummyAssignment(node.getRest(), rhsTranslated);
        } else if (node.getPre() == null && node.getRest() != null && node.getPost() != null) {
            sequence = new ArrayList();
            String tempRHSName = this.environment.allocateLocalTemp("rhs");
            RubyNode writeTempRHS = this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection).makeWriteNode(rhsTranslated);
            sequence.add(writeTempRHS);
            String tempName = this.environment.allocateLocalTemp("array");
            SplatCastNode splatCastNode = SplatCastNodeGen.create(this.context, fullSourceSection, this.translatingNextExpression ? SplatCastNode.NilBehavior.EMPTY_ARRAY : SplatCastNode.NilBehavior.ARRAY_WITH_NIL, false, this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
            RubyNode writeTemp = this.environment.findLocalVarNode(tempName, this.source, sourceSection).makeWriteNode(splatCastNode);
            sequence.add(writeTemp);
            if (node.getRest() != null) {
                ArrayDropTailNode assignedValue = ArrayDropTailNodeGen.create(this.context, fullSourceSection, postArray.size(), this.environment.findLocalVarNode(tempName, this.source, sourceSection));
                sequence.add(this.translateDummyAssignment(node.getRest(), assignedValue));
            }
            ArrayList<RubyNode> smallerSequence = new ArrayList<RubyNode>();
            for (int n = 0; n < postArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, fullSourceSection, this.environment.findLocalVarNode(tempName, this.source, sourceSection), node.getPreCount() + n);
                smallerSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            RubyNode smaller = BodyTranslator.sequence(this.context, this.source, sourceSection, smallerSequence);
            ArrayList<RubyNode> atLeastAsLargeSequence = new ArrayList<RubyNode>();
            for (int n = 0; n < postArray.size(); ++n) {
                RubyNode assignedValue = PrimitiveArrayNodeFactory.read(this.context, fullSourceSection, this.environment.findLocalVarNode(tempName, this.source, sourceSection), -(postArray.size() - n));
                atLeastAsLargeSequence.add(this.translateDummyAssignment(postArray.get(n), assignedValue));
            }
            RubyNode atLeastAsLarge = BodyTranslator.sequence(this.context, this.source, sourceSection, atLeastAsLargeSequence);
            IfElseNode assignPost = new IfElseNode(new ArrayIsAtLeastAsLargeAsNode(node.getPreCount() + node.getPostCount(), this.environment.findLocalVarNode(tempName, this.source, sourceSection)), atLeastAsLarge, smaller);
            sequence.add(assignPost);
            result = new ElidableResultNode(BodyTranslator.sequence(this.context, this.source, sourceSection, sequence), this.environment.findLocalVarNode(tempRHSName, this.source, sourceSection));
        } else {
            this.context.getJRubyRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), node + " unknown form of multiple assignment");
            result = this.nilNode(this.source, sourceSection);
        }
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context, fullSourceSection, this.context.getCoreStrings().ASSIGNMENT, result);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RubyNode visitNextNode(NextParseNode node) {
        RubyNode resultNode;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreExceptions().syntaxError("Invalid next", this.currentNode));
        }
        boolean t = this.translatingNextExpression;
        this.translatingNextExpression = true;
        if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
            this.parentSourceSection.push(sourceSection);
        }
        try {
            resultNode = node.getValueNode().accept(this);
        }
        finally {
            if (node.getValueNode().getPosition() == InvalidSourcePosition.INSTANCE) {
                this.parentSourceSection.pop();
            }
            this.translatingNextExpression = t;
        }
        NextNode ret = new NextNode(resultNode);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitNilNode(NilParseNode node) {
        if (node.getPosition() == InvalidSourcePosition.INSTANCE && this.parentSourceSection.peek() == null) {
            DeadNode ret = new DeadNode(this.context, null, new Exception());
            return this.addNewlineIfNeeded(node, ret);
        }
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode ret = this.nilNode(this.source, sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitNthRefNode(NthRefParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        this.environment.declareVarInMethodScope("$~");
        GetFromThreadLocalNode readMatchNode = new GetFromThreadLocalNode(this.context, fullSourceSection, this.environment.findLocalVarNode("$~", this.source, sourceSection));
        ReadMatchReferenceNode ret = new ReadMatchReferenceNode(this.context, fullSourceSection, readMatchNode, node.getMatchNumber());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnAndNode(OpAsgnAndParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ParseNode lhs = node.getFirstNode();
        ParseNode rhs = node.getSecondNode();
        AndNode andNode = new AndNode(lhs.accept(this), rhs.accept(this));
        andNode.unsafeSetSourceSection(sourceSection);
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context, fullSourceSection, this.context.getCoreStrings().ASSIGNMENT, andNode);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnNode(OpAsgnParseNode node) {
        ISourcePosition pos = node.getPosition();
        if (node.getOperatorName().equals("||")) {
            String temp = this.environment.allocateLocalTemp("opassign");
            LocalAsgnParseNode writeReceiverToTemp = new LocalAsgnParseNode(pos, temp, 0, node.getReceiverNode());
            LocalVarParseNode readReceiverFromTemp = new LocalVarParseNode(pos, 0, temp);
            CallParseNode readMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName(), null, null);
            CallParseNode writeMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName() + "=", BodyTranslator.buildArrayNode(pos, node.getValueNode(), new ParseNode[0]), null);
            RubySourceSection sourceSection = this.translate(pos);
            SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
            RubyNode lhs = ((ParseNode)readMethod).accept(this);
            RubyNode rhs = ((ParseNode)writeMethod).accept(this);
            DefinedWrapperNode ret = new DefinedWrapperNode(this.context, fullSourceSection, this.context.getCoreStrings().ASSIGNMENT, BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(((ParseNode)writeReceiverToTemp).accept(this), new OrNode(lhs, rhs))));
            return this.addNewlineIfNeeded(node, ret);
        }
        String temp = this.environment.allocateLocalTemp("opassign");
        LocalAsgnParseNode writeReceiverToTemp = new LocalAsgnParseNode(pos, temp, 0, node.getReceiverNode());
        LocalVarParseNode readReceiverFromTemp = new LocalVarParseNode(pos, 0, temp);
        CallParseNode readMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName(), null, null);
        CallParseNode operation = new CallParseNode(pos, readMethod, node.getOperatorName(), BodyTranslator.buildArrayNode(pos, node.getValueNode(), new ParseNode[0]), null);
        CallParseNode writeMethod = new CallParseNode(pos, readReceiverFromTemp, node.getVariableName() + "=", BodyTranslator.buildArrayNode(pos, operation, new ParseNode[0]), null);
        BlockParseNode block = new BlockParseNode(pos);
        block.add(writeReceiverToTemp);
        RubyNode writeTemp = ((ParseNode)writeReceiverToTemp).accept(this);
        RubyNode body = ((ParseNode)writeMethod).accept(this);
        RubySourceSection sourceSection = this.translate(pos);
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        if (node.isLazy()) {
            ReadLocalNode readLocal = this.environment.findLocalVarNode(temp, this.source, sourceSection);
            body = new IfNode(new NotNode(new IsNilNode(this.context, fullSourceSection, readLocal)), body);
            body.unsafeSetSourceSection(sourceSection);
        }
        RubyNode ret = BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(writeTemp, body));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpAsgnOrNode(OpAsgnOrParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode lhs = node.getFirstNode().accept(this);
        RubyNode rhs = node.getSecondNode().accept(this);
        if (node.getFirstNode().needsDefinitionCheck() && !(node.getFirstNode() instanceof InstVarParseNode)) {
            DefinedNode defined = new DefinedNode(this.context, this.translateSourceSection(this.source, lhs.getRubySourceSection()), lhs);
            lhs = new AndNode(defined, lhs);
        }
        DefinedWrapperNode ret = new DefinedWrapperNode(this.context, fullSourceSection, this.context.getCoreStrings().ASSIGNMENT, new OrNode(lhs, rhs));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitOpElementAsgnNode(OpElementAsgnParseNode node) {
        ParseNode index = node.getArgsNode() == null ? null : node.getArgsNode().childNodes().get(0);
        ParseNode operand = node.getValueNode();
        String temp = this.environment.allocateLocalTemp("opelementassign");
        LocalAsgnParseNode writeArrayToTemp = new LocalAsgnParseNode(node.getPosition(), temp, 0, node.getReceiverNode());
        LocalVarParseNode readArrayFromTemp = new LocalVarParseNode(node.getPosition(), 0, temp);
        CallParseNode arrayRead = new CallParseNode(node.getPosition(), readArrayFromTemp, "[]", BodyTranslator.buildArrayNode(node.getPosition(), index, new ParseNode[0]), null);
        String op = node.getOperatorName();
        ParseNode operation = null;
        operation = op.equals("||") ? new OrParseNode(node.getPosition(), arrayRead, operand) : (op.equals("&&") ? new AndParseNode(node.getPosition(), arrayRead, operand) : new CallParseNode(node.getPosition(), arrayRead, node.getOperatorName(), BodyTranslator.buildArrayNode(node.getPosition(), operand, new ParseNode[0]), null));
        this.copyNewline(node, operation);
        CallParseNode arrayWrite = new CallParseNode(node.getPosition(), readArrayFromTemp, "[]=", BodyTranslator.buildArrayNode(node.getPosition(), index, operation), null);
        BlockParseNode block = new BlockParseNode(node.getPosition());
        block.add(writeArrayToTemp);
        block.add(arrayWrite);
        RubyNode ret = block.accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    private static ArrayParseNode buildArrayNode(ISourcePosition sourcePosition, ParseNode first, ParseNode ... rest) {
        if (first == null) {
            return new ArrayParseNode(sourcePosition);
        }
        ArrayParseNode array = new ArrayParseNode(sourcePosition, first);
        for (ParseNode node : rest) {
            array.add(node);
        }
        return array;
    }

    @Override
    public RubyNode visitOrNode(OrParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode x = this.translateNodeOrNil(sourceSection, node.getFirstNode());
        RubyNode y = this.translateNodeOrNil(sourceSection, node.getSecondNode());
        OrNode ret = new OrNode(x, y);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitPreExeNode(PreExeParseNode node) {
        RubyNode ret = node.getBodyNode().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitPostExeNode(PostExeParseNode node) {
        RubyNode ret = node.getBodyNode().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitRationalNode(RationalParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode ret = this.translateRationalComplex(sourceSection, "Rational", new LongFixnumLiteralNode(this.context, fullSourceSection, node.getNumerator()), new LongFixnumLiteralNode(this.context, fullSourceSection, node.getDenominator()));
        return this.addNewlineIfNeeded(node, ret);
    }

    private RubyNode translateRationalComplex(RubySourceSection sourceSection, String name, RubyNode a, RubyNode b) {
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        ObjectLiteralNode moduleNode = new ObjectLiteralNode(this.context, fullSourceSection, this.context.getCoreLibrary().getObjectClass());
        ReadConstantNode receiver = new ReadConstantNode(this.context, fullSourceSection, moduleNode, name);
        RubyNode[] arguments = new RubyNode[]{a, b};
        RubyCallNodeParameters parameters = new RubyCallNodeParameters(this.context, fullSourceSection, receiver, "convert", null, arguments, false, true);
        return new RubyCallNode(parameters);
    }

    @Override
    public RubyNode visitRedoNode(RedoParseNode node) {
        if (!this.environment.isBlock() && !this.translatingWhile) {
            throw new RaiseException(this.context.getCoreExceptions().syntaxError("Invalid redo", this.currentNode));
        }
        RedoNode ret = new RedoNode();
        ret.unsafeSetSourceSection(this.translate(node.getPosition()));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitRegexpNode(RegexpParseNode node) {
        Rope rope = StringOperations.ropeFromByteList(node.getValue());
        RegexpOptions options = node.getOptions();
        options.setLiteral(true);
        Regex regex = RegexpNodes.compile(this.currentNode, this.context, rope, options);
        Rope updatedRope = (Rope)regex.getUserObject();
        DynamicObject regexp = RegexpNodes.createRubyRegexp(this.context.getCoreLibrary().getRegexpFactory(), regex, updatedRope, options);
        ObjectLiteralNode literalNode = new ObjectLiteralNode(this.context, this.translate(node.getPosition()).toSourceSection(this.source), regexp);
        return this.addNewlineIfNeeded(node, literalNode);
    }

    public static boolean all7Bit(byte[] bytes) {
        for (int n = 0; n < bytes.length; ++n) {
            if (bytes[n] < 0) {
                return false;
            }
            if (bytes[n] != 92 || n + 1 >= bytes.length || bytes[n + 1] != 120) continue;
            boolean isSecondHex = n + 3 < bytes.length && Character.digit(bytes[n + 3], 16) != -1;
            String num = isSecondHex ? new String(Arrays.copyOfRange(bytes, n + 2, n + 4), StandardCharsets.UTF_8) : new String(Arrays.copyOfRange(bytes, n + 2, n + 3), StandardCharsets.UTF_8);
            int b = Integer.parseInt(num, 16);
            if (b > 127) {
                return false;
            }
            if (isSecondHex) {
                n += 3;
                continue;
            }
            n += 2;
        }
        return true;
    }

    @Override
    public RubyNode visitRescueNode(RescueParseNode node) {
        RescueAnyNode rescueNode;
        RubyNode bodyNode;
        RescueBodyParseNode rescueBody;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode tryPart = node.getBodyNode() == null || node.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(this.source, sourceSection) : node.getBodyNode().accept(this);
        ArrayList<RescueNode> rescueNodes = new ArrayList<RescueNode>();
        if (this.context.getOptions().BACKTRACES_OMIT_UNUSED && rescueBody != null && rescueBody.getExceptionNodes() == null && rescueBody.getBodyNode() instanceof SideEffectFree && (!(rescueBody.getBodyNode() instanceof GlobalVarParseNode) || !((GlobalVarParseNode)rescueBody.getBodyNode()).getName().equals("$!")) && rescueBody.getOptRescueNode() == null) {
            tryPart = new DisablingBacktracesNode(this.context, fullSourceSection, tryPart);
            bodyNode = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
            rescueNode = new RescueAnyNode(this.context, fullSourceSection, bodyNode);
            rescueNodes.add(rescueNode);
        } else {
            for (rescueBody = node.getRescueNode(); rescueBody != null; rescueBody = rescueBody.getOptRescueNode()) {
                if (rescueBody.getExceptionNodes() != null) {
                    RescueNode rescueNode2;
                    if (rescueBody.getExceptionNodes() instanceof ArrayParseNode) {
                        ParseNode[] exceptionNodes = ((ArrayParseNode)rescueBody.getExceptionNodes()).children();
                        RubyNode[] handlingClasses = new RubyNode[exceptionNodes.length];
                        for (int n = 0; n < handlingClasses.length; ++n) {
                            handlingClasses[n] = exceptionNodes[n].accept(this);
                        }
                        RubyNode translatedBody = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
                        rescueNode2 = new RescueClassesNode(this.context, fullSourceSection, handlingClasses, translatedBody);
                        rescueNodes.add(rescueNode2);
                        continue;
                    }
                    if (rescueBody.getExceptionNodes() instanceof SplatParseNode) {
                        SplatParseNode splat = (SplatParseNode)rescueBody.getExceptionNodes();
                        RubyNode splatTranslated = this.translateNodeOrNil(sourceSection, splat.getValue());
                        RubyNode bodyTranslated = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
                        rescueNode2 = new RescueSplatNode(this.context, fullSourceSection, splatTranslated, bodyTranslated);
                        rescueNodes.add(rescueNode2);
                        continue;
                    }
                    this.unimplemented(node);
                    continue;
                }
                bodyNode = rescueBody.getBodyNode() == null || rescueBody.getBodyNode().getPosition() == InvalidSourcePosition.INSTANCE ? this.nilNode(this.source, sourceSection) : rescueBody.getBodyNode().accept(this);
                rescueNode = new RescueAnyNode(this.context, fullSourceSection, bodyNode);
                rescueNodes.add(rescueNode);
            }
        }
        RubyNode elsePart = node.getElseNode() == null || node.getElseNode().getPosition() == InvalidSourcePosition.INSTANCE ? null : node.getElseNode().accept(this);
        TryNode ret = new TryNode(this.context, fullSourceSection, new ExceptionTranslatingNode(this.context, fullSourceSection, tryPart, UnsupportedOperationBehavior.TYPE_ERROR), rescueNodes.toArray(new RescueNode[rescueNodes.size()]), elsePart);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitRetryNode(RetryParseNode node) {
        RetryNode ret = new RetryNode();
        ret.unsafeSetSourceSection(this.translate(node.getPosition()));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitReturnNode(ReturnParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode translatedChild = node.getValueNode().accept(this);
        ReturnNode ret = new ReturnNode(this.environment.getReturnID(), translatedChild);
        ret.unsafeSetSourceSection(sourceSection);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSClassNode(SClassParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode receiverNode = node.getReceiverNode().accept(this);
        SingletonClassNode singletonClassNode = SingletonClassNodeGen.create(this.context, fullSourceSection, receiverNode);
        RubyNode ret = this.openModule(sourceSection, singletonClassNode, "(singleton-def)", node.getBodyNode(), true);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSValueNode(SValueParseNode node) {
        RubyNode ret = node.getValue().accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSelfNode(SelfParseNode node) {
        SelfNode ret = new SelfNode(this.environment.getFrameDescriptor());
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSplatNode(SplatParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        RubyNode value = this.translateNodeOrNil(sourceSection, node.getValue());
        SplatCastNode ret = SplatCastNodeGen.create(this.context, sourceSection.toSourceSection(this.source), SplatCastNode.NilBehavior.CONVERT, false, value);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitStrNode(StrParseNode node) {
        RubyNode ret;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        ByteList byteList = node.getValue();
        int codeRange = node.getCodeRange();
        Rope rope = this.context.getRopeTable().getRope(byteList.bytes(), byteList.getEncoding(), CodeRange.fromInt(codeRange));
        if (node.isFrozen() && !this.getSourcePath(sourceSection).startsWith(this.context.getCoreLibrary().getCoreLoadPath() + "/core/")) {
            DynamicObject frozenString = this.context.getFrozenStrings().getFrozenString(rope);
            ret = new DefinedWrapperNode(this.context, sourceSection.toSourceSection(this.source), this.context.getCoreStrings().METHOD, new ObjectLiteralNode(this.context, null, frozenString));
        } else {
            ret = new StringLiteralNode(this.context, sourceSection.toSourceSection(this.source), rope);
        }
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitSymbolNode(SymbolParseNode node) {
        Rope rope = StringOperations.createRope(node.getName(), node.getEncoding());
        ObjectLiteralNode ret = new ObjectLiteralNode(this.context, this.translate(node.getPosition()).toSourceSection(this.source), this.context.getSymbolTable().getSymbol(rope));
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitTrueNode(TrueParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        BooleanLiteralNode ret = new BooleanLiteralNode(this.context, sourceSection.toSourceSection(this.source), true);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitUndefNode(UndefParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        DynamicObject nameSymbol = this.translateNameNodeToSymbol(node.getName());
        ModuleNodes.UndefMethodNode ret = ModuleNodesFactory.UndefMethodNodeFactory.create(this.context, fullSourceSection, new RubyNode[]{new RaiseIfFrozenNode(this.context, fullSourceSection, new GetDefaultDefineeNode(this.context, fullSourceSection)), new ObjectLiteralNode(this.context, fullSourceSection, new Object[]{nameSymbol})});
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitUntilNode(UntilParseNode node) {
        WhileParseNode whileNode = new WhileParseNode(node.getPosition(), node.getConditionNode(), node.getBodyNode(), node.evaluateAtStart());
        this.copyNewline(node, whileNode);
        RubyNode ret = this.translateWhileNode(whileNode, true);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitVCallNode(VCallParseNode node) {
        RubySourceSection sourceSection = this.translate(node.getPosition());
        if (node.getName().equals("undefined") && this.getSourcePath(sourceSection).startsWith(this.buildCorePath(""))) {
            ObjectLiteralNode ret = new ObjectLiteralNode(this.context, sourceSection.toSourceSection(this.source), this.context.getCoreLibrary().getRubiniusUndefined());
            return this.addNewlineIfNeeded(node, ret);
        }
        SelfParseNode receiver = new SelfParseNode(node.getPosition());
        CallParseNode callNode = new CallParseNode(node.getPosition(), receiver, node.getName(), null, null);
        this.copyNewline(node, callNode);
        RubyNode ret = this.translateCallNode(callNode, true, true, false);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitWhileNode(WhileParseNode node) {
        RubyNode ret = this.translateWhileNode(node, false);
        return this.addNewlineIfNeeded(node, ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RubyNode translateWhileNode(WhileParseNode node, boolean conditionInversed) {
        RubyNode body;
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        RubyNode condition = node.getConditionNode().accept(this);
        if (conditionInversed) {
            condition = new NotNode(condition);
        }
        BreakID whileBreakID = this.environment.getParseEnvironment().allocateBreakID();
        boolean oldTranslatingWhile = this.translatingWhile;
        this.translatingWhile = true;
        BreakID oldBreakID = this.environment.getBreakID();
        this.environment.setBreakIDForWhile(whileBreakID);
        this.frameOnStackMarkerSlotStack.push(BAD_FRAME_SLOT);
        try {
            body = this.translateNodeOrNil(sourceSection, node.getBodyNode());
        }
        finally {
            this.frameOnStackMarkerSlotStack.pop();
            this.environment.setBreakIDForWhile(oldBreakID);
            this.translatingWhile = oldTranslatingWhile;
        }
        WhileNode loop = node.evaluateAtStart() ? WhileNode.createWhile(this.context, fullSourceSection, condition, body) : WhileNode.createDoWhile(this.context, fullSourceSection, condition, body);
        CatchBreakNode ret = new CatchBreakNode(this.context, fullSourceSection, whileBreakID, loop);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitXStrNode(XStrParseNode node) {
        ArrayParseNode argsNode = BodyTranslator.buildArrayNode(node.getPosition(), new StrParseNode(node.getPosition(), node.getValue()), new ParseNode[0]);
        FCallParseNode callNode = new FCallParseNode(node.getPosition(), "`", argsNode, null);
        RubyNode ret = ((ParseNode)callNode).accept(this);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitYieldNode(YieldParseNode node) {
        boolean unsplat;
        ArrayList<ParseNode> arguments = new ArrayList<ParseNode>();
        ParseNode argsNode = node.getArgsNode();
        boolean bl = unsplat = argsNode instanceof SplatParseNode || argsNode instanceof ArgsCatParseNode;
        if (argsNode instanceof SplatParseNode) {
            argsNode = ((SplatParseNode)argsNode).getValue();
        }
        if (argsNode != null) {
            if (argsNode instanceof ListParseNode) {
                arguments.addAll(node.getArgsNode().childNodes());
            } else {
                arguments.add(node.getArgsNode());
            }
        }
        ArrayList<RubyNode> argumentsTranslated = new ArrayList<RubyNode>();
        for (ParseNode argument : arguments) {
            argumentsTranslated.add(argument.accept(this));
        }
        RubyNode[] argumentsTranslatedArray = argumentsTranslated.toArray(new RubyNode[argumentsTranslated.size()]);
        YieldExpressionNode ret = new YieldExpressionNode(this.context, this.translate(node.getPosition()).toSourceSection(this.source), unsplat, argumentsTranslatedArray);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitZArrayNode(ZArrayParseNode node) {
        RubyNode[] values = new RubyNode[]{};
        ArrayLiteralNode ret = ArrayLiteralNode.create(this.context, this.translate(node.getPosition()), values);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitBackRefNode(BackRefParseNode node) {
        int index = 0;
        switch (node.getType()) {
            case '`': {
                index = -1;
                break;
            }
            case '\'': {
                index = -2;
                break;
            }
            case '&': {
                index = -3;
                break;
            }
            case '+': {
                index = -4;
                break;
            }
            default: {
                throw new UnsupportedOperationException(Character.toString(node.getType()));
            }
        }
        RubySourceSection sourceSection = this.translate(node.getPosition());
        SourceSection fullSourceSection = sourceSection.toSourceSection(this.source);
        this.environment.declareVarInMethodScope("$~");
        GetFromThreadLocalNode readMatchNode = new GetFromThreadLocalNode(this.context, fullSourceSection, this.environment.findLocalVarNode("$~", this.source, sourceSection));
        ReadMatchReferenceNode ret = new ReadMatchReferenceNode(this.context, fullSourceSection, readMatchNode, index);
        return this.addNewlineIfNeeded(node, ret);
    }

    @Override
    public RubyNode visitStarNode(StarParseNode star) {
        return this.nilNode(this.source, this.translate(star.getPosition()));
    }

    protected RubyNode initFlipFlopStates(RubySourceSection sourceSection) {
        RubyNode[] initNodes = new RubyNode[this.environment.getFlipFlopStates().size()];
        for (int n = 0; n < initNodes.length; ++n) {
            initNodes[n] = new InitFlipFlopSlotNode(this.context, sourceSection.toSourceSection(this.source), this.environment.getFlipFlopStates().get(n));
        }
        return BodyTranslator.sequence(this.context, this.source, sourceSection, Arrays.asList(initNodes));
    }

    @Override
    protected RubyNode defaultVisit(ParseNode node) {
        RubyNode ret = this.unimplemented(node);
        return this.addNewlineIfNeeded(node, ret);
    }

    protected RubyNode unimplemented(ParseNode node) {
        this.context.getJRubyRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, this.source.getName(), node.getPosition().getLine(), node + " does nothing - translating as nil");
        RubySourceSection sourceSection = this.translate(node.getPosition());
        return this.nilNode(this.source, sourceSection);
    }

    public TranslatorEnvironment getEnvironment() {
        return this.environment;
    }

    protected String getIdentifierInNewEnvironment(boolean isBlock, String namedMethodName) {
        if (isBlock) {
            TranslatorEnvironment methodParent = this.environment;
            while (methodParent.isBlock()) {
                methodParent = methodParent.getParent();
            }
            if (this.environment.getBlockDepth() + 1 > 1) {
                return StringUtils.format("block (%d levels) in %s", this.environment.getBlockDepth() + 1, methodParent.getNamedMethodName());
            }
            return StringUtils.format("block in %s", methodParent.getNamedMethodName());
        }
        return namedMethodName;
    }

    @Override
    public RubyNode visitTruffleFragmentNode(TruffleFragmentParseNode node) {
        return this.addNewlineIfNeeded(node, node.getFragment());
    }

    @Override
    public RubyNode visitOther(ParseNode node) {
        if (node instanceof ReadLocalDummyParseNode) {
            ReadLocalDummyParseNode readLocal = (ReadLocalDummyParseNode)node;
            ReadLocalVariableNode ret = new ReadLocalVariableNode(this.context, readLocal.getSourceSection(), LocalVariableType.FRAME_LOCAL, readLocal.getFrameSlot());
            return this.addNewlineIfNeeded(node, ret);
        }
        throw new UnsupportedOperationException();
    }

    private void copyNewline(ParseNode from, ParseNode to) {
        if (from.isNewline()) {
            to.setNewline();
        }
    }

    private RubyNode addNewlineIfNeeded(ParseNode jrubyNode, RubyNode node) {
        if (jrubyNode.isNewline()) {
            RubySourceSection current = node.getEncapsulatingRubySourceSection();
            if (current == null) {
                return node;
            }
            if (this.context.getCoverageManager() != null) {
                this.context.getCoverageManager().setLineHasCode(this.source, current.getStartLine());
            }
            node.unsafeSetIsNewLine();
        }
        return node;
    }

    protected static class ArgumentsAndBlockTranslation {
        private final RubyNode block;
        private final RubyNode[] arguments;
        private final boolean isSplatted;
        private final FrameSlot frameOnStackMarkerSlot;

        public ArgumentsAndBlockTranslation(RubyNode block, RubyNode[] arguments, boolean isSplatted, FrameSlot frameOnStackMarkerSlot) {
            this.block = block;
            this.arguments = arguments;
            this.isSplatted = isSplatted;
            this.frameOnStackMarkerSlot = frameOnStackMarkerSlot;
        }

        public RubyNode getBlock() {
            return this.block;
        }

        public RubyNode[] getArguments() {
            return this.arguments;
        }

        public boolean isSplatted() {
            return this.isSplatted;
        }

        public FrameSlot getFrameOnStackMarkerSlot() {
            return this.frameOnStackMarkerSlot;
        }
    }
}

