/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.parser.ast.BinaryOperatorParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;
import org.jruby.truffle.parser.lexer.ISourcePosition;

public class OrParseNode
extends ParseNode
implements BinaryOperatorParseNode {
    private final ParseNode firstNode;
    private final ParseNode secondNode;

    public OrParseNode(ISourcePosition position, ParseNode firstNode, ParseNode secondNode) {
        super(position, firstNode.containsVariableAssignment() || secondNode.containsVariableAssignment());
        assert (firstNode != null) : "firstNode is not null";
        assert (secondNode != null) : "secondNode is not null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ORNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitOrNode(this);
    }

    @Override
    public ParseNode getFirstNode() {
        return this.firstNode;
    }

    @Override
    public ParseNode getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.firstNode, this.secondNode);
    }
}

