/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.Enum;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Enums"}, parent="Object")
public final class Enums
extends RubyObject {
    private final RubyArray allEnums;
    private final RubyHash symbolMap;
    private final RubyHash taggedEnums;

    public static RubyClass createEnumsClass(Ruby runtime, RubyModule ffiModule) {
        RubyClass enumsClass = ffiModule.defineClassUnder("Enums", runtime.getObject(), Allocator.INSTANCE);
        enumsClass.defineAnnotatedMethods(Enums.class);
        enumsClass.defineAnnotatedConstants(Enums.class);
        enumsClass.includeModule(ffiModule.getConstant("DataConverter"));
        return enumsClass;
    }

    private Enums(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.allEnums = RubyArray.newArray(runtime);
        this.taggedEnums = RubyHash.newHash(runtime);
        this.symbolMap = RubyHash.newHash(runtime);
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"<<"})
    public IRubyObject append(ThreadContext context, IRubyObject item) {
        IRubyObject tag2;
        if (!(item instanceof Enum)) {
            throw context.runtime.newTypeError(item, context.runtime.getFFI().ffiModule.getClass("Enum"));
        }
        this.allEnums.append(item);
        if (item != null && item != context.nil && (tag2 = ((Enum)item).tag(context)) != null && !tag2.isNil()) {
            this.taggedEnums.fastASet(tag2, item);
        }
        this.symbolMap.merge_bang(context, ((Enum)item).symbol_map(context), Block.NULL_BLOCK);
        return item;
    }

    public boolean isEmpty() {
        return this.allEnums.isEmpty() && this.symbolMap.isEmpty() && this.taggedEnums.isEmpty();
    }

    @JRubyMethod(name={"empty?"})
    public RubyBoolean empty_p() {
        return this.isEmpty() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"find"})
    public IRubyObject find(ThreadContext context, IRubyObject query) {
        if (this.taggedEnums.has_key_p(query).isTrue()) {
            return this.taggedEnums.fastARef(query);
        }
        for (int i2 = 0; i2 < this.allEnums.getLength(); ++i2) {
            IRubyObject item = this.allEnums.entry(i2);
            if (!((RubyArray)item.callMethod(context, "symbols")).include_p(context, query).isTrue()) continue;
            return item;
        }
        return context.runtime.getNil();
    }

    @JRubyMethod(name={"__map_symbol"})
    public IRubyObject mapSymbol(ThreadContext context, IRubyObject symbol) {
        return this.symbolMap.op_aref(context, symbol);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new Enums(runtime, klass);
        }
    }
}

